<%@ page import="com.paypal.sdk.profiles.APIProfile" %>
<%@ page import="com.paypal.sdk.profiles.ProfileFactory" %>
<%@ page import="org.apache.commons.fileupload.*" %>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page language="java" %>

<jsp:useBean id="caller" scope="session" class="com.paypal.sdk.services.CallerServices" />

<%	
	try {
		caller.initialize();
		
		APIProfile profile = ProfileFactory.createAPIProfile();
		if (FileUpload.isMultipartContent(request)) {
			DiskFileUpload upload = new DiskFileUpload();

			// Parse the request
			List items = upload.parseRequest(request);
	
			Iterator iter = items.iterator();
			while (iter.hasNext()) {
				FileItem item = (FileItem) iter.next();

				if (item.isFormField()) {
					String name = item.getFieldName();
					if (name.equals("apiUsername")) profile.setAPIUsername(item.getString());
					if (name.equals("apiPassword")) profile.setAPIPassword(item.getString());
					if (name.equals("privateKeyPassword")) profile.setPrivateKeyPassword(item.getString());
					if (name.equals("environment")) profile.setEnvironment(item.getString());
				} else {
					if ((item.getName() != null) && (item.getName().length() > 0)) {
						File cfile = new File(item.getName()); 
						File tosave = new File(getServletContext().getRealPath("/cert/"),cfile.getName());
						item.write(tosave);
						profile.setCertificateFile(tosave.getAbsolutePath());
					}
				}
			}
		} else  {
			profile.setAPIUsername(request.getParameter("apiUsername"));
			profile.setAPIPassword(request.getParameter("apiPassword"));
			profile.setCertificateFile(request.getParameter("certFilePath"));
			profile.setPrivateKeyPassword(request.getParameter("privateKeyPassword"));
			profile.setEnvironment(request.getParameter("environment"));
		}
	    caller.setAPIProfile(profile);
    	session.setAttribute("caller", caller);
    	response.sendRedirect("Calls.html");
	} catch (Exception e) {
		session.setAttribute("exception", e);
		response.sendRedirect("Error.jsp");
	}
%>