<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: index.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once '../lib/functions.inc.php';
require_once 'lib/functions.inc.php';

session_start();

if (empty($_SESSION['pphandler']) ||
    empty($_SESSION['pphandler_params']) ||
    empty($_SESSION['apiprofile']))
{
    trigger_error("Unknown Profile Handler or missing parameters", E_USER_ERROR);
    exit;
}

$handlerinst = &_getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);
if (Services_PayPal::isError($handlerinst))
{
    trigger_error($handlerinst->getMessage(), E_USER_ERROR);
    exit;
}

if (empty($_SESSION['apipassword'][$_SESSION['apiprofile']])) {
    if (empty($_POST['submitted'])) {
        require_once 'Services/PayPal/Profile/API.php';
        $profile =& APIProfile::getInstance($_SESSION['apiprofile'], $handlerinst);
        require 'pages/pw.html.php';
        exit;
    } else {
        $_SESSION['apipassword'][$_SESSION['apiprofile']] = $_POST['pw'];
    }
}

if (!empty($_SESSION['method'])) {
    header('Location: builder.php?method=' . $_SESSION['method']);
    exit;
}

$apimethods = Services_PayPal::getCallerServicesIntrospection();
require 'pages/index.html.php';
