<?php

/**
 * A simple Shopping Cart class for the Paypal Sample Application
 *
 * @author John Coggeshall
 */
class ShoppingCart {
    
    var $cart;
    
    /**
     * Constructor
     */
    function ShoppingCart()
    {
        $this->cart = array();
    }

    function setQuantity($id, $quantity)
    {
        if(!isset($this->cart[$id]))
        {
            return $this->addItem($id);
        }
        
        if($quantity <= 0)
        {
            return $this->removeAll($id);
        }
        
        $this->cart[$id] = $quantity;
    }
    /**
     * Adds an item to the shopping cart
     *
     * @param mixed The ID of the item being added to the cart
     */
    function addItem($id)
    {
        if(!isset($this->cart[$id]))
        {
            $this->cart[$id] = 1;
        }
        else 
        {
            $this->cart[$id]++;
        }
                
    }
    
    /**
     * Removes one of an item from the shopping cart
     *
     * @param mixed The ID of the item being deleted from the cart
     */
    function delItem($id)
    {
        if(!isset($this->cart[$id]))
        {
            return;
        }
        else 
        {
            if(!(--$this->cart[$id]))
            {
                unset($this->cart[$id]);
            }
        }
        
    }
    
    /**
     * Deletes all of a item from the shopping cart
     *
     * @param mixed The ID of the item being removed
     */
    function removeAll($id)
    {
        unset($this->cart[$id]);
    }
    
    /**
     * Returns all of the items in the shopping cart
     * 
     * @return array The items in the cart
     */
    function getItems()
    {
        return $this->cart;
    }
    
}