<?php
    require_once '../lib/functions.inc.php';
    session_start();

    if(empty($_GET['transID']))
    {
        do_error("No transaction ID specified", false);
    }
    
    if(empty($_GET['orderID']))
    {
        do_error("No Order ID specified", false);
    }
    
    
    $_info_box = "This page displays the result of the <code>GetTransactionDetails</code> API. Click the Refund Order hyperlink to initiate the <code>RefundTransaction</code> API.";

    /* This would normally not be necessary, but since we are performing the call on the fly
   we need to write the data in the certificate file to the filesystem temporarily to perform
   the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage(), true);
    }
    
    $details =& Services_PayPal::getType('GetTransactionDetailsRequestType');
    $details->setTransactionId($_GET['transID']);
    
    $result = $caller->GetTransactionDetails($details);
    @unlink($filename); 
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), false);
    }    
    
    $td = $result->PaymentTransactionDetails;

    $si['name'] = ($td->PayerInfo->Address->Name) ? $td->PayerInfo->Address->Name : "John Doe";
	$si['street1'] = ($td->PayerInfo->Address->Street1) ? $td->PayerInfo->Address->Street1 : "222 Anystreet";
	$si['street2'] = ($td->PayerInfo->Address->Street2) ? $td->PayerInfo->Address->Street2 : null;
	$si['city'] = ($td->PayerInfo->Address->CityName) ? $td->PayerInfo->Address->CityName : "Anytown";
	$si['state'] = ($td->PayerInfo->Address->StateOrProvince) ? $td->PayerInfo->Address->StateOrProvince : "CA";
	$si['country'] = ($td->PayerInfo->Address->CountryName) ? $td->PayerInfo->Address->CountryName : "US";
	$si['zip'] = ($td->PayerInfo->Address->PostalCode) ? $td->PayerInfo->Address->PostalCode : "60622";
					
    include_once '../lib/html/header.html.php';
?>
<table cellpadding="0" cellspacing="0" border="0" width="750">
<tr>
<td align="left">

	<table cellpadding="0" cellspacing="0" border="0" width="750" class="content">
	<tr>
	<td>
	
		<p class="title">Order Details</p>

		<p>Please review the order details below.</p>

		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="detail">
		<tr>
		<td>

			<form name="orderDetailsForm" action="orders.html" method="POST">
			
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>

				<td class="formLabel" valign="top"><p>Order ID:</p></td>
				<td class="formOutput">
					<p><?php print (int)$_GET['orderID']; ?></p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Order Status:</p></td>
				<td class="formOutput">

					<p><?php print $td->PaymentInfo->PaymentStatus; ?> <a href="refundOrder.php?transID=<?php print $_GET['transID']; ?>&orderID=<?php print (int)$_GET['orderID']; ?>">Refund Order</a></p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Date:</p></td>
				<td class="formOutput">
					<p><?php print date('m-d-Y h:i', strtotime($td->PaymentInfo->PaymentDate)); ?></p>
				</td>

				</tr>
				</table>
				
				<p class="heading">Shipping Details</p>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>
				<td class="formLabel" valign="top"><p>Ship To:</p></td>
				<td class="formOutput">
					<p>
                        <?php print $si['name']; ?>
					   <br/>
						<?php print $si['street1']; ?>
						<?php print $si['street2']; ?>
						<br/>
						<?php print $si['city']; ?>,
						<?php print $si['state']; ?>&nbsp;
						<?php print $si['zip']; ?>
						<br/>
						<?php print $si['country']; ?>
					</p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Shipping Method:</p></td>

				<td class="formOutput">
					<p>Standard shipping (3-5 business days)</p>
				</td>
				</tr>
				</table>
				
				<p class="heading">Payment Details</p>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>

				<td class="formLabel" valign="top"><p>Bill To:</p></td>
				<td class="formOutput">
				    <?php 
				        switch($td->PaymentInfo->TransactionType)
				        {
				            case "web-accept":
				                $trans_detail = str_repeat("*", strlen($td->PaymentInfo->ReceiptID)-4) . 
				                                 substr($td->PaymentInfo->ReceiptID,strlen($td->PaymentInfo->ReceiptID)-4);
				                break;
				            case "express-checkout":
				                $trans_detail = $td->PayerInfo->Payer;
				                break;
				            default:
				                $trans_detail = "unknown";
				                break;
				        }
				     ?>       
				           
					<p><?php print $td->PaymentInfo->TransactionType; ?> (<?php print $trans_detail; ?>)</p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Payment Method:</p></td>
				<td class="formOutput">

					<p>Via PayPal</p>
				</td>
				</tr>
				</table>
				
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel">

					<p class="orderTotalLbl"><b>Order Total:</b></p>
				</td>
				<td class="formOutput" align="right">
					<p class="orderTotal"><?php print $td->PaymentInfo->GrossAmount->_value; ?></p>
				</td>
				</tr>
				</table>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">

				<tr>
				<td class="formLabel"><p>&nbsp;</p></td>
				<td class="formOutput">
					<input type="button" onClick="window.location='viewOrders.php';" value="View All Orders" /> 
				</td>
				</tr>
				</table>
			</form>
		</td>

		</tr>
		</table>
	</td>
	</tr>
	</table>
</td>
</tr>
</table>
<?php include_once '../lib/html/footer.html.php'; ?>