<?php
/********************************************************************
*	Hotspot Authentication, Authorization and Accounting System
*
*	Module: 	phs2Pay-inc.php
*	Function:	Online Registration and Payment Module
*
*	2006-04-17 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/


ini_set('register_globals', '0');
require_once ('PEAR.php');
require_once ('DB.php');

/**********************************************
*	Class for all phs2Pay related functionality
*
***/
class phs2Pay {

	var $dbh = 0;
	var $rs = 0;
	var $table = '';

	/**
	* Constructor
	*/
	function phs2Pay ($param) {


    $this->dbh =& DB::Connect($param['dsn']);
    if (PEAR::isError($this->dbh)) {
		//if (DB::isError($this->dbh = DB::Connect($param['dsn']))) {
			global $globalref;
			$globalref = &$this;

			$this->db_errmsg = $this->dbh->getMessage();
			$this->retval = $this->db_errmsg;
      die('pointHotspot-Registration: '.$this->db_errmsg);
		} else {
            //$err = $this->dbh->autoCommit(False); // switch off autocommit
            //if (PEAR::isError($err) && $err->getCode() == DB_ERROR_NOT_CAPABLE) {
            //    die("whoops, Database has no transaction support!");
            //}
			//$this->table = $param['table'];
			$this->param = $param;
			$this->retval = Null;
		}
	}

/********************************************************************
*	validateUserInput
*	input:	rowin
*	return:	Null on success, else errmsg
*********************************************************************/

  function validateUserInput($rowin=Null) {
    $_errmsg = Null;
    if (!isset($rowin['update'])) { // update does not need username to be set
      if (empty($rowin['uuname'])) {
        $_errmsg = 'Login Id missing';
      } elseif (strlen($rowin['uuname']) < PHS_LEN_USER) {
        $_errmsg = 'Login Id too short! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (strlen($rowin['uuname']) > PHS_LEN_USER_MAX) {
        $_errmsg = 'Login Id too long! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (ereg('[^a-zA-Z0-9_\-\.]{1,}\ [a-zA-Z0-9_\-\.]{1,}', $rowin['uuname'])) {
        $_errmsg = 'Only use a-z 0-9 _.- and space for the Login Id';
      }
    } 
    if (is_null($_errmsg)) { 
      if (isset($rowin['user_value'])) { // update does not need password to be set
        if (empty($rowin['user_value'])) {
          $_errmsg = 'Password missing';
        } elseif (strlen($rowin['user_value']) < PHS_LEN_PW) {
          $_errmsg = 'Password too short! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (strlen($rowin['user_value']) > PHS_LEN_PW_MAX) {
          $_errmsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (ereg('[^a-zA-Z0-9_\-\.@\!\*]{1,}', $rowin['user_value'])) {
          $_errmsg = 'Only use a-z 0-9 _.-@!* and no spaces for the password';
        }
      }
    }
    if (is_null($_errmsg)) {
      if (empty($rowin['user_location'])) {
        $_errmsg = $rowin['client_address_location_str'] . ' missing';
      } elseif (strlen($rowin['user_location']) < PHS_LEN_LOCATION) {
        $_errmsg = $rowin['client_address_location_str'] . ' too short! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      } elseif (strlen($rowin['user_location']) > PHS_LEN_LOCATION_MAX) {
        $_errmsg = $rowin['client_address_location_str'] . ' too long! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      }
    }
      //print('err:'.$_errmsg);exit;

    return($_errmsg);

  }



/********************************************************************
*	Insert new User
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
*********************************************************************/

  function insertUser($rowin=Null) {
    $_return = Array(0, Null);
    //$this->db_errmsg = 'empty user input row';
    $colnames = '';	
    $colvalues = '';
    $radcolnames = '';	
    $radcolvalues = '';

    //    $_return[1] = Null;
    //    return($_return[1]);
    //print_r($rowin); exit;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // if ($key == 'order_id_pk') continue; // skip order id
        // sort all keys and values from ONE input row to multiple
        // database rows
        switch ($key) {
        case 'rad_usergroup_groupname';
        case 'client_address_location_str';
          continue 2; // continue foreach
        case 'user_stoptime';
          if (!empty($value)) {
            $colnames .= $key.',';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          }
          continue 2; // continue foreach
        case 'usttm';
          $colnames .= $key.',';
          $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          continue 2; // continue foreach
        }

        $colnames .= $key.',';
        // note: This technique requires all non-strings have to end with '_id'
        if (eregi('_id', $key) || $key == 'user_status') { // id is always NO string value, _alt_ for alteration values
          $colvalues .= (int)$value . ','; // not quoted 
        } else {
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
        }
      }
      $colnames .= 'user_ndate';
      $colvalues .= ' NOW() ,';
      $colnames .= ',user_ccid';
      $colvalues .= Phs_Ccid;
      $colnames .= ',user_attribute';
      $colvalues .= ",'User-Password'"; // RADIUS attribute
  
      $query = 'INSERT INTO ' . PHS_DBTABLE_USER . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      $colnames = 'usergroup_username';
      $colvalues = $this->dbh->quote($rowin['uuname']) . ','; // all quoted strings
      $colnames .= ',usergroup_groupname';
      $colvalues .= $this->dbh->quote($rowin['rad_usergroup_groupname']); // all quoted strings
      $colnames .= ',usergroup_ndate';
      $colvalues .= ', NOW() ';

        // insert into RADIUS usergroup table
      $radquery = 'INSERT INTO ' . PHS_DBTABLE_USERGROUP . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>insertUser:</b>>");
        print($query);
        print($radquery);
        print("<<b>END-DEBUG</b>\n");
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE
 
      if (!DB::isError($rs = $this->dbh->query($query))) {
        
          // this is HACK and bypasses PEAR abstraction layer!
        $id = mysql_insert_id($this->dbh->connection);
        
        //$this->logUser($rowin, PHS_LOGUS_INSERT);
        //print('Insert user OK');
          // insert into RADIUS usergroup tbale
        if (!DB::isError($rs = $this->dbh->query($radquery))) {
          //print('Insert user OK');
        } else {
          $this->db_errmsg = $rs->getMessage();
          $trans_error = True;
        }
      } else {
        //$this->logUser($rowin, PHS_LOGUS_IFAILED);
        $this->db_errmsg = $rs->getMessage();
        //print('Insert user NOT OK: '. $this->db_errmsg);
          // give some nicer error message
        if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
          $this->db_errmsg = 'Login Id already exists';
        }
        $trans_error = True;
      }

          // END TRANSACTION HERE
          
      //exit;
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->commit();
            //$this->dbh->rollback();
        //}
        $_return[0] = $id; // insert ID
        $_return[1] = Null;
        //return(Null);
      } else {
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->rollback();
        //}
        $_return[0] = 0; // insert ID does not exist
        $_return[1] = $this->db_errmsg;
        //return($this->db_errmsg);
      }
    }
    return($_return);
  }


/********************************************************************
*	Register User -> insert User and assign order
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
successful:
    [0] => Array
        (
          [0] => 62   -> Test for [0][0] > 0
            [1] => 
        )

    [1] => Array
        (
            [0] => ON69TE5986
            [1] => 
        )

unsuccessful:
    [0] => Array
        (
            [0] => 0
            [1] => Login Id already exists
        )

    [1] => Array    Since insert user failed, no attempt to insert order
        (
          [0] => 0  if 0 -> error, if > 0 OK
            [1] => 
        )
*********************************************************************/

  function registerUser($rowin=Null, $orderArray=Null) {
    $_resultArray = array(0 => array(0,Null), 1 => array(0,Null));
    $_resultArray1 = array();
    $_resultArray2 = array();

    if ($rowin <> Null && $orderArray <> Null) {
      $_resultArray1 = $this->insertUser($rowin);
      $_resultArray[0] = $_resultArray1;
      //print(' user inserted, insert order now ');
      if ($_resultArray1[1] == Null) { // success!
      $orderArray['order_user_id'] = $_resultArray1[0]; // get user_id
      //print(' inserting order now ');
        $_resultArray2 = $this->insertOrder($orderArray);
        $_resultArray[1] = $_resultArray2;
      }
    }
    //print_r($_resultArray1);
    //print_r($_resultArray2);
    //print_r($_resultArray);exit;
    return($_resultArray);
  }

/********************************************************************
*	Insert new Order
*	input:	orderArray, preformatted input row
*	return:	Order NUmber on success, else errmsg
* Note: Order Number and Invoice Number are the same
*********************************************************************/

  function insertOrder($orderArray=Null) {
    $_return = Array(0, Null);
    $_retry = 20; // try max of 20 times to insert order with unique order number

    //print_r($orderArray); //exit;

    if (!is_null($orderArray)) {
      do {
        $colnames = '';	
        $colvalues = '';
          // walk through input row
        foreach ($orderArray as $key => $value) {
          switch ($key) {
            case 'order_invoice_no':
                // value contains prefix, inject order number
            $orderNumber = $this->getOrderNumber();
            $value .= $orderNumber;
            $orderNumber = $value; // get complete order num for return value
            break;
          }
          $colnames .= $key.',';
          // note: This technique requires all non-strings have to end with '_id'
          if (eregi('_id', $key) || $key == 'order_status') { // id is always NO string value, _alt_ for alteration values
            $colvalues .= (int)$value . ','; // not quoted 
          } else {
            $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          }
        }
        $colnames .= 'order_ndate';
        $colvalues .= ' NOW() ';

    
        $query = 'INSERT INTO ' . PHS_DBTABLE_ORDER . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

        if ($GLOBALS['Phs_Debug'] > 30) {
          print("\n<br><b>insertOrder:</b>>");
          print($query);
          print("<<b>END-DEBUG</b>\n");
        }
        //exit;
        $trans_error = False;
        
        // BEGIN TRANSACTION HERE
   
        if (!DB::isError($rs = $this->dbh->query($query))) {
          //print('Insert user OK');
            // insert into RADIUS usergroup tbale
          $_retry = 0; // no more trying
        } else {
          //$this->db_errmsg = $rs->getMessage();
          //print('Insert user NOT OK: '. $this->db_errmsg);
            // give some nicer error message
          if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
            //$this->db_errmsg = 'Invoice No/Order Id already exists';
            //print(' OrderNum already there!: '.$orderNumber);
            continue; // try another one
          }
          $trans_error = True;
        }
      } while ($_retry-- > 0);

          // END TRANSACTION HERE
          
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        //$_return[0] = 0; // not important
        //$_return[1] = Null;
        //$_return[2] = $orderNumber;
        $_return = array(0 => $orderNumber, 1 => Null);
      } else {
        $_return = array(0 => 0, 1 => $this->db_errmsg);
      }
    }
    //print_r($_return);
    //exit;
    return($_return);
  }


/********************************************************************
*	Get all 'public' access plans
*	input:	client_location_id
*	return:	access plan array or Null, including cost and currency
*********************************************************************/

  function getAccessPlans($clientAddressId=0) {
    $_result = Null;

    $_query = 'SELECT * FROM ' . PHS_DBTABLE_ACCESS_PLAN . ', ' . PHS_DBTABLE_PACKAGE_COST. ', ' . PHS_DBTABLE_CURRENCY . ' WHERE access_plan_package_cost_id=package_cost_id AND currency_id=package_cost_currency_id AND access_plan_client_address_id=' . $clientAddressId;
    if (!DB::isError($rs = $this->dbh->query($_query))) {
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_result[] = $row;
      }
    }
    return($_result);
  }


/********************************************************************
*	getOrderNumber
*	input:	
*	return:	random order number w/o client specific trailer
*
* Note: The actual uniqueness check will be performed by at INSERT time
* from the calling function
*********************************************************************/

  function getOrderNumber() {
      // Create a random order number
    $l1 = pack('c', mt_rand(0,25) + 65);
    $l2 = pack('c', mt_rand(0,25) + 65);
    $l3 = pack('c', mt_rand(0,25) + 65);
    $r1 = mt_rand(0,9);
    $r2 = mt_rand(0,9);
    $r3 = mt_rand(0,9);
    $r4 = mt_rand(0,9);
    $r5 = mt_rand(0,9);
    $r6 = mt_rand(0,9);
    $y = substr(PHS_YEAR, 3, 1);

    $_orderNum = $r1 . $r2 . $l1 . $l2 . $l3 . $r3 . $r4 . $r5 . $r6 . $y;

    return($_orderNum);
  }

/********************************************************************
*	checkUser, used to check if a Login ID exists
*	input: login ID & realm	
*	return:	null = not found, not Null => found
*********************************************************************/

  function checkLoginId($loginId=Null) {
    $_result = Null;

    $_query = 'SELECT * FROM ' . PHS_DBTABLE_USER . " WHERE uuname='" . $loginId . "'";
    //print($_query);
    if (!DB::isError($rs = $this->dbh->query($_query))) {
      $_nrows = $rs->numRows();
    //print(' rows: '.$_nrows);
      if ($_nrows > 0) $_result = $_nrows;
    }
    return($_result);
  }


/********************************************************************
*	getClientInfo, used to get the client site info from a retunring PayPal GET
*	input: $clientSiteId
*	return:	null = not found, not Null => found
*********************************************************************/

  function getClientInfo($clientSiteId=0) {
    $_result = Null;

    $_query = 'SELECT * FROM ' . PHS_DBTABLE_PP_CLIENT . ', ' . PHS_DBTABLE_CLIENT_ADDRESS. ', ' . PHS_DBTABLE_CLIENT . " WHERE client_id=client_address_client_id AND pp_client_client_site_id=" . $clientSiteId . ' AND pp_client_client_site_id=client_address_id';
    //print($_query);
    if (!DB::isError($rs = $this->dbh->query($_query))) {
      if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_result = $row;
      }
    //print(' rows: '.$_nrows);
    }
    return($_result);
  }
  
/********************************************************************
*	setOrderStatus
*	input: 
*	return:	null = success
* checks for current status and if new status is in sequence

define ('PHS_ORDER_STATUS_DEFAULT', 0); // no particular state
define ('PHS_ORDER_STATUS_PENDING', 0x1); // pending after order inserted and off to pp
define ('PHS_ORDER_STATUS_CONFIRMED', 0x2); // confirmed, not yet paid
define ('PHS_ORDER_STATUS_PAID', 0x4); // confirmed, and paid
define ('PHS_ORDER_STATUS_PP_PENDING', 0x8); // confirmed, but payment pending (eCheck)
define ('PHS_ORDER_STATUS_DECLINED', 0x16); // declined
define ('PHS_ORDER_STATUS_FAILED', 0x32); // failed
*********************************************************************/

  function setOrderStatus($clientSiteId=0, $orderInvoiceNum=0, $status=0) {
    $_result = Null;

      // first check current status
    $_query = 'SELECT order_status FROM ' . PHS_DBTABLE_ORDER . ' WHERE order_client_site_id=' . $clientSiteId . " AND order_invoice_no='" . $orderInvoiceNum . "'";
    if (DB::isError($rs = $this->dbh->query($_query))) {
      $_result = $rs->getMessage();
    } else {
      $row = $rs->fetchRow(DB_FETCHMODE_ASSOC);
      if ($row['order_status'] >= $status) {
        $_result = 'Invalid order status - already processed';
      } else {

        $_query = 'UPDATE ' . PHS_DBTABLE_ORDER . ' SET order_status=' . $status . ' WHERE order_client_site_id=' . $clientSiteId . " AND order_invoice_no='" . $orderInvoiceNum . "'";
        //print($_query);
        if (DB::isError($rs = $this->dbh->query($_query))) {
          $_result = $rs->getMessage();
        }
        if (!($this->dbh->affectedRows() > 0)) {
          $_result = 'Order Status could not be updated';
        }
      }
    }
    return($_result);
  }


/********************************************************************
*	Insert Transaction data return from PayPal after POST of auth token
*	input:	transactionArray
*	return:	Null on success, else error message

PayPal variables as of PayPal Order Management Integration Guide April 2006

pp_txn_client_id
pp_txn_txn_id
pp_txn_txn_type
pp_txn_business 
pp_txn_receiver_email
pp_txn_receiver_id
pp_txn_first_name
pp_txn_last_name
pp_txn_address_street
pp_txn_address_city
pp_txn_address_state
pp_txn_address_zip
pp_txn_address_country
pp_txn_address_country_code
pp_txn_address_name
pp_txn_address_status
pp_txn_payer_email
pp_txn_payer_status
pp_txn_payer_id
pp_txn_residence_country
pp_txn_payment_date
pp_txn_payment_status
pp_txn_payment_type
pp_txn_payment_gross
pp_txn_pending_reason
pp_txn_quantity
pp_txn_shipping
pp_txn_tax
pp_txn_custom
pp_txn_mc_currency
pp_txn_mc_gross
pp_txn_item_name
pp_txn_item_number
pp_txn_invoice
pp_txn_mdate
pp_txn_memo
pp_txn_optional

*********************************************************************/

  function insertPPTransaction($clientSiteId=0, $transactionArray=Null) {
    $_return = Null;
    $db_errmsg = Null;

    //print('within insertPPTranscation->');
    //print_r($transactionArray);

    if (!is_null($transactionArray)) {
      //print(' population insert row ');
      $colnames = '';	
      $colvalues = '';
        // for non-listed parameters
      $colnames2 = 'pp_txn_optional';
      $colvalues2 = '';
        // walk through input row
      foreach ($transactionArray as $key => $value) {
        switch ($key) {
        //case 'pp_txn_client_id':
          //$colnames2 .= 'pp_txn_client_id';
          //break;
        case 'txn_id':
          $colnames .= 'pp_txn_txn_id,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'txn_type':
          $colnames .= 'pp_txn_txn_type,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'business':
          $colnames .= 'pp_txn_business,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'receiver_email':
          $colnames .= 'pp_txn_receiver_email,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'receiver_id':
          $colnames .= 'pp_txn_receiver_id,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'first_name':
          $colnames .= 'pp_txn_first_name,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'last_name':
          $colnames .= 'pp_txn_last_name,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_street':
          $colnames .= 'pp_txn_address_street,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_city':
          $colnames .= 'pp_txn_address_city,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_state':
          $colnames .= 'pp_txn_address_state,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_zip':
          $colnames .= 'pp_txn_address_zip,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_country':
          $colnames .= 'pp_txn_address_country,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_country_code':
          $colnames .= 'pp_txn_address_country_code,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_name':
          $colnames .= 'pp_txn_address_name,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'address_status':
          $colnames .= 'pp_txn_address_status,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payer_email':
          $colnames .= 'pp_txn_payer_email,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payer_status':
          $colnames .= 'pp_txn_payer_status,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payer_id':
          $colnames .= 'pp_txn_payer_id,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'residence_country':
          $colnames .= 'pp_txn_residence_country,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payment_date':
          $colnames .= 'pp_txn_payment_date,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payment_status':
          $colnames .= 'pp_txn_payment_status,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payment_type':
          $colnames .= 'pp_txn_payment_type,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'payment_gross':
          $colnames .= 'pp_txn_payment_gross,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'pending_reason':
          $colnames .= 'pp_txn_pending_reason,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'quantity':
          $colnames .= 'pp_txn_quantity,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'shipping':
          $colnames .= 'pp_txn_shipping,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'tax':
          $colnames .= 'pp_txn_tax,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'custom':
          $colnames .= 'pp_txn_custom,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'mc_currency':
          $colnames .= 'pp_txn_mc_currency,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'mc_gross':
          $colnames .= 'pp_txn_mc_gross,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'item_name':
          $colnames .= 'pp_txn_item_name,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'item_number':
          $colnames .= 'pp_txn_item_number,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'invoice':
          $colnames .= 'pp_txn_invoice,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'memo':
          $colnames .= 'pp_txn_memo,';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        default:
          $colvalues2 .= (!empty($colvalues2) ? ' & ' : '') . $value; // collect 'leftovers'
          continue;
        }
        //$colnames .= $key.',';
        //$colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
      }
      $colvalues2 = $this->dbh->quote($colvalues2); // all quoted strings
      $colnames .= 'pp_txn_client_site_id';
      $colvalues .= $clientSiteId;
      //$colnames .= 'pp_txn_ndate';
      //$colvalues .= ' NOW() ';
  
      $query = 'INSERT INTO ' . PHS_DBTABLE_PP_TXN . ' (' . $colnames . (!empty($colvalues2) ? ', ' . $colnames2 : '') . ') VALUES (' . $colvalues . (!empty($colvalues2) ? ', ' .$colvalues2 : '') . ')';

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>insertOrder:</b>>");
        print($query);
        print("<<b>END-DEBUG</b>\n");
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE
 
      if (!DB::isError($rs = $this->dbh->query($query))) {
        //print('Insert user OK');
      } else {
        $db_errmsg = $rs->getMessage();
        $trans_error = True;
      }

          // END TRANSACTION HERE
          
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        $_return = Null;
      } else {
        $_return = $db_errmsg;
      }
    }
    //print_r($_return);
    //exit;
    return($_return);
  }

/********************************************************************
*	Update User
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
rowin elements:
'user_id'                 => $_userId,
'uuname'                  => $userarray['uuname'],
'user_payment'            => 'PayPal: ' . $thePDT->m_data->m_IPNData['payment_status'] . ($thePDT->m_data->m_IPNData['payment_status'] == 'Pending' ? '(' . $thePDT->m_data->m_IPNData['pending_reason'] . ')' : ''),
'user_status'             => PHS_ST_INACTIVE,
'user_client_id'          => $_clientSiteId,
'access_plan_interval' => $userarray['access_plan_interval'],
'package_type_radgroupext' => $userarray['package_type_radgroupext']

Example:
UPDATE phs_user, phs_access_plan SET usttm=IF(NOW() > usttm, Now(), usttm), user_stoptime=DATE_ADD(IF(NOW() > user_stoptime, Now(), user_stoptime), INTERVAL 1 DAY), user_status=0 WHERE user_id=70

*********************************************************************/

  function updateUserEntry($rowin=Null) {
    $this->db_errmsg = 'empty user input row';
    $rowstr = '';	

    //print_r($rowin);

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // note: This technique requires all non-strings have to end with '_id'
        //if ($key == 'user_nas_id' || $key == 'user_client_id' || $key == 'user_id' || $key == 'rad_usergroup_groupname' || $key == 'uuname') continue; // no update
        switch ($key) {
        case 'user_client_id':
          $_clientSiteId = $value;
          continue 2;
        case 'user_id':
          $_userId = $value;
          continue 2;
        case 'access_plan_interval':
          $_accessPlanInterval = $value;
          continue 2;
        case 'user_status':
          $_userStatus = $value;
          continue 2;
        case 'user_payment':
          $_userPayment = $this->dbh->quote($value);
          continue 2;
        case 'order_amount':
          $_orderAmount = $this->dbh->quote($value);
          continue 2;
        case 'order_invoice_no':
          $_orderInvoiceNo = $this->dbh->quote($value);
          continue 2;
 //       case 'uuname':
 //         $_uuname = $this->dbh->quote($value);
 //         continue 2;
 //       case 'package_type_radgroupext':
 //         $_packageTypeRadgroupext = $this->dbh->quote($value);
 //         continue 2;
        default:
    //      if (eregi('_id', $key) || $key == 'user_status') {
    //        $rowstr .= $key . '=' . (empty($rowstr) ? '' : ',') . $value; // not quoted 
    //      } else {
    //        $rowstr .= $key . '=' . (empty($rowstr) ? '' : ',') . $this->dbh->quote($value);
    //      }
        }
      }
      $condition = 'u.user_id=' . $_userId . ' AND ';
      $condition .= 'u.user_client_id=' . $_clientSiteId . ' AND ';
      $condition .= 'o.order_user_id=u.user_id AND ';
      $condition .= 'o.order_invoice_no=' . $_orderInvoiceNo;
  
      //$query = 'UPDATE ' . PHS_DBTABLE_USER . ' SET user_status=' . $_userStatus . ', usttm=IF(NOW() > usttm, Now(), usttm), user_stoptime=DATE_ADD(IF(NOW() > user_stoptime, Now(), user_stoptime), INTERVAL ' . $_accessPlanInterval . "), user_payment=" . $_userPayment . " WHERE " . $condition;
      $query = 'UPDATE ' . PHS_DBTABLE_USER . ' as u, '. PHS_DBTABLE_ORDER . ' as o SET u.user_status=' . $_userStatus . ', u.usttm=IF(NOW() > u.usttm, Now(), u.usttm), u.user_stoptime=DATE_ADD(IF(NOW() > u.user_stoptime, Now(), u.user_stoptime), INTERVAL ' . $_accessPlanInterval . "), u.user_payment=" . $_userPayment . ', o.order_expiry_date=u.user_stoptime, o.order_amount=' . $_orderAmount . " WHERE " . $condition;

        // update RADIUS usergroup table to assign Service Plan or suspend
      $condition = "usergroup_username='" . $rowin['uuname'] . "'";
      $radquery = 'UPDATE ' . PHS_DBTABLE_USERGROUP . " SET usergroup_groupname='" . $rowin['package_type_radgroupext'] . "' WHERE " . $condition;

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>updateUser:</b>>");
        print($query);
        print($radquery);
        print("<<b>END-DEBUG</b>\n");
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE

      if (!DB::isError($rs = $this->dbh->query($query))) {
        //$this->logUser($rowin, PHS_LOGUS_UPDATE);
        //print('Update user OK');
        if (!DB::isError($rs = $this->dbh->query($radquery))) {
          //print('Update usergroup OK');
        } else {
          $this->db_errmsg = $rs->getMessage();
          $trans_error = True;
        }
      } else {
        $this->db_errmsg = $rs->getMessage();
        $trans_error = True;
      }
          // END TRANSACTION HERE
          
      //exit;
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        return(Null);
      } else {
        return($this->db_errmsg);
      }
    }
  }

/*********************************************
*	Get Internet Access User
*	2006-04-30gr
*	input: userid, clientSiteId
*	Return: resultrow or Null
**********************************************/

  function getUserEntry($userid=0, $clientSiteId=0, $orderNum) {
    $resultrow = Null;

    $_query = "SELECT user_id,
                user_nas_id,
                user_ccid,
                user_status,
                user_client_id,
                user_client_package_id,
                user_mac_group,
                user_location, 
                user_lastname,
                user_firstname, 
                uuname, 
                user_value,
                user_phone, 
                user_email, 
                user_address, 
                user_payment, 
                user_notes, 
                CONVERT_TZ(usttm, 'GMT', '" . PHS_TZONE . "') as usttm,
                CONVERT_TZ(user_stoptime, 'GMT', '" . PHS_TZONE . "') as user_stoptime,
                CONVERT_TZ(ulsttm, 'GMT', '" . PHS_TZONE . "') as ulsttm,
                o.*,
                ap.access_plan_interval,
                ap.access_plan_name,
                pt.package_type_radgroupext
                FROM " . PHS_DBTABLE_USER . ', ' . PHS_DBTABLE_ORDER . ' as o, ' .
                PHS_DBTABLE_ACCESS_PLAN . ' as ap, ' .
                PHS_DBTABLE_PACKAGE_TYPE . ' as pt, ' .
                PHS_DBTABLE_CLIENT_PACKAGE . ' as cp 
                WHERE user_id=' . $userid . '
                AND user_client_id = ' . $clientSiteId . " 
                AND user_id=o.order_user_id 
                AND o.order_invoice_no='" . $orderNum . "' 
                AND o.order_access_plan_id=ap.access_plan_id
                AND cp.client_package_client_id=" . $clientSiteId . '
                AND cp.client_package_id=user_client_package_id
                AND cp.client_package_type_id=pt.package_type_id';

    if ($GLOBALS['Phs_Debug'] > 30) {
      print("\n".'<!-- getUser:' . $_query . " getUser -->\n");
    }

    if (!DB::isError($rs = $this->dbh->query($_query))) {
      $ix=0;
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $resultrow = $row;
        $ix++;
      }
      if ($ix > 1) { // error fetching user, too many results
            // could actually never happen since uid is unique .. but u neva no
        $resultrow = Null;
      }
    }
    return ($resultrow);
  }
  

/*********************************************
*	Get Internet Access User
*	2006-04-30gr
*	input: userid, clientSiteId
*	Return: resultrow or Null
**********************************************/

  function getUser($loginId, $clientSiteId=0) {
    $resultrow = Null;

    $_query = "SELECT user_id,
                user_nas_id,
                user_ccid,
                user_status,
                user_client_id,
                user_client_package_id,
                user_mac_group,
                user_location, 
                user_lastname,
                user_firstname, 
                uuname, 
                user_value,
                user_phone, 
                user_email, 
                user_address, 
                user_payment, 
                user_notes, 
                CONVERT_TZ(usttm, 'GMT', '" . PHS_TZONE . "') as usttm,
                CONVERT_TZ(user_stoptime, 'GMT', '" . PHS_TZONE . "') as user_stoptime,
                CONVERT_TZ(ulsttm, 'GMT', '" . PHS_TZONE . "') as ulsttm,
                pt.package_type_radgroupext
                FROM " . PHS_DBTABLE_USER . ', ' .
                PHS_DBTABLE_PACKAGE_TYPE . ' as pt, ' .
                PHS_DBTABLE_CLIENT_PACKAGE . ' as cp 
                WHERE uuname=' . $this->dbh->quote($loginId) . '
                AND user_client_id = ' . $clientSiteId . ' 
                AND cp.client_package_client_id=user_client_id
                AND cp.client_package_id=user_client_package_id
                AND cp.client_package_type_id=pt.package_type_id';

    if ($GLOBALS['Phs_Debug'] > 30) {
      print("\n".'<!-- getUser:' . $_query . " getUser -->\n");
    }

    if (!DB::isError($rs = $this->dbh->query($_query))) {
      $ix=0;
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $resultrow = $row;
        $ix++;
      }
      if ($ix > 1) { // error fetching user, too many results
            // could actually never happen since uid is unique .. but u neva no
        $resultrow = Null;
      }
    }
    return ($resultrow);
  }
}
?>
