<?php
/***************************************************************
*
*	Profile page
*	
*	2006-01-08 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN);

/*
Array
(
    [firstname] => Christopher
    [lastname] => Chin Lee
    [phone] => (868) 624-1181
    [fax] => (868)624-0108
    [cell] => (868)680-6495
    [email] => cchinlee@normandiett.com
    [password1] => 123456
    [password2] => 123456
    [submit2] => submit
)
*/
$_password = '';
$_pwchange = False;
$a->setAuthData('Phs_NextPage', PHS_FILE_ADMUSEREDIT);

//print_r($phs_client_info);

if (!empty($Phs_GET['ausid']) && $Phs_GET['ausid'] > 0) {
  if (($rowin = $dbc->getClientInfo($phs_client_info['client_contact_address_id'], '', $Phs_GET['ausid'])) == Null) {
    $Phs_ErrMsg = 'User not found';
    //print_r($rowin);
  } else {
    $_clientcontactid = $Phs_GET['ausid'];
    //$_ustatus = ($Phs_GET['ausid'] == 'enabled' ? True : False);
    $_uPerm = $rowin['client_contact_permissions'];
    $_timeFormat = (PHS_M_CLIENT_TIME24 & $rowin['client_contact_options'] ? '24' : '12');
    $_myLanguage = $rowin['client_contact_lang'];
  }

} else {
  // set row for display
  $rowin = array(
       'client_contact_id'          => $phs_client_info['client_contact_id'],
       'client_contact_lastname'    => $phs_client_info['client_contact_lastname'],
       'client_contact_firstname'   => $phs_client_info['client_contact_firstname'],
       'client_contact_phone'       => $phs_client_info['client_contact_phone'],
       'client_contact_fax'         => $phs_client_info['client_contact_fax'],
       'client_contact_mobile'      => $phs_client_info['client_contact_mobile'],
       'client_contact_email'       => $phs_client_info['client_contact_email']
  );
  $_uPerm = $phs_client_info['client_address_permissions'];
  $_timeFormat = (PHS_TIME24 ? '24' : '12');
  $_clientcontactid = $phs_client_info['client_contact_id'];
}

if (isset($Phs_POST['submit2'])) {
  if (isset($Phs_POST['ausid'])) {
    $_clientcontactid = $Phs_POST['ausid'];
  }
  //print_r($Phs_POST);

  $_firstname = trim($Phs_POST['firstname']);
  $_lastname  = trim($Phs_POST['lastname']);
  $_phone     = trim($Phs_POST['phone']);
  $_fax       = trim($Phs_POST['fax']);
  $_mobile    = trim($Phs_POST['cell']);
  $_email     = trim($Phs_POST['email']);
  $_password1 = trim($Phs_POST['password1']);
  $_password2 = trim($Phs_POST['password2']);
  $_timeFormat = trim($Phs_POST['timeFormat']);
  $_myLanguage = trim($Phs_POST['lang_id']);
  $_uPerm     = $Phs_POST['uperm_id'];

  if (empty($_firstname)) {
    $Phs_ErrMsg = 'First Name missing';
    $process_error = True;
  } elseif (empty($_lastname)) {
    $Phs_ErrMsg = 'Last Name missing';
    $process_error = True;
    // password changed?
  } elseif ($_password1 <> PHS_PW_DUMMY) {
      // both passwords same
    if ($_password1 <> $_password2) {
      $Phs_ErrMsg = 'Password mismatch';
      $process_error = True;
      // all is fine, save it now
    } elseif (strlen($_password1) < PHS_LEN_PW) {
      $Phs_ErrMsg = 'Password too short! Password must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (strlen($_password1) > PHS_LEN_PW_MAX) {
      $Phs_ErrMsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (ereg('[^a-zA-Z0-9_.-]{1,}', $_password1)) {
      $Phs_ErrMsg = 'Only use a-z, 0-9, _.- and no spaces for the password';
      $process_error = True;
    } else {
      $Phs_InfoMsg = 'Password changed';
      $_pwchange = True;
      //print(' OKOKOK ');
    }
  } 
  
  if (!$process_error) { 
    // all is fine, update record
    //print(' UPDATE DATA ');
//print($_clientcontactid); exit;
    $rowin = array(
       'client_contact_id'          => $_clientcontactid,
       'client_contact_lastname'    => $_lastname,
       'client_contact_firstname'   => $_firstname,
       'client_contact_phone'       => $_phone,
       'client_contact_fax'         => $_fax,
       'client_contact_mobile'      => $_mobile,
       'client_contact_email'       => $_email,
       'client_contact_timeFormat'  => $_timeFormat,
       'client_contact_permissions' => $_uPerm,
       'client_contact_lang'        => $_myLanguage
    );

    if ($_pwchange) {
      $rowin['client_contact_password'] = $_password1;
    }

    if (($Phs_ErrMsg = $dbc->updateClientContact($rowin)) <> Null) {
        // OK, we got an error
      $process_error = True;
    } else {
      $Phs_InfoMsg .= ($_pwchange ? ' and ' : '') . 'Profile for ' . $_firstname . ' ' . $_lastname . ' updated';
      $a->setAuthData('Phs_InfoMsg', $Phs_InfoMsg);
      header('Location: ' . PHS_FILE_ADMINUSERS);
      exit;
    }
  }
} 
if ($_timeFormat  == '24') {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; G:i"); 
  $smarty->assign('24hour', ' selected ');
} else {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; g:i a"); 
  $smarty->assign('12hour', ' selected ');
}
  // to display immediate change
$smarty->assign('PhsDateTime', $showdate);

$smarty->assign('lang_idx', $Phs_languagesIdx);
$smarty->assign('lang_names', $Phs_languages);
$smarty->assign('lang_id', $_myLanguage);

$_password = PHS_PW_DUMMY; // only show dummy password in form

//print_r($phs_client_info);
if ($Phs_GET['ausid'] > 0) {
  $smarty->assign('adminAccess', True);
  $smarty->assign('hiddenform', 'name="ausid" value="' . $Phs_GET['ausid'] .'"');
  //$smarty->assign('status_idx', array('enabled', 'suspended'));
  $smarty->assign('uperm_idx', $opPermIdx);
  //$smarty->assign('status_names', array('Enabled', 'Suspended'));
  $smarty->assign('uperm_names', $opPermName);
  $smarty->assign('uperm_id', $_uPerm);
  //print($_ustatus ? 'enabled' : 'suspended');
  $smarty->assign('profileForm', True);
}

$smarty->assign('_password', $_password);
$smarty->assign('clientInfo', $rowin);
$smarty->assign('mainHeadline', 'Profile for: ' . $rowin['client_contact_username']);
require_once('includes/trailer-inc.php');
$smarty->display('profile.tpl');
?>
