<?php
/***************************************************************
*
*	Admin Users
*	
*	2006-02-24 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN);

$searchstr = '';
$sortorder = '';

if (isset($Phs_GET['ausid']) && $Phs_GET['ausid'] > 0) {
  if (isset($Phs_GET['del']) && $Phs_GET['del'] == 1) {
    $rowin = array(
      'client_contact_client_id'          => $phs_client_info['client_contact_client_id'],
      'client_contact_address_id'         => $phs_client_info['client_contact_address_id'],
      'client_contact_id'                 => $Phs_GET['ausid']
    );

    if (($Phs_ErrMsg = $dbc->deleteClientContact($rowin)) <> Null) {
        // OK, we got an error
      $process_error = True;
    } else {
      $Phs_InfoMsg = 'Admin User deleted';
      $a->setAuthData('Phs_InfoMsg', $Phs_InfoMsg);
      //print($Phs_InfoMsg);
      header('Location: ' . PHS_FILE_ADMINUSERS . (isset($Phs_GET[$phs_PageStr]) ? '?' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') );
      exit;
    }
  } 
}

if (!isset($_GET['pageID']) ? $from=1 : '');

if (isset($Phs_GET['search']) && !empty($Phs_GET['search'])) {
  $searchstr = $Phs_GET['search'];// need to check this!
  $smarty->assign('Phs_search', $searchstr);
}
if (isset($Phs_GET['sort']) && !empty($Phs_GET['sort'])) {
  $sortstr = $Phs_GET['sort'];// need to check this!
  switch(strtolower($sortstr)) {
    case 'first':
      $sortorder = 'client_contact_firstname';
      break;
    case 'last':
      $sortorder = 'client_contact_lastname';
      break;
    case 'login':
      $sortorder = 'client_contact_username';
      break;
    case 'perm':
      $sortorder = 'client_contact_permissions';
      break;
    case 'login':
      $sortorder = 'xxx';
      break;
  }
}
//print_r($phs_client_info);

$adminuserarray = $dbc->getAllAdminUsers($phs_client_info['client_contact_address_id'], 0, $searchstr, $sortorder, ($from - 1) * $pageparams['perPage'], $pageparams['perPage'], $maxpages);

$pageparams['totalItems'] = $adminuserarray[0]['numrows'];

$pager = & Pager::factory($pageparams);
$links = $pager->getLinks();


$data = array(
  '<a href="' . $Phs_Page . '?sort=last" title="Sort by Last Name" alt="Sort by Last Name"><b>Last Name</b></a>', 
  '<a href="' . $Phs_Page . '?sort=first" title="Sort by First Name" alt="Sort by First Name"><b>First Name</b></a>',
  '<a href="' . $Phs_Page . '?sort=login" title="Sort by Login" alt="Sort by Login"><b>Login Id</b></a>',
  '<a href="' . $Phs_Page . '?sort=perm" title="Sort by Permissions" alt="Sort by Permissions"><b>Permissions</b></a>',
  '<a href="' . $Phs_Page . '?sort=llogin" title="Sort by Last Login" alt="Sort by Last Login"><b>Last Login</b></a>', 
  '<a href="' . $Phs_Page . '"><b>Edit</b></a>', 
  (($perm & (PHS_PERM_SUPADMIN|PHS_PERM_ADMIN) ? '<a href="' . $Phs_Page . '"><b>Del</b></a>' : '')));

//print_r($adminuserarray);

for ($idx=1; $idx < sizeof($adminuserarray); $idx++) {
  
  $_numUsers = 0;
  if ($adminuserarray[$idx]['client_contact_status'] <> PHS_ST_SUSPENDED) {
  }
  //print(' '.$adminuserarray[$idx]['client_contact_permissions']);

  $data = array_merge2($data, 
    array(
      $adminuserarray[$idx]['client_contact_lastname'], 
      $adminuserarray[$idx]['client_contact_firstname'], 
      $adminuserarray[$idx]['client_contact_username'], 
      $opPermName[$adminuserarray[$idx]['client_contact_permissions']], 
      (!empty($adminuserarray[$idx]['clientlog_tzmdate']) ? $adminuserarray[$idx]['clientlog_tzmdate'] : 'Never'), 
      '<a href="' . PHS_FILE_ADMUSEREDIT . '?ausid=' . $adminuserarray[$idx]['client_contact_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '"><img src="images/icon_edit_user.gif" alt="Edit User" title="Edit User" class="icon" /></a>', 
      (($perm & (PHS_PERM_SUPADMIN|PHS_PERM_ADMIN) ? '<a onclick="return confirm(\'Confirm that you want to delete this Admin User?\')" href="' . PHS_FILE_ADMINUSERS . '?ausid=' . $adminuserarray[$idx]['client_contact_id'] . '&del=1' . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '"><img src="images/icon_delete_user.gif" alt="Delete Admin User" title="Delete Admin User" class="icon" /></a>' : ''))));

}

$smarty->assign('pagenav', $links['all']);
$smarty->assign('pageAddNewUser', 'Add New User');

//$smarty->assign('tdwidth', '65|80|50|100|200|20|');
$smarty->assign('tdwidth', '100|100|60|80|110|20');
$smarty->assign('colsize', 7);

$smarty->assign('searchFieldEnabled', 1);
if ($perm & (PHS_PERM_SUPADMIN|PHS_PERM_ADMIN)) $smarty->assign('Phs_page_useradd', PHS_FILE_ADMUSERADD);
$smarty->assign('mainHeadline', 'Admin User Management (' .$adminuserarray[0]['numrows'] . ')');
//$smarty->assign('tdwidth', $_tableColWidth);
//$smarty->assign('colsize', $_tableColSize);
require_once('includes/trailer-inc.php');
$smarty->display('adminusers.tpl');
?>
