<?php
/***************************************************************
*
*	User Report
*	
*	2006-03-26 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

/*
  - Searcheable by username
  - Time period selection or current account (use StartTime)
  - Display page with multiple users and click to expand a single user
    Expanded data shows every session during the period
    E.g. Start, Stop, Duration, download, upload, session termination cause 

*/
require('includes/init-inc.php');	// initialize 
require('includes/reports-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN+PHS_PERM_PUSER);

$a->setAuthData('Phs_NextPage', PHS_FILE_ACCOUNTING);

$_periodSelector = '';
$mainHeadline = 'Accounting';
$_colSize = 6;
$_tdWidth = '35|70|100|60|60|';
$searchstr = '';
$sortorder = '';
$_startDate = 0;
$_startTime = '00:00:00';
$_stopDate = 0;
$_stopTime = '23:59:59';
$_startDateTimeStr = '';
$_stopDateTimeStr = '';
$typeOrderStr = 'login';
$pageArg = '';
$_userId = 0;

//print_r($Phs_POST);

if (isset($Phs_GET['period']) || isset($Phs_GET['search'])) {

  $rcl = new reports($params);
  if (isset($Phs_GET['search']) && !empty($Phs_GET['search'])) {
    $searchstr = $Phs_GET['search'];// need to check this!
    $smarty->assign('Phs_search', $searchstr);
  } elseif (isset($Phs_GET['filter']) && !empty($Phs_GET['filter'])) {
    $searchstr = $Phs_GET['filter'];
    $smarty->assign('searchFilter', $searchstr);
  }
  if (isset($Phs_GET['usid']) && $Phs_GET['usid'] > 0) {
    $_userId = $Phs_GET['usid'];
    $sortorder = 'r.radacct_mdate DESC, u.uuname, u.user_lastname';
    $pageArg .= 'usid=' . $_userId . '&';
  }
  
  if (isset($Phs_GET['period'])) {
    $_periodSelector = $Phs_GET['period'];
    if ($_periodSelector == 'period') {
      //if (isset($Phs_POST['submit2'])) {
      if (isset($Phs_GET['submit2'])) {
        //print('Submitted');
        if (isset($Phs_GET['StartDate']) && isset($Phs_GET['StartTime'])) {
          $_startDate = $Phs_GET['StartDate']['Date_Year'] . '-' . 
                          $Phs_GET['StartDate']['Date_Month'] . '-' . 
                          $Phs_GET['StartDate']['Date_Day'];
          $_startTime = $Phs_GET['StartTime']['Time_Hour'] . ':' . 
                          $Phs_GET['StartTime']['Time_Minute'] . ':00';
          $_startDateTimeStr = $_startDate . ' ' . $_startTime;
          if (!checkdate($Phs_GET['StartDate']['Date_Month'], $Phs_GET['StartDate']['Date_Day'], $Phs_GET['StartDate']['Date_Year'])) {
            $Phs_ErrMsg = 'Invalid Start Date';
            $process_error = True;
          }
          //print($_startDateTimeStr);
        }
        if (isset($Phs_GET['StopDate']) && isset($Phs_GET['StopTime'])) {
          $_stopDateTimeStr = $Phs_GET['StopDate']['Date_Year'] . '-' . 
          $_stopDate = $Phs_GET['StopDate']['Date_Year'] . '-' . 
                       $Phs_GET['StopDate']['Date_Month'] . '-' . 
                       $Phs_GET['StopDate']['Date_Day'];
          $_stopTime = $Phs_GET['StopTime']['Time_Hour'] . ':' . 
                       $Phs_GET['StopTime']['Time_Minute'] . ':59';
          $_stopDateTimeStr = $_stopDate . ' ' . $_stopTime;
          if (!checkdate($Phs_GET['StopDate']['Date_Month'], $Phs_GET['StopDate']['Date_Day'], $Phs_GET['StopDate']['Date_Year'])) {
            $Phs_ErrMsg = 'Invalid Stop Date';
            $process_error = True;
          }
        }
        //print($_startDateTimeStr.' -- '.$_stopDateTimeStr);
      }
      $smarty->assign('showStartTime', True);
      $smarty->assign('showStopTime', True);
      $smarty->assign('StartDate', $_startDate); // set time display format
      $smarty->assign('StartTime', $_startTime); // set time display format
      $smarty->assign('StopDate', $_stopDate); // set time display format
      $smarty->assign('StopTime', $_stopTime); // set time display format
    }
  }

  //print('pSel:'.$_periodSelector);
  //if ($_periodSelector != 'period' || ($_periodSelector == 'period' && isset($Phs_POST['submit2']))) {
  if ($_periodSelector != 'period' || ($_periodSelector == 'period' && isset($Phs_GET['submit2']))) {

  //print('pSel:'.$_periodSelector);
  if (isset($Phs_GET['sort']) && !empty($Phs_GET['sort'])) {
    $sortstr = $Phs_GET['sort'];// need to check this!
    switch(strtolower($sortstr)) {
    case 'login':
      //$sortorder = ($_userId > 0 ? 'r.radacct_mdate DESC,' : '') . 'u.uuname, u.user_lastname';
      $sortorder = 'u.uuname, u.user_lastname';
      //$typeOrderStr = 'login';
      break;
    case 'total':
      $sortorder = 'time_total DESC, u.user_lastname, u.user_firstname';
      break;
    case 'up':
      $sortorder = 'input_total DESC, u.user_lastname, u.user_firstname';
      //$typeOrderStr = 'up';
      break;
    case 'down':
      $sortorder = 'output_total DESC, u.user_lastname, u.user_firstname';
      //$typeOrderStr = 'down';
      break;
    case 'se':
      $sortorder = 'radacct_stoptime DESC, u.user_lastname, u.user_firstname';
      break;
    case 'ss':
      $sortorder = 'radacct_starttime DESC, u.user_lastname, u.user_firstname';
      break;
    case 'tc':
      $sortorder = 'radacct_terminatecause, u.user_lastname, u.user_firstname';
      break;
    }
  }  
  $pageArg .= 'period=' . $_periodSelector;

  if (!$process_error) {
    if (!isset($Phs_GET['pageID']) ? $from=1 : '');

    $_sreportArray = $rcl->salesReport(PHS_CLIENT_ID, $_userId, $_periodSelector, $_startDateTimeStr, $_stopDateTimeStr, $searchstr, $sortorder, ($from - 1) * $pageparams['perPage'], $pageparams['perPage'], $maxpages);
    //print_r($_sreportArray);

    $pageparams['totalItems'] = $_sreportArray[0]['numrows'];
    $mainHeadline .= ' (' . $_sreportArray[0]['numrows'] . ')';

    $pager = & Pager::factory($pageparams);
    $links = $pager->getLinks();

    
  /*  
    if ($_userId > 0) {
      $data = array('<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login"><b>Login Id</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=total"><b>Total</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=up"><b>Upload</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=down"><b>Download</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=ss"><b>Session Start</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=se"><b>Session End</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=tc"><b>Termination</b></a>');
    } else {
      */
      //$data = array('<a href=""><b>Details</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login"><b>Login Id</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=total"><b>Total</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=up"><b>Upload</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=down"><b>Download</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=se"><b>Session End</b></a>');
      $data = array('<b>Package Type</b>','<b>Qty</b>','<div align="right"><b>Price</b></div>','<div align="right"><b>Total</b></div','');
    //}
    $_total_amount = 0;
    $_total_qty = 0;
    $_tdWidth = '100|30|40|70|';
    $sizeSReport = sizeof($_sreportArray);
    if ($sizeSReport > 1) {
      $_prePaid = $_sreportArray[1]['plan']; // 1 for prepaid, 0 for time
    }
    for ($idx=1; $idx < $sizeSReport; $idx++) {
      if ($_prePaid && $_sreportArray[$idx]['plan'] == 0) {
        $data = array_merge2($data, array('<b>Total Prepaid</b>','<b>' . $_total_qty . '</b>','','<b>' . '<div align="right"><b>' . number_format($_total_amount, 2) . '</b></div>', ''));
        $_prePaid = 0;
        $_total_amount = 0;
        $_total_qty = 0;
      } 
      $_total_amount += $_sreportArray[$idx]['ptsum'];
      $_total_qty += $_sreportArray[$idx]['pttotal'];
      if ($_userId > 0) {
        $_colSize = 7;
        $_tdWidth = '100|100|60|60|110|110|';
        $data = array_merge2($data, array(
        '<a href="' . PHS_FILE_USEREDIT . '?usid=' . $_sreportArray[$idx]['user_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '">' . normalizeUsername($_sreportArray[$idx]['uuname']) . '</a>',
        convertOnlineTime($_sreportArray[$idx]['time_total'], True), 
        octets2String($_sreportArray[$idx]['input_total']),
        octets2String($_sreportArray[$idx]['output_total']), 
        $_sreportArray[$idx]['radacct_starttime'],
        $_sreportArray[$idx]['radacct_stoptime'],
        $_sreportArray[$idx]['radacct_terminatecause']));
      } else {
        //$_colSize = 6;
        $_colSize = 5;
        //$_tdWidth = '35|100|100|60|60|';
        //$_tdWidth = '100|30|40|70|';
      '<img src="images/' .
      $data = array_merge2($data, array(
        $_sreportArray[$idx]['package_type_name'],
        $_sreportArray[$idx]['pttotal'],
        '<div align="right">' . number_format($_sreportArray[$idx]['package_cost_rate'], 2) . '</div>',
        '<div align="right">' . number_format($_sreportArray[$idx]['ptsum'], 2) . '</div>', ($_prePaid == 0 ? ($_sreportArray[$idx]['billinglog_cycle_id'] > 0 ?
          $Phs_BillingCycleArray[$_sreportArray[$idx]['billinglog_cycle_id']] : '-' ) : '')));
        /*
        convertOnlineTime($_sreportArray[$idx]['time_total'], True), 
        octets2String($_sreportArray[$idx]['input_total']),
        octets2String($_sreportArray[$idx]['output_total']), 
        $_sreportArray[$idx]['radacct_stoptime']));
        */
      }
    }
    if ($idx > 1) {
      $data = array_merge2($data, array('<b>Total</b>','<b>' . $_total_qty . '</b>','','<b>' . '<div align="right"><b>' . number_format($_total_amount, 2) . '</b></div>', ''));
      $smarty->assign('pagenav', $links['all']);
    } else {
      $data = array_merge2($data, array('','no results','', '','<div align="right">0.00</div>'));
    }
  }
  }
}

  // assign radio buttons
$smarty->assign('periods_ids', array('today','week','month','lmonth','period','all'));
$smarty->assign('periods', array('Today','This week','This month','Last month','Specify time period','All'));
$smarty->assign('period_id', $_periodSelector);

$smarty->assign('tdwidth', $_tdWidth);
$smarty->assign('colsize', $_colSize);
//$smarty->assign('searchFieldEnabled', 1);
$smarty->assign('time24', PHS_TIME24); // set time display format
require_once('includes/trailer-inc.php');
$smarty->assign('mainHeadline', $mainHeadline);
$smarty->display('userreport.tpl');
?>
