<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: ewp_create.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/EWP.php';
require_once 'Services/PayPal/Profile/Handler.php';
require_once 'lib/ewp_form_validators.inc.php';
require_once 'lib/functions.inc.php';

session_start();

$dummy= @new EWPProfile();
$environments = $dummy->getValidEnvironments();

$was_submitted = false;

if(isset($_POST['submitted']))
{
    unset($_POST['submitted']);
    unset($_POST['action']);

    $was_submitted = true;

    $errors = validate_form_input($_POST);

    if(!isset($_FILES['certificate_file']))
    {
        $errors['certificate_file'] = "You must provide a Certificate for the profile";
    }
    else
    {
        if(!file_exists($_FILES['certificate_file']['tmp_name']))
        {
            $errors['certificate_file'] = "You must provide a Certificate for the profile";
        }
        else
        {
            if(!is_uploaded_file($_FILES['certificate_file']['tmp_name']))
            {
                $errors['certificate_file'] = "Invalid file upload, cannot save profile";
            }
        }
    }

    if(!isset($_FILES['privatekey']))
    {
        $errors['privatekey'] = "You must provide a Private Key file for the profile";
    }
    else
    {
        if(!file_exists($_FILES['privatekey']['tmp_name']))
        {
            $errors['privatekey'] = "You must provide a Private Key for the profile";
        }
        else
        {
            if(!is_uploaded_file($_FILES['privatekey']['tmp_name']))
            {
                $errors['privatekey'] = "Invalid file upload, cannot save profile";
            }
        }
    }

    $cert_save_path = _getProfileCertSavePath();

    if(Services_PayPal::isError($cert_save_path))
    {
        $errors['unknown'][] = $cert_save_path->getMessage();
    }

    if(empty($errors))
    {
        $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

        if(!Services_PayPal::isError($handlerinst))
        {
            $pid = ProfileHandler::generateID();

            $profile = new EWPProfile($pid, $handlerinst);

            $cert_file = "$cert_save_path/$pid.cert";

            if(!move_uploaded_file($_FILES['certificate_file']['tmp_name'],
                                   $cert_file))
            {
                $errors['unknown'][] = "Could not store uploaded certificate '{$_FILES['certificate_file']['tmp_name']}'";
            }

            $pkey_file = "$cert_save_path/$pid.prv";

            if(!move_uploaded_file($_FILES['privatekey']['tmp_name'], $pkey_file))
            {
                $errors['unknown'][] = "Could not store uploaded Private Key '{$_FILES['privatekey']['tmp_name']}'";
            }

            $profile->setEnvironment($_POST['environment']);
            $profile->setPrivateKeyFile($pkey_file);
            $profile->setCertificateId($_POST['cert_id']);
            $profile->setCertificateFile($cert_file);
            $profile->setButtonImage($_POST['buttonImageURL']);
            $profile->setUrl($_POST['buttonURL']);

            $result = $profile->save();

            if(Services_PayPal::isError($result))
            {
                $errors['unknown'][] = "Could not create new profile: ".$result->getMessage();
            }
        }
        else
        {
            $errors['unknown'][] = "Could not create a new Profile Handler: ". $handlerinst->getMessage();
        }

    }
}

require_once "pages/ewp_create.html.php";
