<?php
    require_once '../lib/functions.inc.php';
    session_start();
    
    $_SESSION['billing_info'] = @$_POST['billing'];
    $_info_box = "When clicked, the <strong>Place Order</strong> button initiates the final request via the <code>DoDirectPayment</code> API.</p><p>Option 1: With Direct Payments, the order is completed, paid for, and shipped in one transaction.</p><p>Option 2: With Direct Payments and Authorization and Capture enabled, an &quot;authorize&quot; API call is made and the credit card is <em>only</em> authorized. The actual charge is made at a later time when the order is shipped and a &quot;capture&quot; API call is invoked.";
    
    include_once '../lib/html/header.html.php';
?>
<table cellpadding="0" cellspacing="0" border="0" width="750" class="main">
<tr>
<td>

	<table cellpadding="0" cellspacing="0" border="0" width="750" class="content">
	<tr>
	<td>
			<p class="progress">
				Enter Shipping Info
				&nbsp;&nbsp;&nbsp;
				>>
				&nbsp;&nbsp;&nbsp;
				Enter Billing Info
				&nbsp;&nbsp;&nbsp;

				>>
				&nbsp;&nbsp;&nbsp;
				<span class="active">Place Order</span>
			</p>
		
		<img src="../images/spacer.gif" height="325" width="1" align="right">
	
		<p class="title">
		Review and Place Order
	</p>
		<p>Review the order details below and click the <strong>Place Order</strong> button to complete this purchase. Check your email 
			account for confirmation and transaction details.</p>

		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="detail">
		<tr>
		<td>
			<p class="heading">Shipping Details</p>

			<form name="shippingMethodForm" method="post" action="placeOrder.php">
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>

				<td class="formLabel" valign="top"><p>Ship To:</p></td>
				<td class="formOutput">
					<p>
				    <?php print $_SESSION['shipping_info']['firstName']; ?>
				    &nbsp;
				    <?php print $_SESSION['shipping_info']['lastName']; ?>
					<br/>
					<?php print $_SESSION['shipping_info']['streetAddress1'];?>
					<br/>
					<?php print $_SESSION['shipping_info']['streetAddress2'];?>
					<br/>
					<?php print $_SESSION['shipping_info']['city']; ?>, 
					<?php print $_SESSION['shipping_info']['state']; ?>
					<br/>
					<?php print $_SESSION['shipping_info']['zipCode']; ?>
					<br/>
				    <?php print $_SESSION['shipping_info']['country']; ?>
					</p>
					<p class="changeBtn"><input type="button" name="changeBtn" value="Change" disabled/></p>
				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Shipping Method:</p></td>
				<td class="formInput">
					<p>
                    <?php print $_SESSION['shipping_info']['method']; ?>						
					</p>

				</td>
				</tr>
				</table>
				
				<p class="heading">Payment Details</p>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel" valign="top"><p>Bill To:</p></td>
				<td class="formOutput">

					<p>
						<?php print $_SESSION['billing_info']['firstName']; ?>
						&nbsp;
						<?php print $_SESSION['billing_info']['lastName']; ?>
						<br/>
						<?php print $_SESSION['billing_info']['streetAddress1']; ?>
						<br/>
						<?php print $_SESSION['billing_info']['streetAddress2']; ?>
						<br/>
						<?php print $_SESSION['billing_info']['city']; ?>,
						<?php print $_SESSION['billing_info']['state']; ?>
						<br/>
						<?php print $_SESSION['billing_info']['zipCode']; ?>
   					    <br/>
                        <?php print $_SESSION['billing_info']['country']; ?>						
					</p>
					<p class="changeBtn"><input type="button" name="changeBtn" value="Change" disabled/></p>
				</td>

				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Payment Method:</p></td>
				<td class="formOutput">
					<p>
						<?php print $_cc_descriptions[$_SESSION['billing_info']['method']]; ?>
						<br/>
						<?php
						      $cc = $_SESSION['billing_info']['creditCardNumber'];
						      for($i = 0; $i < strlen($cc); $i++)
						      {
						          if($i < strlen($cc)-4)
						              print "*";
						          else 
						              print $cc{$i};
						              
						          print (!($i % 4)) ? "&nbsp;" : "";
						      }
						?>
						<br/>
						Expires:
						<?php print $_SESSION['billing_info']['expirationMonth'] . '/' .
						            $_SESSION['billing_info']['expirationYear']; ?>
					</p>
					<p class="changeBtn"><input type="button" name="changeBtn" value="Change" disabled/></p>
				</td>

				</tr>
				</table>
				
				<p class="heading">Order Summary</p>
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
                <?php
                    $items = $_SESSION['cart']->getItems();
                    
                    $itemnum = 0;
                    $totalprice = 0;
                    foreach($items as $itemID => $quantity):
                        $photodata = $_photo_data[$itemID];
                        $itemnum++;
                        $totalprice += $photodata['price'] * $quantity;
                ?>
				<tr>
				<td class="formLabel" valign="top">
					
						<p>Item #<?php print $itemnum; ?>:</p>
					
				</td>

				<td class="formOutput">
					
						<p>
						<span class="total">$<?php print number_format(($photodata['price'] * $quantity), 2); ?></span> 
						<?php print "({$photodata['title']} ({$photodata['size']}), Quantity: $quantity)"; ?>
					    </p>
					
					<p class="changeBtn"><input type="button" name="changeBtn" value="Change" disabled/></p>
				</td>
				</tr>
				<?php endforeach; ?>
				</table>

	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel">
					<p>
						Item(s) Total:
						<br/>
						Shipping &amp; Handling:
						<br/>
						Tax:
					</p>

				</td>
				<td class="formOutput" align="right">
					<p>
						$<?php print number_format($totalprice, 2); ?>
						<br/>
						$5.00
						<br/>
						$0.00
					</p>
				</td>

				<tr>
				<td class="formLabel">
					<p class="orderTotalLbl"><b>Order Total:</b></p>
				</td>
				<td class="formOutput" align="right">
					<p class="orderTotal">$<?php print number_format($totalprice + 5, 2); ?></p>
				</td>
				</tr>

				</table>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel"><p><img src="../images/i_sm.gif" height="18" width="18" border="0" alt="Information"></p></td>
				<td class="formOutput">
					<input type="submit" value="Place Order"> 
					
					<input type="button" name="backBtn" value="Back" onclick="document.location.href='saveShippingInfo.php';">
					
					<input type="button" name="cancelBtn" value="Cancel" onclick="document.location.href='viewCart.php';">
				</td>

				</tr>
				<tr>
				<td class="formLabel"><p>&nbsp;</p></td>
				<td class="formOutput"><p class="headsUp">(<b>Next step:</b> View and print your receipt)</p></td>
				</tr>
				</table>
			</form>

		</td>
		</tr>
		</table>
	
	</td>
	</tr>
	</table>
</td>
</tr>
</table>
<?php include_once '../lib/html/footer.html.php'; ?>