<?php
    require_once '../lib/functions.inc.php';
    session_start();
    
    if(empty($_POST['transID']))
    {
        do_error("Transaction ID not provided", false);
    }

    if(empty($_POST['orderID']))
    {
        do_error("Order ID not provided", false);
    }
    
    if(empty($_POST['type']) ||
       (($_POST['type'] == "partial") &&
        empty($_POST['amount'])))
    {
        header("Location:  refundOrder.php?transID={$_POST['transID']}&orderID={$_POST['orderID']}");
        exit;
    }        
    
    /* This would normally not be necessary, but since we are performing the call on the fly
    we need to write the data in the certificate file to the filesystem temporarily to perform
    the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage(), true);
    }
    
    $details =& Services_PayPal::getType('GetTransactionDetailsRequestType');
    $details->setTransactionId($_POST['transID']);
    
    $result = $caller->GetTransactionDetails($details);
    
    if(Services_PayPal::isError($result))
    {
        @unlink($filename);
        do_error($result->getMessage(), false);
    }    
    
    $td = $result->PaymentTransactionDetails;
    
    $si['name'] = ($td->PayerInfo->Address->Name) ? $td->PayerInfo->Address->Name : "John Doe";
	$si['street1'] = ($td->PayerInfo->Address->Street1) ? $td->PayerInfo->Address->Street1 : "222 Anystreet";
	$si['street2'] = ($td->PayerInfo->Address->Street2) ? $td->PayerInfo->Address->Street2 : null;
	$si['city'] = ($td->PayerInfo->Address->CityName) ? $td->PayerInfo->Address->CityName : "Anytown";
	$si['state'] = ($td->PayerInfo->Address->StateOrProvince) ? $td->PayerInfo->Address->StateOrProvince : "CA";
	$si['country'] = ($td->PayerInfo->Address->CountryName) ? $td->PayerInfo->Address->CountryName : "US";
	$si['zip'] = ($td->PayerInfo->Address->PostalCode) ? $td->PayerInfo->Address->PostalCode : "60622";    
    
	$orig_total = $td->PaymentInfo->GrossAmount->_value;
    $refundAmount = (($_POST['type'] == "partial") ? (int)$_POST['amount'] : $orig_total);
    $new_total = $orig_total - $refundAmount;    
    
    $rtrt =& Services_PayPal::getType('RefundTransactionRequestType');
    $rtrt->setTransactionId($_POST['transID']);
    $rtrt->setAmount($refundAmount);

    if(!empty($_POST['notes']))
    {
        $rtrt->setMemo($_POST['notes']);
    }
    
    $refundResult = $caller->RefundTransaction($rtrt);
    @unlink($filename);
    
    if(Services_PayPal::isError($refundResult))
    {
        do_error($refundResult->getMessage());
    }
    
    if($refundResult->Ack != "Success")
    {
        do_error($refundResult->Errors->ShortMessage, false);
    }
    
    include_once '../lib/html/header.html.php';
?>
<table cellpadding="0" cellspacing="0" border="0" width="750">
<tr>
<td align="left">

	<table cellpadding="0" cellspacing="0" border="0" width="750" class="content">
	<tr>
	<td>

	
		<p class="title">Order Details</p>
		<p>Please review the order details below.</p>
		
		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="detail">
		<tr>
		<td>

			<form name="orderDetailsForm" action="orders.html" method="POST">
			
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">

				<tr>
				<td class="formLabel" valign="top"><p>Order ID:</p></td>
				<td class="formOutput">
					<p><?php print (int)$_POST['orderID']; ?></p>
				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Order Status:</p></td>

				<td class="formOutput">
					<p><?php print ($_POST['type'] == "partial") ? "Partial" : "Full"; ?> Refund</p>
				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Original Amount:</p></td>
				<td class="formOutput">

					<p>$<?php print $orig_total; ?></p>
				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Refund Amount:</p></td>
				<td class="formOutput">
					<p>$<?php print (int)$_POST['amount']; ?></p>

				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p class="newOrderTotal">New Order Total:</p></td>
				<td class="formOutput">
					<p class="newOrderTotal">$<?php print $new_total; ?></p>
				</td>
				</tr>

				<tr>
				<td class="formLabel" valign="top"><p>Date:</p></td>
				<td class="formOutput">
					<p><?php print date('m-d-Y h:i'); ?></p>
				</td>
				</tr>
				</table>
				
				<p class="PseudoHR"><img src="../images/spacer.gif" width="1" height="1" alt="" border="0"/></p>

				
				<p class="heading">Original Order Details</p>
				
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>
				<td class="formLabel" valign="top"><p>Date:</p></td>
				<td class="formOutput">
					<p><?php print date('m-d-Y h:i', strtotime($td->PaymentInfo->PaymentDate)); ?></p>
				</td>

				</tr>
				</table>

				<p class="heading">Shipping Details</p>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>
				<td class="formLabel" valign="top"><p>Ship To:</p></td>
				<td class="formOutput">

					<p>
                        <?php print $si['name']; ?>
					   <br/>
						<?php print $si['street1']; ?>
						<?php print $si['street2']; ?>
						<br/>
						<?php print $si['city']; ?>,
						<?php print $si['state']; ?>&nbsp;
						<?php print $si['zip']; ?>
						<br/>
						<?php print $si['country']; ?>
					</p>
				</td>
				<tr>

				<td class="formLabel" valign="top"><p>Shipping Method:</p></td>
				<td class="formOutput">
					<p>Standard shipping (3-5 business days)</p>
				</td>
				</tr>
				</table>
				
				<p class="heading">Payment Details</p>

	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel" valign="top"><p>Bill To:</p></td>
				<td class="formOutput">
				    <?php 
				        switch($td->PaymentInfo->TransactionType)
				        {
				            case "web-accept":
				                $trans_detail = str_repeat("*", strlen($td->PaymentInfo->ReceiptID)-4) . 
				                                 substr($td->PaymentInfo->ReceiptID,strlen($td->PaymentInfo->ReceiptID)-4);
				                break;
				            case "express-checkout":
				                $trans_detail = $td->PayerInfo->Payer;
				                break;
				            default:
				                $trans_detail = "unknown";
				                break;
				        }
				     ?>       
				           
					<p><?php print $td->PaymentInfo->TransactionType; ?> (<?php print $trans_detail; ?>)</p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Payment Method:</p></td>

				<td class="formOutput">
					<p>Via PayPal</p>
				</td>
				</tr>
				</table>
				
				<p class="heading">Order Summary</p>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>
				<td class="formLabel">

					<p class="orderTotalLbl"><b>Order Total:</b></p>
				</td>
				<td class="formOutput" align="right">
					<p class="orderTotal"><?php print $orig_total; ?></p>
				</td>
				</tr>
				</table>
	
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">

				<tr>
				<td class="formLabel"><p>&nbsp;</p></td>
				<td class="formInput">
					<input type="button" name="viewOrdersBtn" onClick="window.location='viewOrders.php'" value="View All Orders" /> 
				</td>
				</tr>
				</table>
			</form>
		</td>

		</tr>
		</table>
	</td>
	</tr>
	</table>
</td>
</tr>
</table>
<?php include_once '../lib/html/footer.html.php'; ?>