<?php
/***************************************************************
*
*	Router Setup for Linksys WRT54 (GL) and DD-WRT V23 + V24
*	
*	20081012 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN);

function is_ipaddress ($ip='', $nmask=false) {
  //print('IP:'.$ip);
  if(strlen($ip) <= 15) {
    $segs = explode('.', $ip);
    if(count($segs) != 4) {
  //print('1.FALSE');
      return false;
    }
    foreach($segs as $seg) {
      if(!((strlen($seg) > 0) && is_numeric($seg))) {
  //print('Empty('.$seg.')');
        return false;
      } else {
        if ($nmask) { // is netmask ?
          if (($seg < 0) || ($seg > 255)) {
  //print('NM FALSE('.$seg.')');
            return false;
          }
        } else {
          if (($seg < 0) || ($seg >= 255)) {
  //print('2.FALSE('.$seg.')');
            return false;
          }
        }
      }
    }
    return true;
  } else {
  //print('3.FALSE');
    return false;
  }
}


$routerid_error = false;
$_routerConfigFile = 'phs_setup';
$_showSetupUrl = false;
$_isAccessPoint = false;
$_chilli_interface = '';
$_monitorArg1 = '';

$a->setAuthData('Phs_NextPage', PHS_FILE_ROUTERSET);

$routerConfig = Array(
  'rtconfig_name'       => PHS_CLIENT_ACODE,
  'rtconfig_rid'        => PHS_CLIENT_ACODE,
  'rtconfig_lanip1'     => '192',
  'rtconfig_lanip2'     => '168',
  'rtconfig_lanip3'     => '10',
  'rtconfig_lanip4'     => '1',
  'rtconfig_netmask1'   => '255',
  'rtconfig_netmask2'   => '255',
  'rtconfig_netmask3'   => '255',
  'rtconfig_netmask4'   => '0',
  'rtconfig_gateway1'   => '0',
  'rtconfig_gateway2'   => '0',
  'rtconfig_gateway3'   => '0',
  'rtconfig_gateway4'   => '0',
  'rtconfig_locdns1'    => '0',
  'rtconfig_locdns2'    => '0',
  'rtconfig_locdns3'    => '0',
  'rtconfig_locdns4'    => '0',
  'rtconfig_ssid'       => 'pointHotspot',
  'rtconfig_wpower'     => '75',
  'rtconfig_rmac1'     => '00',
  'rtconfig_rmac2'     => '1D',
  'rtconfig_rmac3'     => '7E',
  'rtconfig_rmac4'     => '',
  'rtconfig_rmac5'     => '',
  'rtconfig_rmac6'     => '',
  'rtconfig_interface'  => 3,
  'rtconfig_wchan'      => 9,
  'rtconfig_fwvers'     => 1
);

if (isset($Phs_POST['submit2'])) {
  //print_r($Phs_POST);
  $routerConfig = Array(
    'rtconfig_name'       => trim($Phs_POST['rname']),
    'rtconfig_rid'        => trim($Phs_POST['rid']),
    'rtconfig_lanip1'     => trim($Phs_POST['lanip1']),
    'rtconfig_lanip2'     => trim($Phs_POST['lanip2']),
    'rtconfig_lanip3'     => trim($Phs_POST['lanip3']),
    'rtconfig_lanip4'     => trim($Phs_POST['lanip4']),
    'rtconfig_netmask1'   => trim($Phs_POST['netmask1']),
    'rtconfig_netmask2'   => trim($Phs_POST['netmask2']),
    'rtconfig_netmask3'   => trim($Phs_POST['netmask3']),
    'rtconfig_netmask4'   => trim($Phs_POST['netmask4']),
    'rtconfig_gateway1'   => trim($Phs_POST['gateway1']),
    'rtconfig_gateway2'   => trim($Phs_POST['gateway2']),
    'rtconfig_gateway3'   => trim($Phs_POST['gateway3']),
    'rtconfig_gateway4'   => trim($Phs_POST['gateway4']),
    'rtconfig_locdns1'    => trim($Phs_POST['locdns1']),
    'rtconfig_locdns2'    => trim($Phs_POST['locdns2']),
    'rtconfig_locdns3'    => trim($Phs_POST['locdns3']),
    'rtconfig_locdns4'    => trim($Phs_POST['locdns4']),
    'rtconfig_ssid'       => trim($Phs_POST['ssid']),
    'rtconfig_wpower'     => trim($Phs_POST['wpower']),
    'rtconfig_rmac1'      => trim($Phs_POST['rmac1']),
    'rtconfig_rmac2'      => trim($Phs_POST['rmac2']),
    'rtconfig_rmac3'      => trim($Phs_POST['rmac3']),
    'rtconfig_rmac4'      => trim($Phs_POST['rmac4']),
    'rtconfig_rmac5'      => trim($Phs_POST['rmac5']),
    'rtconfig_rmac6'      => trim($Phs_POST['rmac6']),
    'rtconfig_interface'  => trim($Phs_POST['interface_id']),
    'rtconfig_wchan'      => trim($Phs_POST['wchan_id']),
    'rtconfig_fwvers'     => trim($Phs_POST['fwvers_id'])
  );
  $_routerConfigFile = trim($Phs_POST['conffile']);
  if (strpos($_routerConfigFile, ' ')) { // do not allow file name with spaces
    $Phs_ErrMsg = 'No spaces in configuration file name allowed';
    $process_error = True;
  } else {
    if ($routerConfig['rtconfig_interface'] == 1) $_isAccessPoint = true;
  /*
   * Validate input here
   */  
    $_validated = false;
    include('includes/router-inc.php');

    $ddwrt_conf_val_v23['lan_ipaddr'] = $routerConfig['rtconfig_lanip1'] . '.' .
                                        $routerConfig['rtconfig_lanip2'] . '.' .
                                        $routerConfig['rtconfig_lanip3'] . '.' .
                                        $routerConfig['rtconfig_lanip4'];
    if (!is_ipaddress($ddwrt_conf_val_v23['lan_ipaddr'])) {
      $Phs_ErrMsg = 'LAN IP Address incorrect';
      $process_error = True;
    } else {
      $ddwrt_conf_val_v23['lan_netmask'] = $routerConfig['rtconfig_netmask1'] . '.' .
                                        $routerConfig['rtconfig_netmask2'] . '.' .
                                        $routerConfig['rtconfig_netmask3'] . '.' .
                                        $routerConfig['rtconfig_netmask4'];
      if (!is_ipaddress($ddwrt_conf_val_v23['lan_netmask'], True)) {
        $Phs_ErrMsg = 'Netmask incorrect';
        $process_error = True;
      } else {
        //$ddwrt_conf_val_v23['lan_gateway'] = (empty($routerConfig['rtconfig_gateway1']) ? '0.0.0.0' : $routerConfig['rtconfig_gateway1'] . '.' .
        $ddwrt_conf_val_v23['lan_gateway'] = $routerConfig['rtconfig_gateway1'] . '.' .
                                        $routerConfig['rtconfig_gateway2'] . '.' .
                                        $routerConfig['rtconfig_gateway3'] . '.' .
                                        $routerConfig['rtconfig_gateway4'];
        if (!is_ipaddress($ddwrt_conf_val_v23['lan_gateway'])) {
          $Phs_ErrMsg = 'Gateway IP Address incorrect';
          $process_error = True;
        } else {
          //$ddwrt_conf_val_v23['lan_domain'] = (empty($routerConfig['rtconfig_locdns1']) ? '' : $routerConfig['rtconfig_locdns1'] . '.' .
          $ddwrt_conf_val_v23['lan_domain'] = $routerConfig['rtconfig_locdns1'] . '.' .
                                        $routerConfig['rtconfig_locdns2'] . '.' .
                                        $routerConfig['rtconfig_locdns3'] . '.' .
                                        $routerConfig['rtconfig_locdns4'];
          if (!empty($ddwrt_conf_val_v23['lan_domain']) && !is_ipaddress($ddwrt_conf_val_v23['lan_domain'])) {
            $Phs_ErrMsg = 'Local DNS IP Address incorrect';
            $process_error = True;
          } else {
            //$ddwrt_conf_val_v23['chilli_radiusnasid']
            for ($ix=1; $ix <= 6; $ix++) {
              if (!(strlen($routerConfig['rtconfig_rmac' . $ix]) > 0) || !ctype_xdigit($routerConfig['rtconfig_rmac' . $ix])) {
                $Phs_ErrMsg = 'Router MAC Address incorrect';
                $process_error = True;
                break;

              } else {
                $routerConfig['rtconfig_rmac' . $ix] = sprintf('%02s', strtoupper($routerConfig['rtconfig_rmac' . $ix]));
                $ddwrt_conf_val_v23['chilli_radiusnasid'] .= $routerConfig['rtconfig_rmac' . $ix];
                if ($ix == 6) continue;
                $ddwrt_conf_val_v23['chilli_radiusnasid'] .= ':';
              }
            }
            if ($_isAccessPoint) { // only if used as PHS Access Point
              // check if gateway and dns is defined for Access Point
              if ($routerConfig['rtconfig_gateway1'] == '0') {
                $Phs_ErrMsg = 'Default Gateway for Access Point not correct. Usually it is 192.168.10.1';
                $process_error = True;
              } elseif ($routerConfig['rtconfig_locdns1'] == '0') {
                $Phs_ErrMsg = 'Local DNS for Access Point incorrect. Try OpenDNS: 208.67.222.222 or your preferred DNS server';
                $process_error = True;
              }
            }
            //print('VALLLLLL');
            //print(' MAC:'.$ddwrt_conf_val_v23['chilli_radiusnasid']);
            //print('VALIDATED');

            switch ($routerConfig['rtconfig_fwvers']) {
            case 'v23':
              $_monitorArg1 = PHS_NV_OMONITOR_V23;
              $_chilli_interface = 'wanwlan';
              break;
            case 'v24':
              //$_monitorArg1 = PHS_NV_OMONITOR_V24;
	// 20100702gr
              $ddwrt_conf_val_v23['cron_jobs'] = '2-59/10 * * * * root /usr/bin/wget -q -O /dev/null \"http://stat.pointhotspot.com/st/alive.acl?clid=' . PHS_CLIENT_ID . PHS_NV_OMONITOR1V24;

              $_chilli_interface = 'br0';
              break;
            default:
            }
          }
        }
      }
    }
  }
/*
 * Input successfully validated, generate auto config file
 */  
  if (!$process_error) {

    $ddwrt_conf_val_v23['router_name'] = $routerConfig['rtconfig_name'];
    $ddwrt_conf_val_v23['wan_hostname'] = $routerConfig['rtconfig_name'];
    switch($routerConfig['rtconfig_interface']) {
    case 1: // Access point only
      $ddwrt_conf_val_v23['chilli_interface'] = '';
        // reset Chillispot parameters for Access Points
      $ddwrt_conf_val_v23['chilli_enable'] = '0';
      $ddwrt_conf_val_v23['chilli_backup'] = '';
      $ddwrt_conf_val_v23['chilli_uamanydns'] = '';
      $ddwrt_conf_val_v23['chilli_uamallowed'] = '';
      $ddwrt_conf_val_v23['chilli_radius'] = '';
      $ddwrt_conf_val_v23['chilli_additional'] = '';
      $ddwrt_conf_val_v23['chilli_nowifibridge'] = '';
      $ddwrt_conf_val_v23['chilli_macauth'] = '';
      $ddwrt_conf_val_v23['chilli_radiusnasid'] = '';
      $ddwrt_conf_val_v23['chilli_url'] = '';
      $ddwrt_conf_val_v23['chilli_pass'] = '';
      $ddwrt_conf_val_v23['chilli_uamsecret'] = '';
      $ddwrt_conf_val_v23['chilli_dns1'] = '';
      break;
    case 2: // WLAN
      $ddwrt_conf_val_v23['chilli_enable'] = '1';
      $ddwrt_conf_val_v23['chilli_nowifibridge'] = '1';
      break;
    case 3: // WAN/WLAN
      $ddwrt_conf_val_v23['chilli_enable'] = '1';
      break;
    }
    //$ddwrt_conf_val_v23['chilli_radiusnasid'] = $routerConfig['rtconfig_radnasid'];
    $ddwrt_conf_val_v23['chilli_interface'] = $_chilli_interface;
    $ddwrt_conf_val_v23['wl_channel'] = $routerConfig['rtconfig_wchan'];
    $ddwrt_conf_val_v23['wl0_channel'] = $routerConfig['rtconfig_wchan'];
    $ddwrt_conf_val_v23['d11g_channel'] = $routerConfig['rtconfig_wchan'];

    $ddwrt_conf_val_v23['wl_ssid'] = $routerConfig['rtconfig_ssid'];
    $ddwrt_conf_val_v23['wl0_ssid'] = $routerConfig['rtconfig_ssid'];

    switch ($routerConfig['rtconfig_fwvers']) {
    case 'v23':
      $ddwrt_conf_val_v23['rc_startup'] .= PHS_CLIENT_ID . PHS_NV_OMONITOR1 . $_monitorArg1 . PHS_NV_OMONITOR2 . PHS_CLIENT_ID . PHS_NV_OMONITOR3;
      break;
    case 'v24':
      $ddwrt_conf_val_v23['rc_startup'] = PHS_NV_OMONITOR2 . PHS_CLIENT_ID . PHS_NV_OMONITOR3V24;
      break;
    default:
    }

    if (!file_exists(PHS_CLIENT_DIR . $routerConfig['rtconfig_rid'] . '/' . PHS_NV_LOGINSCRIPTVARS)) {
//print(PHS_CLIENT_DIR$routerConfig['rtconfig_rid'] . '/' . PHS_NV_LOGINSCRIPTVARS);
      //print('Router ID might be incorrect: ' . $routerConfig['rtconfig_rid']);
      $Phs_ErrMsg = 'Router ID is incorrect: ' . $routerConfig['rtconfig_rid'];
      $routerid_error = True;
//print(PHS_CLIENT_DIR.' : '.$routerConfig['rtconfig_rid'].' : '.PHS_NV_LOGINSCRIPTVARS);
      //exit;
    } else {
      if ($_isAccessPoint) { // only if used as Access Point
        $ddwrt_conf_val_v23['chilli_uamsecret'] = '';
          // $loginpath from hotspot login script
        $ddwrt_conf_val_v23['chilli_url'] = '';
      } else {
        @include(PHS_CLIENT_DIR . $routerConfig['rtconfig_rid'] . '/' . PHS_NV_LOGINSCRIPTVARS);
        $ddwrt_conf_val_v23['chilli_uamsecret'] = $uamsecret;
          // $loginpath from hotspot login script
        $ddwrt_conf_val_v23['chilli_url'] .= $routerConfig['rtconfig_rid'] . '/' . $loginpath;
      }
    //print_r($ddwrt_conf_val_v23);
        // $phsSetupScript from hotspot login script
      //$_setupConfFile = PHS_CLIENT_DIR . $routerConfig['rtconfig_rid'] . '/setup/' . $phsSetupScript;
      //  20081029gr allow naming and multiple setup files
      $_setupConfFile = PHS_CLIENT_DIR . $routerConfig['rtconfig_rid'] . '/setup/' . $_routerConfigFile;
      if (file_exists($_setupConfFile)) {
        rename($_setupConfFile, $_setupConfFile.'001');
      }
      $_fh = fopen($_setupConfFile, 'w+');
      foreach ($ddwrt_conf_val_v23 as $key => $value) {
        $_line = 'nvram set ' . $key . '="' . $value . '"' . "\n"; 
        fputs($_fh, $_line); 
      }
      $_line = PHS_NV_END;
      fputs($_fh, $_line); 
      fclose($_fh);
      $_showSetupUrl = true;
    }
  }
}

//if ($routerid_error) {
//  $smarty->assign('routerid_error', true);
//} elseif ($_showSetupUrl) {
if ($_showSetupUrl) {
  $Phs_InfoMsg = 'Router Configuration Generation Successfully Completed';
  $smarty->assign('showSetupUrl', true);
  $smarty->assign('routerConfStr', 'wget -O /tmp/setwrt http://www.pointHotspot.com/' . $_setupConfFile . '; chmod 755 /tmp/setwrt; /tmp/setwrt');

  $smarty->assign('routerIpAdress', $ddwrt_conf_val_v23['lan_ipaddr']);

} else {
  $smarty->assign('showSetupUrl', false);

  // wireless channel
$smarty->assign('wchan_idx', array(1,2,3,4,5,6,7,8,9,10,11,12,13,14));
$smarty->assign('wchan_names', array('1','2','3','4','5','6','7','8','9','10','11','12','13','14'));
$smarty->assign('wchan_id', $routerConfig['rtconfig_wchan']); // selected channel

  // pointHotspot interface
$smarty->assign('interface_idx', array(1, 2, 3));
$smarty->assign('interface_names', array('None (AP only)', 'WLAN', 'LAN & WLAN'));
$smarty->assign('interface_id', $routerConfig['rtconfig_interface']); // selected interface

  // DD-WRT Firmware Selection
$smarty->assign('fwvers_idx', array('v23','v24'));
$smarty->assign('fwvers_names', array('V23', 'V24'));
$smarty->assign('fwvers_id', $routerConfig['rtconfig_fwvers']); // selected version

$smarty->assign('routerConfig', $routerConfig);
$smarty->assign('rtconfig_conffile', $_routerConfigFile);
}
$smarty->assign('PhsYourIP2', $_SERVER['REMOTE_ADDR']);
$smarty->assign('Phs_JavaPopup1', True); // include image popup code
$smarty->assign('mainHeadline', 'Gateway and Access Point Configuration Setup ');
require_once('includes/trailer-inc.php');
$smarty->display('routerset.tpl');
?>
