<?php
/***************************************************************
*
*	Rate Selection (for online payments)
*	
*	2008-11-16 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

/*
 *  1. Get Client Address(site) ID
 *  2. Check if client is enabled for online payments
 *  3. Display client name
 *  4. Display list of available Access Plans
 *  5. Explain difference between Prepaid Card and fixed account
 *  6. Allow selection of one plan (radio button)
 *  7. redirect to PayPal
 *  8. After payment is received, user can get userId and password via LifeSupport or email
 *  9. Select manually fixed account or create a single prepaid card
 *
 *  As a next step, prepaid cards could be sold automatically w/o operator invention
 *
 */

$dbc = new ClientAuth($params);

$_UScurrencyFactor = 6.3; // TT US conversion only
$_showRateTable = True;
$_tdWidth = '';
$_colSize = 1;
$_payCycle = False;
$_providerCompany = '';
$_selectedPlan = '';

if (isset($Phs_POST['submit2'])) {

  //print('POST');
  //print_r($Phs_POST);
  if (!isset($Phs_POST['plan'])) {
    $Phs_ErrMsg = 'Please select Service Plan';
  } else {

    if (($_servicePlanInfoArray = $dbc->getServicePlanInfo($Phs_POST['plan'])) == Null) {
      $Phs_ErrMsg = 'Invalid Service Plan';
    } else {
      //print_r($_servicePlanInfoArray);
      $_showRateTable = False;

      if (($_clientInfo = $dbc->getClientInfo($Phs_GET['claid'])) == Null) {
        $Phs_ErrMsg = 'Service Provider not found';
      } else {
        $_payPalRate = number_format((($_servicePlanInfoArray['package_cost_rate'] / $_UScurrencyFactor) * 1.035) + 0.3, 2);
        $smarty->assign('payPalRate', $_payPalRate);
        $_providerCompany = $_clientInfo['client_company'];
        //$smarty->assign('servicePlanInfoArray', $_servicePlanInfoArray);

        $data = array('<b>Item</b>', '<b>Value</b>');
        $data = array_merge2($data, array('Provider:', $_clientInfo['client_company']));
        $data = array_merge2($data, array('Location:', $_clientInfo['client_address_1'] . (!empty($_clientInfo['client_address_2']) ? ', ' . $_clientInfo['client_address_2'] : '') . ', ' . $_clientInfo['client_address_city'] . ', ' . $_clientInfo['client_address_country']));
        $data = array_merge2($data, array('Service Plan:', $_servicePlanInfoArray['package_type_short']));
        $data = array_merge2($data, array('Rate in US Dollar:', $_payPalRate));
        $_tdWidth = '140|';
        $_colSize = 2;
        $_payCycle = True; // don't show selection table again
        $_selectedPlan = $_servicePlanInfoArray['package_type_short'];
      }
    }
  }
} 

if (!$_payCycle && isset($Phs_GET['claid']) && $Phs_GET['claid'] > 0) {
  if (($_clientInfo = $dbc->getClientInfo($Phs_GET['claid'])) == Null) {
    $Phs_ErrMsg = 'Service Provider not found';
    //$process_error = True;
  } else {
    //print_r($_clientInfo);

    if ($_clientInfo['client_address_options'] & PHS_M_CLIENT_ONLPAYMENT) {
      //$Phs_ErrMsg = 'Online payment for this Service Provider OK';
      if (($servicePlansArray = $dbc->getServicePlans($_clientInfo['client_contact_client_id'], PHS_M_PACKT_ALL)) == Null) {
        //$Phs_ErrMsg = 'No online payment for this client';
        $Phs_ErrMsg = 'No Access Plans for this Service Provider';
      } else {
        //print_r($servicePlansArray);

        $data = Array(0 => '<b>Select</b>', 1 => '<b>Service Plan</b>', 2 => '<b>Type</b>', 3 => '<b>US$</b>');
        for ($ix=1; $ix < sizeof($servicePlansArray); $ix++) {
          $data = array_merge2($data, 
            array(
                '<input type="radio" name="plan" value="' .
                $servicePlansArray[$ix]['client_package_id'] . '">',
                $servicePlansArray[$ix]['package_type_short'],
                ($servicePlansArray[$ix]['package_type_options'] & PHS_M_PACKT_TOTAL ? 'Prepaid' : 'Fixed'),
                number_format((($servicePlansArray[$ix]['package_cost_rate'] / $_UScurrencyFactor) * 1.035) + 0.3, 2)
              ));
        }
        $_providerCompany = $_clientInfo['client_company'];
        $hiddeninput = '<input type="hidden" name="claid" value="' . $Phs_GET['claid'] . '">';
        $smarty->assign('hiddeninput', $hiddeninput);
        //print_r($data);

        $_tdWidth = '20|120|30|';
        $_colSize = 4;
      }
    } else {
      $Phs_ErrMsg = 'No online payment for this Service Provider';
    }
  }
}

$smarty->assign('selectedPlan', $_selectedPlan);
$smarty->assign('providerCompany', $_providerCompany);
$smarty->assign('tdwidth', $_tdWidth);
$smarty->assign('colsize', $_colSize);
$smarty->assign('showRateTable', $_showRateTable);
$smarty->assign('liveSupportSales', True);
$smarty->assign('payOnline', False); // Online payments disabled
//$smarty->assign('payOnline', True); // Online payments disabled
//$smarty->assign('liveSupportSales', false);
$smarty->assign('webmenu', True); // do not display SmartyMenu, use standard menu
$smarty->assign('mainHeadline', 'Online Internet Access Plan Selection');
require_once('includes/trailer-inc.php');
$smarty->display('rateselect.tpl');
?>
