<?php
/********************************************************************
*
*	Module: 	radDiscon-inc.php
*	Function:	Disconnect user in case session already exists 
*
*	Resides above user page directories 
*	(can also be included from RouterOS units with landign page in unit)
*
*	2010-04-02 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/


/*
 * array to be populated from calling page
 * 0 : UserName (with realm e.g. me@demo)
 * 1 : Password (cleartext)
 * 2 : SiteId (set by hotpoint-inc.php)
 * 3 : Note used yet: RADIUS CalledStationId (mac address of NAS) optional!
 */

ini_set('register_globals', '0');
define('PHS_PATH', '../../');
require_once('PEAR.php');
require_once('DB.php');
require_once(PHS_PATH . '../../45/phs-const-inc.php');


define('PHS_DBTABLE_RADACCT', 'phs_radacct');
define('PHS_DBTABLE_RADDISCLOG', 'phs_raddisclog');
define('PHS_DBTABLE_USER', 'phs_user');
define('PHS_RAD_IDLE_TIMEOUT', 3600);
define('PHS_RAD_ONLINE_TIMEOUT', 600); // seconds after user is guessed offline
define('PHS_RAD_COAPORT', 3799); // RADIUS disconnect port
define('PHS_RADCLIENT', '/usr/local/bin/radclient'); // RADIUS disconnect port
define('PHS_RAD_DISCONNECT', 40); // RADIUS disconnect command
define('dummyUser', -1); // dummy operator id, since no operator involved, could be hs_user_id * -1

$params = array(
	'dsn' => $db_type.'://'.$db_user.':'.$db_pass.'@'.$db_host.'/'.$db_name,
	'dsn2' => $db_type.'://'.$db_user2.':'.$db_pass2.'@'.$db_host2.'/'.$db_name2
);

$_radUserArray = Array();

/*
 * RADIUS User Class
 * 20100403gr
 */
class radUser {

	var $dbh = 0;
	var $rs = 0;

/*
 * Returns Null on success, else error message
 */
  function radUser ($param) {
    if (DB::isError($this->dbh = DB::Connect($param['dsn']))) {
      if (DB::isError($this->dbh = DB::Connect($param['dsn2']))) {
        $this->dbh->db_errmsg = $this->dbh->getMessage();
        $this->dbh->retval = $this->db_errmsg;
      } else {
        $this->param = $param;
        $this->retval = Null;
      }
    } else {
      $this->param = $param;
      $this->retval = Null;
    }
  }

  function disconnectRadUser($discUserArray) {
    global $db_user3, $db_pass, $db_name;

    /*
     * Find user and get NAS secret
     * Query return example: 
     * uuname 	     radacct_framedipaddress 	radacct_nas_ipaddress 	nas_secret 
     * eimers6@demo  192.168.182.96           192.168.25.229          c4sQ6H112345AvZ4Xk
     */
    $_query = 'SELECT user_id, uuname,  radacct_framedipaddress, radacct_nas_ipaddress, nas_secret 
                FROM ' . PHS_DBTABLE_USER . '
                INNER JOIN ' . PHS_DBTABLE_RADACCT . ' ON uuname=radacct_username 
                INNER JOIN phs_nas ON user_nas_id=nas_id AND 
                uuname=' . $this->dbh->quote($discUserArray['UserName']) . ' AND 
                user_value=' . $this->dbh->quote($discUserArray['Password']) . ' AND 
                radacct_username=uuname AND 
                DATE_ADD( radacct_mdate, INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . ' SECOND ) > NOW() AND 
                radacct_stoptime=0 AND 
                user_client_id=' . $discUserArray['siteId'] . ' 
                ORDER BY radacct_mdate DESC LIMIT 1';

    if (DB::isError($_rs = $this->dbh->Query($_query))) {
      $_result = 'User not found';
    } else {
      $_row = $_rs->fetchRow(DB_FETCHMODE_ASSOC);
    //print_r($_row);
      if(is_array($_row) && !empty($_row['radacct_nas_ipaddress'])) {

        if (DB::isError($raddisclog_id = $this->dbh->nextId('phs_raddisclog'))) { // get id to inherite
          die('Raddisclog record insert failed ' . $raddisclog_id->getMessage() . ' in nextID() ');
        }

        $query = 'SELECT sys_exec(\'echo "INSERT INTO phs_raddisclog (raddisclog_id, raddisclog_user_id, raddisclog_ccid, raddisclog_status) VALUES (' . $raddisclog_id . ', ' . $_row['user_id'] . ',' . dummyUser . ', \\\'`echo \\"User-Name = \\\'' .  $_row['uuname'] . '\\\',Framed-IP-Address=\\\'' . $_row['radacct_framedipaddress'] . '\\\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $_row['nas_secret'] . '`\\\')"|/usr/bin/mysql -u ' . $db_user3 . ' --password=' . $db_pass . ' ' . $db_name . '\')';
        if (DB::isError($rs = $this->dbh->query($query))) {
          $_return = 'Unable to disconnect user';
        } else {
          $query = 'SELECT raddisclog_status FROM ' . PHS_DBTABLE_RADDISCLOG . ' WHERE raddisclog_id=' . $raddisclog_id;
          if (DB::isError($rs = $this->dbh->query($query))) {
            $_return = 'Unable to disconnect user';
          } else {
            while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
              $_resultrow = $row;
            }
            //print_r($_resultrow);
            $_return = 'Attempting to disconnect user'  ;
            if (strstr($_resultrow['raddisclog_status'], 'code 41')) {
              //$_return = 'User successfully disconnected';
              $_return = Null;
            } elseif (strstr($_resultrow['raddisclog_status'], 'code 42')) {
              $_return = 'User not disconnected - User was not online';
            } else {
              $_return = 'Unable to disconnect user';
            }
          }
        }
      }
    }
    return($_return);
  }
}
?>
