<?php
/**
 * Program: install.php
 * 
 * Installer for PayPal PHP SDK
 * This version assumes that the distribution (.zip, .tar, .tar.gz) has already
 * been expanded since this script is included in the distribution.
 * 
 * Author:  D. Harvey
 * Date:  2/21/2006
 * 
 * Notes:
 * - Handle entered directories with/without trailing slash
 * - The install.php resides at the top of the PHP tree so there is no install required
 *   for the PHP libs.
 * 
 */

/**
 * From current PHP install instructions:
 * 
Any scripts that use the SDK must force the new pear path into the PHP include_path. An example:
$include_path = ini_get('include_path');
$pear_path = "/home/usernamel/pear/";
if(!stristr($pear_path,$include_path)) ini_set('include_path',$include_path . 
PATH_SEPARATOR . $pear_path);

if (strtoupper(substr(PHP_OS, 0,3) == 'WIN')) { $seperator = ';'; } else { $seperator = ':'; } 

[update]
PHP 4.3.4 provides the predefined constant PATH_SEPARATOR 
which contains the above character needed for include paths.

*/

DEFINE('PAYPAL_PHP_SDK', 'php-sdk');
DEFINE('PPSDK_INCLUDE_PATH','ppsdk_include_path.inc');

$lib_list = array(
'HTTP', 'Log', 'Net', 'Services_PayPal', 'docs'
);

$web_list = array(
'samples'
);

$reqd_ext = array(
'curl',
'openssl'
);

$stdin = fopen('php://stdin', 'r');


// $dist_dir = dirname(__FILE__);
$dist_dir = '.';
if( ! inSdkDir()) {
	$sdk_dir = dirname(__FILE__);
	error_message("Please cd to the $sdk_dir and run install.php\n");
	exit(1);
}
echo "Installing from PHP SDK...\n";

generate_ini_set(PPSDK_INCLUDE_PATH);

/*
echo "Please enter your target PHP library directory> ";
$php_lib_dir = strip_slash(trim(fgets($stdin)));
if( ! is_dir($php_lib_dir)) {
	// Create if it does not exist
	error_message('Invalid PHP library directory');
	exit(1);
}
echo "Install PHP SDK in $php_lib_dir\n";
*/

echo "Please enter your target PHP web directory> ";
$php_web_dir = strip_slash(trim(fgets($stdin)));
if( ! is_dir($php_web_dir)) {
	// Create if it does not exist
	echo "Create $php_web_dir...\n";
	mkdir($php_web_dir, 0755);
}
echo "Install PHP SDK Web samples to $php_web_dir\n";

if(! ($err = validate_php_env())) {
	error_message('Invalid PHP environment: '. $err);
	exit(1);	
}

/**
 * Start the installing...
 */
echo "\nStart installation...\n";
// install_libs($dist_dir, $php_lib_dir, $lib_list);

install_web($dist_dir, $php_web_dir, $web_list);

exit(0);


/**
 * Utility functions below
 */

function error_message($msg)
{
	global $argv;
	echo "$argv[0] ERROR: $msg\n";	
}

function &strip_slash ($path)
{
	$result = $path;
	if(strrpos($path, '/') === strlen($path)-1) {
		$result = substr($path, 0, strlen($path)-1);	
	}
	return $result;	
}

function inSdkDir()
{
    $sdk_dir = dirname(__FILE__);
    echo "DEBUG> SDK dir is $sdk_dir\n";
	// $x = strpos($sdk_dir, PAYPAL_PHP_SDK);
    if( strpos($sdk_dir, PAYPAL_PHP_SDK) === strlen($sdk_dir)-strlen(PAYPAL_PHP_SDK)) {
        return true;
    } else {
        return false;
    }
}

function validate_php_env($verbose=true)
{
	global $reqd_ext;
	$result=true;

	$php_ext = get_loaded_extensions();
	if($verbose) print_r($php_ext);
	foreach($reqd_ext as $ext){
		if(! in_array($ext, $reqd_ext)) $result=false;		
	}
	return $result;
}

function generate_ini_set($phpfile)
{
	if(! ($fp = fopen($phpfile, 'w'))) {	
		error_message("Unable to generate $phpfile");
		return false;	
	}
	$sdk_dir=dirname(__FILE__);
	$include_path = ini_get('include_path');
	
	if(!stristr($sdk_dir,$include_path)) {
		$stamp = date('m/d/Y H:i:s');
		// echo "PATH_SEPARATOR=".PATH_SEPARATOR. "\n";
		$code = "<?php\n\n";
		$code .= "//*******************************************\n";
		$code .= "// AUTO-GENERATED include for PayPal PHP SDK\n";
		$code .= "// Created by install.php on $stamp\n";
		$code .= "//*******************************************\n\n";
		$code .= "ini_set('include_path',\"$include_path:$sdk_dir\");\n";
		$code .= "?>\n";
	}
	fwrite($fp, $code);
	fclose($fp);
	return true;
}

/*
function install_libs(&$from_dir, &$to_dir, &$list)
{
	echo "Install PayPal PHP libs:\n";
	foreach($list as $dir) {
		echo "Install $dir tree...\n";
		copydirr($from_dir.'/'.$dir, $to_dir.'/'.$dir );
	}
	echo "\n";
}
*/

function install_web(&$from_dir, &$to_dir, &$list)
{
	echo "Install PayPal sample web applications:\n";
	// echo "DEBUG> from_dir=$from_dir\nto_dir=$to_dir\n";
	foreach($list as $dir) {
		echo "Install $dir tree...\n";
		// copydirr($from_dir.'/'.$dir, $to_dir.'/'.$dir, 0755, true);
		copydirr($from_dir.'/'.$dir, $to_dir.'/'.$dir, 0755, false);
	}
	copy ('./'.PPSDK_INCLUDE_PATH, $to_dir.'/samples/php/'.PPSDK_INCLUDE_PATH);
	echo "\n";	
}

function copydirr($fromDir,$toDir,$chmod=0757,$verbose=false)
/*
   copies everything from directory $fromDir to directory $toDir
   and sets up files mode $chmod
*/
{
//* Check for some errors
$errors=array();
$messages=array();
if (!is_dir($toDir)) {
   // $errors[]='target '.$toDir.' is not writable';
   mkdir($toDir, $chmod);
}
if (!is_dir($fromDir))
   $errors[]='source '.$fromDir.' is not a directory';
if (!empty($errors))
   {
   if ($verbose)
       foreach($errors as $err)
           echo '<strong>Error</strong>: '.$err.'<br />';
   return false;
   }
//*/
$exceptions=array('.','..');
//* Processing
$handle=opendir($fromDir);
while (false!==($item=readdir($handle)))
   if (!in_array($item,$exceptions))
       {
       //* cleanup for trailing slashes in directories destinations
       $from=str_replace('//','/',$fromDir.'/'.$item);
       $to=str_replace('//','/',$toDir.'/'.$item);
       //*/
       if (is_file($from))
           {
           if (@copy($from,$to))
               {
               chmod($to,$chmod);
               touch($to,filemtime($from)); // to track last modified time
               $messages[]='File copied from '.$from.' to '.$to;
               }
           else
               $errors[]='cannot copy file from '.$from.' to '.$to;
           }
       if (is_dir($from))
           {
           if (@mkdir($to))
               {
               chmod($to,$chmod);
               $messages[]='Directory created: '.$to;
               }
           else
               $errors[]='cannot create directory '.$to;
           copydirr($from,$to,$chmod,$verbose);
           }
       }
closedir($handle);
//*/
//* Output
if ($verbose)
   {
   foreach($errors as $err)
       echo '<strong>Error</strong>: '.$err.'<br />';
   foreach($messages as $msg)
       echo $msg.'<br />';
   }
//*/
return true;
}


?>
