#/bin/sh
######################################################################
#
#  Program:  build.sh
#            Script to package PHP SDK from CVS project.
#            It is packaged in .zip, .tar, and .tar.gz formats
#
#  Author:  D.Harvey,  3/2006
#
######################################################################

pushd .

PHP_SDK_ROOT=php-sdk
SDK_TEMP=sdktemp
SDK_VER=4_0
export PHP_SDK_ROOT SDK_TEMP SDK_VER

rm -rf ../${SDK_TEMP}
mkdir ../${SDK_TEMP}
cp -R . ../${SDK_TEMP}/${PHP_SDK_ROOT}
cd ../${SDK_TEMP}/${PHP_SDK_ROOT}


echo "$0> remove CVS directories"
find . -name CVS -exec rm -rf {} \;
mv Services_PayPal Services
cd ..
echo "$0> create zip package"
zip -rq paypal_php_sdk_v${SDK_VER}.zip ${PHP_SDK_ROOT}

echo "$0> create tar package"
tar cf paypal_php_sdk_v${SDK_VER}.tar ${PHP_SDK_ROOT}

echo "$0> create tar.gz package"
tar cfz paypal_php_sdk_v${SDK_VER}.tar.gz ${PHP_SDK_ROOT}

ls -l

popd

