<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: ewp_button.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'lib/functions.inc.php';
require_once 'Services/PayPal/Profile/EWP.php';

session_start();

if (empty($_SESSION['pphandler']) ||
    empty($_SESSION['pphandler_params']) ||
    empty($_SESSION['ewpprofile']))
{
    trigger_error("Unknown Profile Handler or missing parameters", E_USER_ERROR);
    exit;
}

$handlerinst = &_getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);
if (Services_PayPal::isError($handlerinst))
{
    trigger_error($handlerinst->getMessage(), E_USER_ERROR);
    exit;
}

if (!isset($_SESSION['ewppassword'][$_SESSION['ewpprofile']])) {
    if (!isset($_POST['submitted'])) {
        $profile =& EWPProfile::getInstance($_SESSION['ewpprofile'], $handlerinst);
        require 'pages/ewp_pw.html.php';
        exit;
    } else {
        $_SESSION['ewppassword'][$_SESSION['ewpprofile']] = $_POST['pw'];
    }
}

if (!empty($_POST['params'])) {
    // make button.
    $profile =& EWPProfile::getInstance($_SESSION['ewpprofile'], $handlerinst);
    if (Services_PayPal::isError($profile)) {
        var_dump($profile->getMessage());
        exit;
    }

    $profile->setPrivateKeyPassword($_SESSION['ewppassword'][$_SESSION['ewpprofile']]);

    $buttonparams = array();
    $params = explode("\n", $_POST['params']);
    foreach ($params as $p) {
        list($key, $value) = explode('=', $p, 2);
        $buttonparams[trim($key)] = trim($value);
    }

    $ewp = &Services_PayPal::getEWPServices($profile);
    $form = $ewp->encryptButton($buttonparams);
    if (Services_PayPal::isError($form)) {
        $form = $form->getMessage();
    }
    require 'pages/ewp_button_display.html.php';
} else {
    require 'pages/ewp_button.html.php';
}
