<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: builder.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once '../lib/functions.inc.php';
require_once 'lib/functions.inc.php';

session_start();

if(empty($_SESSION['pphandler']) ||
   empty($_SESSION['pphandler_params']) ||
   empty($_SESSION['apiprofile']) ||
   !isset($_SESSION['apipassword'][$_SESSION['apiprofile']]))
{
    trigger_error("Unknown Profile Handler or missing parameters", E_USER_ERROR);
    exit;
}

$handlerinst = &_getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

if(Services_PayPal::isError($handlerinst))
{
    trigger_error($handlerinst->getMessage(), E_USER_ERROR);
    exit;
}

if((isset($_POST['action']) &&
   ($_POST['action'] == "Start Again")) ||
   (isset($_GET['reset'])))
{
    resetCallerSession();
}

$mode = !empty($_REQUEST['mode']) ? $_REQUEST['mode'] : (!empty($_SESSION['mode']) ? $_SESSION['mode'] : 'start');
switch($mode)
{
    default:
    case 'start':

        $apimethods = Services_PayPal::getCallerServicesIntrospection();

        $_SESSION['item_names'] = array();           // "pretty" names of items
        $_SESSION['type_queue'] = array();           // Types in line for being processed
        $_SESSION['type_info'] = array();
        $_SESSION['method'] = $_REQUEST['method'];   // Method we are trying to call
        $_SESSION['result'] = array();               // Ultimate Result

        $_SESSION['mode'] = 'building';

        $current_type = array('id' => generateItemID(),
                              'type' => $apimethods[$_SESSION['method']]['param'],
                              'label' => $_SESSION['method'],
                              'required' => true);

        array_unshift($_SESSION['type_queue'], $current_type);
        $_SESSION['type_info'][$current_type['id']] = $current_type;

        unset($_POST['submitted']);
        // Fall through to the next case - don't break here!

    case 'building':

        $success = true;
        $non_required_items = array();

        if(isset($_POST['submitted']))
        {
            $errors = array();

            if(empty($_POST['current_type']))
            {
                trigger_error("Could not identify the current type. Cannot continue.", E_USER_ERROR);
                exit;
            }

            foreach($_POST['item'] as $item_id=>$submit_value)
            {
                if(!isset($_SESSION['type_info'][$item_id]))
                {
                    $errors[] = "Item with Item ID '$item_id' was invalid. Cannot continue.";
                }
                else
                {
                    if($_SESSION['type_info'][$item_id]['required'] &&
                       empty($_POST['item'][$item_id]) &&
                       !$_SESSION['type_info'][$item_id]['complex'])
                    {
                        $label = $_SESSION['type_info'][$item_id]['label'];
                        $errors[] = "'$label' is a required field. Please try again.";
                    }
                }
            }

            $success = empty($errors);

            if($success)
            {
                foreach($_POST['item'] as $item_id=>$submit_value)
                {
                    if(!$_SESSION['type_info'][$item_id]['complex'])
                    {
                        $_SESSION['result'][$_POST['current_type']][$item_id] = $submit_value;
                    }
                    else
                    {
                        $_SESSION['result'][$_POST['current_type']][$item_id] = array();
                    }
                }

                if(isset($_POST['required']) && is_array($_POST['required']))
                {
                    foreach($_POST['required'] as $req_id => $status)
                    {
                        if(($status == 'false') &&
                           !$_SESSION['type_info'][$req_id]['required'])
                        {
                            $non_required_items[] = $req_id;
                        }
                    }
                }

            }
        }

        if($success)
        {
            if(empty($_SESSION['type_queue'])) // Nothing left?
            {
                $_SESSION['mode'] = 'generate';
                header("Location: {$_SERVER['PHP_SELF']}");
                exit;
            }

            $current_type = null;

            if(!empty($non_required_items))
            {
                while(($current_type == null) &&
                     !empty($_SESSION['type_queue']))
                {
                    $current_type = array_shift($_SESSION['type_queue']);
                    if(in_array($current_type['id'], $non_required_items))
                    {
                        $current_type = null;
                    }
                }
            }
            else
            {
                $current_type = array_shift($_SESSION['type_queue']);
            }

            if(is_null($current_type))
            {
                $_SESSION['mode'] = 'generate';
                header("Location: {$_SERVER['PHP_SELF']}");
                exit;
            }
            else
            {
                $form_data = processType($current_type);
                $_SESSION['current_form_data'] = $form_data;
                $_SESSION['current_type_data'] = $current_type;
            }

        }
        else
        {
            if(isset($_SESSION['current_form_data']))
            {
                $form_data = $_SESSION['current_form_data'];
                $current_type = $_SESSION['current_type_data'];
                unset($_SESSION['current_form_data']);
                unset($_SESSION['current_type_data']);
            }
        }


        break;

    case 'generate':
        $code = generatePHPCodeFromResult($_SESSION['result'],
                                          $_SESSION['type_info'],
                                          $_SESSION['pphandler'],
                                          $_SESSION['pphandler_params'],
                                          $_SESSION['apiprofile'],
                                          $_SESSION['apipassword'][$_SESSION['apiprofile']]);
        require 'pages/builder_codegen.html.php';
        exit;
        break;

    case 'execute':
        $code = generatePHPCodeFromResult($_SESSION['result'],
                                          $_SESSION['type_info'],
                                          $_SESSION['pphandler'],
                                          $_SESSION['pphandler_params'],
                                          $_SESSION['apiprofile'],
                                          $_SESSION['apipassword'][$_SESSION['apiprofile']]);
        require 'pages/builder_coderun.html.php';
        exit;

}

require_once 'pages/builder.html.php';
