<?php
    require_once '../lib/functions.inc.php';
    session_start();    
    
    if(!isset($_GET['categoryID']) || !isset($_gallery_categories[$_GET['categoryID']]))
    {
        header("Location: home.php");
        exit;
    }
    
    $catID = (int)$_GET['categoryID'];
    $_SESSION['currentCatID'] = $catID;
    $show_paypal_button = ($_SESSION['productID'] == 1);
    
    if($show_paypal_button)
    {
        $_info_box = "The <strong>Add to Cart</strong> button demonstrates how PayPal can easily and quickly aggregate multiple purchases into existing third party shopping carts.</p> <p>The PayPal <strong>Buy Now</strong> button is perfect for single-item purchases if you don't have a shopping cart on your website.";
    }
    
    include_once '../lib/html/header.html.php';
?>
<table class="main" border="0" cellpadding="0" cellspacing="0" width="750">
<tbody><tr>
<td align="left" valign="top">

	<table class="nav" border="0" cellpadding="0" cellspacing="0" width="131">
	<tbody><tr>
	<td>

		<table class="child" border="0" cellpadding="0" cellspacing="3" width="100%">
		<tbody><tr>
		<td>
			<table class="menu" border="0" cellpadding="0" cellspacing="0" width="100%">
			<tbody><tr>
			<td><p class="category">Category</p></td>
			</tr>
			<?php
			 
			     foreach($_gallery_categories as $id => $name)
			     {
			         if($id < 0)
			         {
			             print "<tr><td><p class='PseudoHR'><img src='../images/spacer.gif' alt='Separator' height='1' width='1'></p></td></tr>";
			         }
			         else
			         {             
			             print "<tr><td><p><a href='viewCategory.php?categoryID=$id'>$name</a></p></td></tr>";
			         }
			     }
			?>
			<tr>
			<td><p><a href="#">Join PhotoClub</a></p></td>
			</tr>
			<tr>
			<td><p class="NoBreakAfter"><a href="#">Order Catalog</a></p></td>
			</tr>
			</tbody></table>
		</td>
		</tr>
		</tbody></table>
	</td>
	</tr>
	<tr>
	<td class="foot"><img src="../images/designerfotos_nav_bottom.gif" alt="" border="0" height="22" width="131"></td>
	</tr>
	</tbody></table>

</td>
<td align="left" valign="top">

	<table class="content" border="0" cellpadding="0" cellspacing="0" width="619">
	<tbody><tr>
	<td>
	
		<img src="../images/spacer.gif" align="right" height="325" width="1">

		<p class="title">
		<?php print $_gallery_categories[$catID]; ?>
	</p>

		
		<table class="details" border="0" cellpadding="0" cellspacing="0" width="100%">
		<tbody>
		<tr>
        <?php
            
            $photos_per_row = 3;
            $temp = 0;
                
            foreach($_photo_categories[$catID] as $photoID):
            
               $photodata = $_photo_data[$photoID];
        ?>
        <td width="33%">
		<p><a href="viewCategoryDetail.php?photographID=<?php print $photoID; ?>">
		   <img src="../images/<?php print $photodata['file']; ?>_sm.jpg" 
                alt="<?php print $photodata['title']; ?>" 
                border="0" height="120" width="150"></a></p>
	    <p><a href="viewCategoryDetail.php?photographID=<?php print $photoID; ?>"><?php print $photodata['title']; ?></a>
	    <br>
		<?php print $photodata['size']; ?>
		<br>
		<span class="price">$<?php print number_format($photodata['price'],2); ?></span>
	    </p>
		<form name="addToCartForm" action="addToCart.php" method="get">
		<input name="photographID" value="<?php print $photoID; ?>" type="hidden">
		<?php if($show_paypal_button): ?>
		<img src="../images/i_sm.gif" alt="info" align="middle" border="0" height="16" width="16"> 
		<?php endif; ?>
		<input name="addToCartBtn" value="Add to Cart" type="submit">
		</form>
        <?php if($show_paypal_button): ?>
	    <p class="or">Or</p>
		<form name="buyNowForm" action="https://www.sandbox.paypal.com/cgi-bin/webscr" method="post">
        <input name="cmd" value="_xclick" type="hidden">
        <input name="business" value="<?php print $_SESSION['emailAddress']; ?>" type="hidden">
        <input name="amount" value="<?php print number_format($photodata['price'], 2); ?>" type="hidden">
        <input name="item_name" value="<?php print "{$photodata['title']} ({$photodata['size']})"; ?>" type="hidden">
        <input name="quantity" value="1" type="hidden">
        <input name="undefined_quantity" value="1" type="hidden">
        <input name="no_note" value="0" type="hidden">
        <input name="no_shipping" value="2" type="hidden">
        <input name="cancel_return" value="<?php print get_url(); ?>viewCart.php?<?php print session_name().'='.session_id(); ?>" type="hidden">
        <input name="return" value="<?php print get_url(); ?>completeOrder.php?<?php print session_name().'='.session_id(); ?>" type="hidden">
        <input name="rm" value="1" type="hidden">
        <input name="shipping" value="" type="hidden">
		<img src="../images/i_sm.gif" alt="info" align="middle" border="0" height="16" width="16"> 
		<input src="../images/paypal_buy_now.jpg" name="buyNowBtn" type="image">
		</form>
        <?php endif; ?>				
	    </td>
	    <?php if(++$temp > $photos_per_row): ?>
	    </tr><tr>
	    <?php $temp = 0; endif; ?>
	    <?php endforeach; ?>
		</tr>
		</tbody></table>
	
	</td>
	</tr>
	</tbody></table>
</td>
</tr>
</tbody></table>
<?php include_once '../lib/html/footer.html.php'; ?>