<?php
    require_once '../lib/functions.inc.php';
    session_start();
    
    $_info_box = "The <strong>Submit Refund</strong> button calls the <code>RefundTransaction</code> API and completes the request unless otherwise indicated.";

    /* This would normally not be necessary, but since we are performing the call on the fly
    we need to write the data in the certificate file to the filesystem temporarily to perform
    the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage(), true);
    }
    
    $details =& Services_PayPal::getType('GetTransactionDetailsRequestType');
    $details->setTransactionId($_GET['transID']);
    
    $result = $caller->GetTransactionDetails($details);
    @unlink($filename); 
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), false);
    }    
    
    $td = $result->PaymentTransactionDetails;
       
    include_once '../lib/html/header.html.php';
?>
<table cellpadding="0" cellspacing="0" border="0" width="750">
<tr>
<td align="left">

	<table cellpadding="0" cellspacing="0" border="0" width="750" class="content">
	<tr>
	<td>
	
		<p class="title">Refund Order</p>

		<p>Fill out the form below to process a refund.</p>

		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="detail">
		<tr>
		<td>

			<form name="submitRefundForm" action="orderDetailsRefunded.php" method="POST">
            <input type="hidden" NAME="transID" value="<?php print $_GET['transID']; ?>">
            <input type="hidden" NAME="orderID" value="<?php print $_GET['orderID']; ?>">
				<table cellpadding="0" cellspacing="0" border="0" class="formForm" width="100%">
				<tr>

				<td class="formLabel" valign="top"><p>Order ID:</p></td>
				<td class="formOutput">
					<p><?php print (int)$_GET['orderID']; ?></p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Order Total:</p></td>
				<td class="formOutput">

					<p><?php print $td->PaymentInfo->GrossAmount->_value; ?></p>
				</td>
				<tr>
				<td class="formLabel" valign="top"><p>Refund Type:</p></td>
				<td class="formInput">
					<p>
						<input type="radio" name="type" value="full" class="inputRadio"/> Full
						<br/>

						<input type="radio" name="type" value="partial" class="inputRadio"/> Partial &nbsp; <b>Amount:</b> <input type="text" name="amount" value="" class="inputTextM" />
					</p>
				</td>
				</tr>
				<tr>
				<td class="formLabel" valign="top"><p>Notes:</p></td>

				<td class="formInput">
					<p>
						<textarea name="notes" class="inputTextarea" rows="4"></textarea>
					</p>
				</td>
				</tr>
				</table>
				
				<table cellpadding="0" cellspacing="0" border="0" class="formForm">
				<tr>

				<td class="formLabel"><p><img src="../images/i.gif" width="18" height="18" alt="Information" border="0"/></p></td>
				<td class="formInput">
					<input type="submit" name="submitRefundBtn" value="Submit Refund" /> 
					<input type="button" name="cancelBtn" value="Cancel" onclick="cancelRefund();"/>
				</td>
				</tr>
				</table>
			</form>
		</td>

		</tr>
		</table>
	</td>
	</tr>
	</table>
</td>
</tr>
</table>
<?php include_once '../lib/html/footer.html.php'; ?>