<?php
    require_once '../lib/functions.inc.php';
    session_start();
    
    if(isset($_POST['shipping']))
    {
        $_SESSION['shipping_info'] = $_POST['shipping'];
    }
    
    $custom_shipping = false;
    if(!count($_SESSION['cart']->getItems()))
    {
        header("Location: viewCart.php");
        exit;
    }

    $total = get_cart_total(&$_SESSION['cart']);

    $reqDetails =& Services_PayPal::getType('SetExpressCheckoutRequestDetailsType'); 
    $reqDetails->setReturnURL(get_url()."reviewExpressCheckout.php?".session_name().'='.session_id());
    $reqDetails->setCancelURL(get_url()."viewCart.php?".session_name().'='.session_id());
    $reqDetails->setOrderDescription("Payment for ".count($_SESSION['cart']->getItems())." prints from DesignerFotos");
    
    $amount =& Services_PayPal::getType('BasicAmountType');
    $amount->setval($total);
    $amount->setattr('currencyID', 'USD');
    
    $reqDetails->setOrderTotal($amount);
    if($custom_shipping)
    {
        $si = $_SESSION['shipping_info'];
        
        $address =& Services_PayPal::getType('AddressType');
        $address->setStreet1($si['streetAddress1']);
        
        if(!empty($si['streetAddress2']))
        {
            $address->setStreet2($si['streetAddress2']);
        }
        
        $address->setCityName($si['city']);
        $address->setStateOrProvince($si['state']);
        $address->setCountry($si['country']);
        $address->setPostalCode($si['zipCode']);              
                
        $reqDetails->setAddress($address);
        $reqDetails->setAddressOverride(true);
    }
    
    $requestType =& Services_PayPal::getType('SetExpressCheckoutRequestType');
    $requestType->setSetExpressCheckoutRequestDetails($reqDetails);

    /* This would normally not be necessary, but since we are performing the call on the fly
       we need to write the data in the certificate file to the filesystem temporarily to perform
       the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage, true);
    }
    
    $result = $caller->SetExpressCheckout($requestType);
    @unlink($filename);
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), false);
    }
    
    switch($result->Ack)
    {
        case "Success":
            $_SESSION['expressCheckoutToken'] = $result->getToken();
            
            $domain = "https://www." . 
                      (($_SESSION['APIProfile']->getEnvironment() == "Sandbox") ?
                      "sandbox." : "") .
                      "paypal.com";
            
            $url = "$domain/webscr&cmd=_express-checkout&token={$_SESSION['expressCheckoutToken']}";
            header("Location:  $url");
            exit;                
        case "Failure":
            do_error($result->Errors->ShortMessage, false);
            break;
        default:
            do_error("Unknown Acknowledgement: {$result->Ack}");
            break;
    }
?>