<?php
/********************************************************************
*	Hotspot Authentication, Authorization and Accounting System
* Registration and Payment page
*
*	Module: 	configure-inc.php
*	Function:	Setup environment
*
*	2006-04-17 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/

ini_set('register_globals', '0');
ini_set('magic_quotes_gpc', '0');
ini_set('max_execution_time', '300'); // maximum execution time for script

define ('PHS_LOG_FILE', 'logs/phsreg.log');

require('includes/database_tables-inc.php');
require('Smarty/libs/Smarty.class.php');
//require('Smarty/libs/SmartyMenu.class.php');
require_once('Auth/Auth.php');
require_once('includes/filenames-inc.php');	// all PHP filenames

// Refer to Changelog.txt for further version changes
define ('PHSSP_VERSION', 'v1.0.0'); // 20060417gr Registration and Payment page


// User data lenght validation
// ... should be selectable in admin menu
define ('PHS_LEN_PW', 5);               // min password length
define ('PHS_LEN_PW_MAX', 30);          // max password length
define ('PHS_LEN_USER', 3);             // min username lenght
define ('PHS_LEN_USER_MAX', 30);        // max username lenght
define ('PHS_LEN_LOCATION', 1);         // min location/room len
define ('PHS_LEN_LOCATION_MAX', 30);    // max location/room len
define ('PHS_LEN_FIRSTNAME', 2);
define ('PHS_LEN_FIRSTNAME_MAX', 32);
define ('PHS_LEN_LASTNAME', 2);
define ('PHS_LEN_LASTNAME_MAX', 48);
define ('PHS_LEN_EMAIL ', 6);
define ('PHS_LEN_EMAIL_MAX ', 48);
define ('PHS_LEN_SITE_MAX ', 50); // oifnet site location

define ('PHS_DATE', 'd-M-Y');	// date format
define ('PHS_FDATE', 'ymd');	// yymmdd format
define ('PHS_4FDATE', 'Ymd');	// yyyymmdd format
define ('PHS_TIME', 'h:i a');	// date format
define ('PHS_DATETIME', 'd-M-Y h:ia');	// date and time format
define ('PHS_ISODATE', 'Y-m-d');	// ISO date format
define ('PHS_ISODATETIME', 'Y-m-d H:i:s');	// ISO 9075 date/time format
define ('PHS_ISO8601', 126);	// MS-SQL ISO 8601 format 'yyyy-mm-dd Thh:mm:ss.mmm(no spaces)'

	// database wide flags for all tables
define ('PHS_ST_INACTIVE', 0);	  // normal status
define ('PHS_ST_ACTIVE', 1);	    // either offline or online
define ('PHS_ST_SUSPENDED', 2);	  //
define ('PHS_ST_IDLE_TIMEOUT', 4);//
define ('PHS_ST_EXPIRED', 8);		  //
define ('PHS_ST_PENDING', 16);		// start in future
define ('PHS_ST_READY', 32);      // ready for login
define ('PHS_ST_PREPAID', 64);    // this is a prepaid card
define ('PHS_ST_DEL', 128);		    // row status: marked as deleted

define ('PHS_ST_LOGINREADY', 323232);      // return from getUserStatus and getAllUsers when user was not yet logged in

define ('PHS_STP_ALL', 1);  // Search Type: show ALL records

define ('PHS_DB_COMMIT', 0);    // allow commit when doing nested db calls
define ('PHS_DB_NO_COMMIT', 2); // supress commit when doing nested db calls

	// database flags for alterations
define ('PHS_ALT_STD', 1);	// standard alterations
define ('PHS_ALT_NOSTD', 2);	// non-standard alterations
define ('PHS_ALT_ZERO', 127);	// zero alteration value to allow the value 0
                                // note: value for tinyint (range different in MySQL)

define ('PHS_PW_DUMMY', '___0__'); // dummy filler for form input fields

define ('PHS_PRINT_LABEL_MAXL', 10); // max number of chars for printed labels

define ('BRANCH_HEAD_OFFICE', 0);	// Branch Type for DB com_branch table
define ('BRANCH_OFFICE', 1);	// Branch Type for DB com_branch table

// Company address for order form
define ('COMPANY_NAME_LG', 'w w w . p o i n t H o t s p o t . c o m');
define ('COMPANY_ADDRESS_1', 'Dolphin Court');
define ('COMPANY_CITY', 'Port of Spain');
define ('COMPANY_COUNTRY', 'Trinidad, West Indies');
define ('COMPANY_PHONE', '(868) 633-9166');
define ('COMPANY_FAX', '(868) 633-9648');

define ('COMPANY_NAME', 'Ultra Consulting Network Ltd');

define ('PHS_COUNTRY', 'TT'); // default country code

// Database Table values
  // usergroup table groupname for 'suspended' -> rejected users
define('PHS_RADGRP_SUSPENDED', 'reject-group');
define('PHS_RAD_COAPORT', 3799); // RADIUS disconnect port
define('PHS_RADCLIENT', '/usr/bin/radclient'); // RADIUS disconnect port
define('PHS_RAD_DISCONNECT', 40); // RADIUS disconnect command

// client options 32 bit flags masks
define ('PHS_M_CLIENT_TIME24', 0x1);    // if set, display 24h instead of 12h 
define ('PHS_M_CLIENT_SUSPEND', 0x2);   // if set, user can be actively suspended via port 3799

// package type options 32 bit flags masks in package_type table
define ('PHS_M_PACKT_START', 0x1);    // if set, use user starttime
define ('PHS_M_PACKT_STOP', 0x2);    // if set, use user stoptime
define ('PHS_M_PACKT_TOTAL', 0x4);    // if set, use user accounting total = prepaid

define ('PHS_RADSERVER01', 'rad01.pointhotspot.com'); // first radius server
define ('PHS_RADSERVER02', 'rad02.pointhotspot.com'); // second radius server
define ('PHS_RAD_IDLE_TIMEOUT', 3600); // set in ./raddb/users
define ('PHS_RAD_ONLINE_TIMEOUT', 600); // seconds after user is guessed offline

  // client log (not a bitfield, but error numbers)
define ('PHS_LOGACT_LOGIN', 1);
define ('PHS_LOGACT_LOGOUT', 2);
define ('PHS_LOGACT_LOGINFAIL', 4);
define ('PHS_LOGACT_LOGINATT', 5); // login attempt for disabled account

  // user log for each change in the phs_user table, not a bit field
define ('PHS_LOGUS_INSERT', 1); // user insert
define ('PHS_LOGUS_UPDATE', 2); // user update
define ('PHS_LOGUS_IFAILED', 4); // user insert failed
define ('PHS_LOGUS_UFAILED', 8); // user update failed
define ('PHS_LOGUS_DFAILED', 16); // user delete failed
define ('PHS_LOGUS_CCINSERT', 17); // client contact insert
define ('PHS_LOGUS_CCUPDATE', 18); // client contact update
define ('PHS_LOGUS_CCIFAILED', 19); // client contact insert failed
define ('PHS_LOGUS_CCDELETE', 20); // client contact delete
define ('PHS_LOGUS_CCDFAILED', 21); // client contact delete failed
define ('PHS_LOGUS_DELETE', 128);

// Network Device Monitoring
define ('PHS_NDEV_TOUT_LIMIT', 1800); // set warning timeout level to 1800 seconds


define ('PHS_ORDER_ACTION_NEW', 0x1); // new order
define ('PHS_ORDER_ACTION_RENEW', 0x2); // renewal

define ('PHS_ORDER_STATUS_DEFAULT', 0); // no particular state
define ('PHS_ORDER_STATUS_PENDING', 0x1); // pending after order inserted and off to pp
define ('PHS_ORDER_STATUS_CONFIRMED', 0x2); // confirmed, not yet paid
define ('PHS_ORDER_STATUS_PAID', 0x4); // confirmed, and paid
define ('PHS_ORDER_STATUS_PP_PENDING', 0x8); // confirmed, but payment pending (eCheck)
define ('PHS_ORDER_STATUS_DECLINED', 0x16); // declined
define ('PHS_ORDER_STATUS_FAILED', 0x32); // failed

?>
