<?php

//
// Edit History:
//
//  Last $Author: munroe $
//  Last Modified: $Date: 2006/03/13 18:05:15 $
//
//  Dick Munroe (munroe@csworks.com) 28-Feb-2006
//      Initial version created
//

/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ 2006 by Dick Munroe, Cottage Software Works, Inc.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package dm.paypal
 * @example ./example.php
 *
 * This is derived from a paypal IPN class written originally by Herve Foucher
 * <Herve.Foucher@helio.org> and published through phpclasses.org under the GPL.
 * Herve appears to no longer support this package so I'm updating the support
 * to 1.6 and redesigning a bunch of the internal structure to allow a substantially
 * more object oriented approach to the whole problem.
 *
 * This object captures the IPN Advanced and Custom Information as given in table A.3 of the
 * Order Management Integration Guide.
 */

include_once('class.paypalIPNDataBase.php') ;

class paypalIPNWebsiteAndRefundInformation extends paypalIPNDataBase
{
    var $auth_id ;
    var $auth_exp ;
    var $auth_amount ;
    var $auth_status ;
    var $num_cart_items ;
    var $parent_txn_id ;
    var $payment_date ;
    var $payment_status ;
    var $payment_type ;
    var $pending_reason ;
    var $reason_code ;
    var $remaining_settle ;
    var $shipping ;
    var $transaction_entity ;
    
    /**
     * @desc Buyer information constructor
     * @param array $theSource [by reference] post data of the IPN.
     */
    
    function paypalIPNAdvancedAndCustomInformation(&$theSource)
    {
	$xxx = array('/^mc_gross_\d+$/',
		     '/^mc_handling_\d+$/',
		     '/^mc_shipping_\d+$/',
		     '/^mc_option_name\d+$/',
		     '/^mc_option_selection1_\d+$/',
		     '/^mc_option_selection2_\d+$/',
		     '/^shipping\d+$/',
		     '/^tax_\d+$/') ;
			 
	$this->m_IPNVariableNamePatterns = array_merge($this->m_IPNVariableNamePatterns, $xxx) ;
	
	$this->paypalIPNDataBase($theSource) ;
    }

    /**
     * @desc predicate for checking whether or not to process variable names via preg_match.
     * @return boolean true if variable name patterns are to be processed.
     * @access protected
     */
    
    function processVariableNamePatterns()
    {
	return !is_null($this->num_cart_items) ;
    }
}

?>
