<?php

//
// Edit History:
//
//  Last $Author: munroe $
//  Last Modified: $Date: 2006/03/13 18:05:15 $
//
//  Dick Munroe (munroe@csworks.com) 28-Feb-2006
//      Initial version created
//

/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ 2006 by Dick Munroe, Cottage Software Works, Inc.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package dm.paypal
 * @example ./example.php
 *
 * This is derived from a paypal IPN class written originally by Herve Foucher
 * <Herve.Foucher@helio.org> and published through phpclasses.org under the GPL.
 * Herve appears to no longer support this package so I'm updating the support
 * to 1.6 and redesigning a bunch of the internal structure to allow a substantially
 * more object oriented approach to the whole problem.
 *
 * This object captures the IPN Advanced and Custom Information as given in table A.3 of the
 * Order Management Integration Guide.
 */

include_once('class.paypalIPNDataBase.php') ;

class paypalIPNMassPayment extends paypalIPNDataBase
{
    var $payment_date ;
    var $payment_status ;
    var $reason_code ;
    
    /**
     * @desc Auctions information constructor
     * @param array $theSource [by reference] post data of the IPN.
     */
    
    function paypalIPNMassPayment(&$theSource)
    {
	$xxx = array('/^masspay_txn_id_\d+$/',
		     '/^mc_fee_\d+$/',
		     '/^mc_gross_\d+$/',
		     '/^payment_fee_\d+$/',
		     '/^payment_gross_\d+$/',
		     '/^receiver_email_\d+$/',
		     '/^status_\d+$/',
		     '/^unique_id_\d+$/') ;
		     
	$this->m_IPNVariableNamePatterns = array_merge($this->m_IPNVariableNamePatterns, $xxx) ;
	$this->paypalIPNDataBase($theSource) ;
    }
}
?>
