<?php

//
// Edit History:
//
//  Last $Author: munroe $
//  Last Modified: $Date: 2006/04/06 23:23:35 $
//
//  Dick Munroe (munroe@csworks.com) 28-Feb-2006
//      Initial version created
//

/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ 2006 by Dick Munroe, Cottage Software Works, Inc.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package dm.paypal
 * @example ./example.php
 *
 * This is derived from a paypal IPN class written originally by Herve Foucher
 * <Herve.Foucher@helio.org> and published through phpclasses.org under the GPL.
 * Herve appears to no longer support this package so I'm updating the support
 * to 1.6 and redesigning a bunch of the internal structure to allow a substantially
 * more object oriented approach to the whole problem.
 *
 * This object captures the IPN Advanced and Custom Information as given in table A.3 of the
 * Order Management Integration Guide.
 */

include_once('class.paypalIPNDataBase.php') ;

class paypalIPNCurrencyAndExchangeInformation extends paypalIPNDataBase
{
    var $exchange_rate ;
    var $mc_currency ;
    var $mc_fee ;
    var $mc_gross ;
    var $mc_handling ;
    var $mc_shipping ;
    var $payment_fee ;
    var $payment_gross ;
    var $settle_amount ;
    var $settle_currency ;

    /**
     * @desc Currency and Exchange information constructor
     * @param array $theSource [by reference] post data of the IPN.
     */

    function paypalIPNCurrencyAndExchangeInformation(&$theSource)
    {
	$this->paypalIPNDataBase($theSource) ;
    }
}
?>