<?php
/********************************************************************
*	Hotspot Authentication, Authorization and Accounting System
*
*	Module: 	phs2Pay-inc.php
*	Function:	Online Registration and Payment Module
*
*	2006-04-17 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/


ini_set('register_globals', '0');
require_once ('PEAR.php');
require_once ('DB.php');

/**********************************************
*	Class for all phs2Pay related functionality
*
***/
class phs2Pay {

	var $dbh = 0;
	var $rs = 0;
	var $table = '';

	/**
	* Constructor
	*/
	function phs2Pay ($param) {
//print_r($param);
/*
$db_type = 'mysql';
$db_user = 'phsrem';
$db_pass = 'caribphs';
$db_host = 'rad03.pointhotspot.com';
$db_name = 'poinths2';

$params = array(
	'dsn' => $db_type.'://'.$db_user.':'.$db_pass.'@'.$db_host.'/'.$db_name
);
*/

/*
	if ($dbh = DB::Connect($param['dsn'])) {
		print ('<br><br>DB: "'.$db_name.'" connected');
	} else {
		print ("<br>DB NOK ");
		exit;
	}
*/

	//if (!($this->dbh = DB::Connect($param['dsn']))) {
		if (DB::isError($this->dbh = DB::Connect($param['dsn']))) {
			global $globalref;
			$globalref = &$this;

			$this->db_errmsg = $this->dbh->getMessage();
			$this->retval = $this->db_errmsg;
//print('Error opening DB' . $this->db_errmsg);
		} else {
//print('DB connected');
            //$err = $this->dbh->autoCommit(False); // switch off autocommit
            //if (PEAR::isError($err) && $err->getCode() == DB_ERROR_NOT_CAPABLE) {
            //    die("whoops, Database has no transaction support!");
            //}
			$this->table = $param['table'];
			$this->param = $param;
			$this->retval = Null;
		}
	}






/********************************************************************
*	validateUserInput
*	input:	rowin
*	return:	Null on success, else errmsg
*********************************************************************/

  function validateUserInput($rowin=Null) {
    $_errmsg = Null;
    if (!isset($rowin['update'])) { // update does not need username to be set
      if (empty($rowin['uuname'])) {
        $_errmsg = 'Login Id missing';
      } elseif (strlen($rowin['uuname']) < PHS_LEN_USER) {
        $_errmsg = 'Login Id too short! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (strlen($rowin['uuname']) > PHS_LEN_USER_MAX) {
        $_errmsg = 'Login Id too long! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (ereg('[^a-zA-Z0-9_\-\.]{1,}\ [a-zA-Z0-9_\-\.]{1,}', $rowin['uuname'])) {
        $_errmsg = 'Only use a-z 0-9 _.- and space for the Login Id';
      }
    } 
    if (is_null($_errmsg)) { 
      if (isset($rowin['user_value'])) { // update does not need password to be set
        if (empty($rowin['user_value'])) {
          $_errmsg = 'Password missing';
        } elseif (strlen($rowin['user_value']) < PHS_LEN_PW) {
          $_errmsg = 'Password too short! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (strlen($rowin['user_value']) > PHS_LEN_PW_MAX) {
          $_errmsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (ereg('[^a-zA-Z0-9_\-\.@\!\*]{1,}', $rowin['user_value'])) {
          $_errmsg = 'Only use a-z 0-9 _.-@!* and no spaces for the password';
        }
      }
    }
    if (is_null($_errmsg)) {
      if (empty($rowin['user_location'])) {
        $_errmsg = $rowin['client_address_location_str'] . ' missing';
      } elseif (strlen($rowin['user_location']) < PHS_LEN_LOCATION) {
        $_errmsg = $rowin['client_address_location_str'] . ' too short! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      } elseif (strlen($rowin['user_location']) > PHS_LEN_LOCATION_MAX) {
        $_errmsg = $rowin['client_address_location_str'] . ' too long! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      }
    }
      //print('err:'.$_errmsg);exit;

    return($_errmsg);

  }



/********************************************************************
*	Insert new User
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
*********************************************************************/

  function insertUser($rowin=Null) {
    $_return = Array(0, Null);
    $this->db_errmsg = 'empty user input row';
    $colnames = '';	
    $colvalues = '';
    $radcolnames = '';	
    $radcolvalues = '';

    //print_r($rowin); exit;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // if ($key == 'order_id_pk') continue; // skip order id
        // sort all keys and values from ONE input row to multiple
        // database rows
        switch ($key) {
        case 'rad_usergroup_groupname';
        case 'client_address_location_str';
          continue 2; // continue foreach
        case 'user_stoptime';
          if (!empty($value)) {
            $colnames .= $key.',';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          }
          continue 2; // continue foreach
        case 'usttm';
          $colnames .= $key.',';
          $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          continue 2; // continue foreach
        }

        $colnames .= $key.',';
        // note: This technique requires all non-strings have to end with '_id'
        if (eregi('_id', $key) || $key == 'user_status') { // id is always NO string value, _alt_ for alteration values
          $colvalues .= (int)$value . ','; // not quoted 
        } else {
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
        }
      }
      $colnames .= 'user_ndate';
      $colvalues .= ' NOW() ,';
      $colnames .= ',user_ccid';
      $colvalues .= Phs_Ccid;
      $colnames .= ',user_attribute';
      $colvalues .= ",'User-Password'"; // RADIUS attribute
  
      $query = 'INSERT INTO ' . PHS_DBTABLE_USER . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      $colnames = 'usergroup_username';
      $colvalues = $this->dbh->quote($rowin['uuname']) . ','; // all quoted strings
      $colnames .= ',usergroup_groupname';
      $colvalues .= $this->dbh->quote($rowin['rad_usergroup_groupname']); // all quoted strings
      $colnames .= ',usergroup_ndate';
      $colvalues .= ', NOW() ';

        // insert into RADIUS usergroup table
      $radquery = 'INSERT INTO ' . PHS_DBTABLE_USERGROUP . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>insertUser:</b>>");
        print($query);
        print($radquery);
        print("<<b>END-DEBUG</b>\n");
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE
 
      if (!DB::isError($rs = $this->dbh->query($query))) {
        
          // this is HACK and bypasses PEAR abstraction layer!
        $id = mysql_insert_id($this->dbh->connection);
        
        $this->logUser($rowin, PHS_LOGUS_INSERT);
        //print('Insert user OK');
          // insert into RADIUS usergroup tbale
        if (!DB::isError($rs = $this->dbh->query($radquery))) {
          //print('Insert user OK');
        } else {
          $this->db_errmsg = $rs->getMessage();
          $trans_error = True;
        }
      } else {
        $this->logUser($rowin, PHS_LOGUS_IFAILED);
        $this->db_errmsg = $rs->getMessage();
        //print('Insert user NOT OK: '. $this->db_errmsg);
          // give some nicer error message
        if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
          $this->db_errmsg = 'Login Id already exists';
        }
        $trans_error = True;
      }

          // END TRANSACTION HERE
          
      //exit;
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->commit();
            //$this->dbh->rollback();
        //}
        $_return[0] = $id; // insert ID
        $_return[1] = Null;
        //return(Null);
      } else {
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->rollback();
        //}
        $_return[0] = 0; // insert ID does not exist
        $_return[1] = $this->db_errmsg;
        //return($this->db_errmsg);
      }
    }
    return($_return);
  }



  /********************************************************************
*	Log all changes to user entries
* 20060216gr
* insert: raw input row, action (insert, update, delete, etc. refer to PHS_LOGUS_...)
*	return:	
*********************************************************************/
  function logUser($rowin=Null, $action=0) {
    $colnames = '';
    $colvalues = '';

    if (!is_null($rowin)) {

      //print_r($rowin); exit;

      foreach ($rowin as $key => $value) {
          // filter only wanted keys and values!
        switch ($key) {
        case 'uuname':
          $colnames .= 'userlog_uname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_value':
          $colnames .= 'userlog_value, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_location':
          $colnames .= 'userlog_location, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_firstname':
          $colnames .= 'userlog_firstname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_lastname':
          $colnames .= 'userlog_lastname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_email':
          $colnames .= 'userlog_email, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_phone':
          $colnames .= 'userlog_phone, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_address':
          $colnames .= 'userlog_address, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_payment':
          $colnames .= 'userlog_payment, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_notes':
          $colnames .= 'userlog_notes, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_status':
          $colnames .= 'userlog_status, ';
          $colvalues .= $value . ',';
          break;
        case 'user_client_id':
          $colnames .= 'userlog_client_id, '; //client address/location
          $colvalues .= $value . ',';
          break;
        case 'user_client_package_id':
          $colnames .= 'userlog_client_package_id, ';
          $colvalues .= $value . ',';
          break;
        case 'user_stoptime';
          if (!empty($value)) {
            $colnames .= 'userlog_stoptime, ';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          }// else {
            //$colvalues .= 0 . ',';
          //}
          break;
        case 'usttm';
          if (!empty($value)) {
            $colnames .= 'userlog_starttime, ';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          } //else {
            //$colvalues .= 0 . ',';
          //}
          break;
        default:
          continue 2; // skip all other keys and continue foreach
        }
      }
      $colnames .= 'userlog_action, ';
      $colvalues .= $action . ',';
      $colnames .= 'userlog_ccid';
      $colvalues .= Phs_Ccid;
      //$colnames .= 'userlog_mdate';
      //$colvalues .= 'NOW()';
      
      $_query = 'INSERT INTO ' . PHS_DBTABLE_USERLOG . ' (' . $colnames . ') VALUES (' . $colvalues . ')';
      //print($_query);
      if (DB::isError($_rs = $this->dbh->Query($_query))) {
        // insert NOK
        //print($_rs->getMessage());
        //exit;
      }
    }
  }
  
}
?>
