<?php
/********************************************************************
*	Hotspot Management System
*
*	Module: 	user-inc.php
*	Function:	user & client functionality
*
*	2005-09-04 Gunther Richter - Ultra Consulting Network Limited
*	2008-02-19 DB Failover added
*
*********************************************************************/

ini_set('register_globals', '0');
require_once ('PEAR.php');
require_once ('DB.php');

	// User permissions profile for accessing certain functionality/pages
define ('PHS_PERM_DISABLED', 0);	// no access
define ('PHS_PERM_SUPADMIN', 1);	// super administrator - full access
define ('PHS_PERM_ADMIN', 2);	// administrator - client admin access
define ('PHS_PERM_PUSER', 4);	// Power user
define ('PHS_PERM_USER', 8);	// normal user



  // input fields for User Form
$PhsUserInputArray = array (
    'Username' => 'Username',
    'Password' => 'Password',
    'Location' => 'Location',
    'ServicePlanSelect' => 'ServicePlanSelect',
    'BillingAmount' => 'BillingAmount',
    'BillingCycle' => 'BillingCycle',
    'BillingNotes' => 'BillingNotes',
    'FirstName' => 'FirstName',
    'LastName' => 'LastName',
    'Email' => 'Email',
    'Phone' => 'Phone',
    'Address' => 'Address',
    'Payment' => 'Payment',
    'StatusSelect' => 'StatusSelect',
    'Notesfield' => 'Notesfield'
);

/******************************************************************************
    2003-05-14 gr
    The current implementation of PHS uses the database abstraction layer PEAR,
    which will be superseded by MDB (no MS-SQL support yet).
    There is a vendor specific SQL statement implemented in PHS: CONVERT (MS-SQL only)

    Here is a list how this function (CONVERT) is used in different DBs:

    Microsoft SQL Server:
        SELECT CONVERT(VARCHAR(11), GETDATE(), 102)
        GO
    MySQL:
        SELECT DATE_FORMAT( "2001-11-25", "%M %e, %Y");
    Oracle 
        SELECT TO_CHAR(SYSDATE,'dd-Mon-yyyy hh:mi:ss PM') 
        FROM dual;
    PostgreSQL 
        SELECT TO_CHAR (timestamp(CURRENT_DATE), 'dd-Mon-yyyy hh:mi:ss PM');
******************************************************************************/


/**********************************************
*	Class for all user related functionality
*
***/
class ClientAuth {

	var $dbh = 0;
	var $rs = 0;
	var $table = '';

	/**
	* Constructor
	*/
	function ClientAuth ($param) {

      // DB connect with failover to backup DB - 20080219gr
		if (DB::isError($this->dbh = DB::Connect($param['dsn']))) {
      if (DB::isError($this->dbh = DB::Connect($param['dsn2']))) {
        global $globalref;
        $globalref = &$this;

        $this->db_errmsg = $this->dbh->getMessage();
        $this->retval = $this->db_errmsg;
      } else {
        $this->table = $param['table'];
        $this->param = $param;
        $this->retval = Null;
      }
		} else {
            //$err = $this->dbh->autoCommit(False); // switch off autocommit
            //if (PEAR::isError($err) && $err->getCode() == DB_ERROR_NOT_CAPABLE) {
            //    die("whoops, Database has no transaction support!");
            //}
			$this->table = $param['table'];
			$this->param = $param;
			$this->retval = Null;
		}
	}

	function getPerm($username) {
      //print_r($this->table);
      //print_r($this->param);
		//$rs = $this->dbQuery('userauth_username, userauth_permissions', 'userauth_username='.$this->dbh->quote($username));
		//$rs = $this->dbQuery('client_username, client_permissions', 'client_username='.$this->dbh->quote($username));
		$rs = $this->dbQuery($this->param['usernamecol'] . ',' . $this->param['permissionscol'], $this->param['usernamecol'] . '='.$this->dbh->quote($username));
        //print('MOIN'); exit;
		//$perm = $this->dbFetch($rs, 'client_permissions');
		$perm = $this->dbFetch($rs, $this->param['permissionscol']);
		return($perm);
	}

	function dbQuery($fields, $condition) {
		$query = 'SELECT '.$fields.' FROM '.$this->table.' WHERE '.$condition;
		//print("Q: $query ");
		$rs = $this->dbh->query($query);
		return($rs);
	}

	function dbFetch($rs, $field) {
		
		if (!DB::isError($row = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
				return($row[$field]);
		} else {
			//print("Not Found");
			//print($rs->getMessage());
		}

		return(0);
	}

	function getCcid($username) {
		//print("Tab: $this->table ");
		if (!DB::isError($rs = $this->dbQuery('client_contact_id', 'client_contact_username=' . $this->dbh->quote($username)))) {
			$ccid = $this->dbFetch($rs, 'client_contact_id');
			$retccid = $ccid;	// success
            //print('SUCCSESS('.$cid.')');
		} else {
			$retccid = 0;	// failed
		}
		return($retccid);
	}
 
/*********************************************
*	Get All Internet access controlled Users
*	20050914gr
*	input:  nasid (router's ID)
*           from: starting row
*           pagelimit: max rows per page
*	Return: result array or Null
*   Result array[0] contains numrows information for the Pager
* 
* user_status: (bit flags and numbers)
*   0 : PHS_ST_INACTIVE     : in DB
*   1 : PHS_ST_ACTIVE       : not in DB
*   2 : PHS_ST_SUSPENDED    : in DB
*   4 : PHS_ST_IDLE_TIMEOUT : not in DB
*   8 : PHS_ST_EXPIRED      : not in DB
*   16: PHS_ST_PENDING      : not in DB
*   32: PHS_ST_READY        : not in DB
*   64: PHS_ST_PREPAID      : in DB
*   654321: PHS_ST_LOGINREADY        : not in DB
*   negative values are remaining online seconds
*   status not in DB is set by processing the db result
*   
**********************************************/

  function getAllUsers($nasid=0, $type=0, $searchstr='', $sortorder='', $from=0, $pagelimit=10) {
    $_nrows = 0;
    $_queryExt = '';
    $_tables = '';
    $_condition = '';
    $_retarray = array(0 => array('numrows' => 0));

    $_query1 = "SELECT u.user_id,
                u.user_lastname,
                u.user_firstname, 
                pt.package_type_name, 
                u.uuname, 
                u.user_location, 
                u.usttm,
                u.user_stoptime,
                u.ulsttm,
                CONVERT_TZ(usttm, 'GMT', '" . PHS_TZONE . "') as usttm_tz,
                CONVERT_TZ(user_stoptime, 'GMT', '" . PHS_TZONE . "') as user_stoptime_tz,
                CONVERT_TZ(ulsttm, 'GMT', '" . PHS_TZONE . "') as ulsttm_tz,
                CONVERT_TZ(user_mdate, 'GMT', '" . PHS_TZONE . "') as user_mdate_tz,
                CONVERT_TZ(user_ndate, 'GMT', '" . PHS_TZONE . "') as user_ndate_tz,
                pt.package_type_short,
                pt.package_type_interval,
                pt.package_type_options";

      // switch by prepaid card type
    switch($type) {
    case PPCARD_TYPE_INUSE:
      $_query1 .= ', SUM(r.radacct_sessiontime) as time_total, u.user_status, 
                (SELECT IF(ra.radacct_stoptime = 0 AND DATE_SUB(NOW(), INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . " SECOND) <= ra.radacct_mdate, 'Online', CONVERT_TZ(IF(ra.radacct_stoptime=0, ra.radacct_mdate, ra.radacct_stoptime), 'GMT', '" . PHS_TZONE . "')) FROM " . PHS_DBTABLE_RADACCT . " AS ra WHERE u.uuname=ra.radacct_username ORDER BY ra.radacct_mdate DESC LIMIT 1) AS radacct_stoptime";
      $_tables = ', ' . PHS_DBTABLE_RADACCT . ' AS r ';
      //$_condition = ' AND u.user_status & ' . PHS_ST_PREPAID . ' AND u.ulsttm <> 0 AND u.uuname=r.radacct_username ';
      $_condition = ' AND u.user_status & ' . PHS_ST_PREPAID . ' AND u.ulsttm <> 0 AND u.uuname=r.radacct_username AND (u.user_stoptime = \'0000-00-00 00:00:00\' OR u.user_stoptime > NOW()) ';
      //$_queryExt = ' GROUP BY u.uuname HAVING SUM(r.radacct_sessiontime) < pt.package_type_interval AND (u.user_stoptime > \'0000-00-00 00:00:00\') ';
      //$_queryExt = ' GROUP BY u.uuname HAVING SUM(r.radacct_sessiontime) < pt.package_type_interval AND (u.user_stoptime == \'0000-00-00 00:00:00\' OR u.user_stoptime > NOW()) ';
      $_queryExt = ' GROUP BY u.uuname HAVING SUM(r.radacct_sessiontime) < pt.package_type_interval ';
      break;

    case PPCARD_TYPE_UNUSED:
      //$_condition = ' AND u.user_status & ' . PHS_ST_PREPAID . ' AND u.ulsttm = 0 AND u.uuname=r.radacct_username ';
      $_condition = ' AND u.user_status & ' . PHS_ST_PREPAID . ' AND u.ulsttm = 0';
      break;
      
    case PPCARD_TYPE_EXPIRED: // expired cards only
      $_query1 .= ', SUM(r.radacct_sessiontime) as time_total, u.user_status ';
      $_query1 .= ', IF(SUM(radacct_sessiontime) > pt.package_type_interval OR (user_stoptime > \'0000-00-00 00:00:00\' AND user_stoptime <= now()), ' . PHS_ST_EXPIRED . ', 5000) as user_stat,
                (SELECT IF(ra.radacct_stoptime = 0 AND DATE_SUB(NOW(), INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . " SECOND) <= ra.radacct_mdate, 'Online', CONVERT_TZ(IF(ra.radacct_stoptime=0, ra.radacct_mdate, ra.radacct_stoptime), 'GMT', '" . PHS_TZONE . "')) FROM " . PHS_DBTABLE_RADACCT . " AS ra WHERE u.uuname=ra.radacct_username ORDER BY ra.radacct_mdate DESC LIMIT 1) AS radacct_stoptime";

      
      //          IF((r.radacct_stoptime=0 AND DATE_SUB(NOW(), INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . " SECOND) <= r.radacct_mdate), 'Online', CONVERT_TZ(r.radacct_mdate, 'GMT', '" . PHS_TZONE . "')) as radacct_stoptime";
      $_tables = ', ' . PHS_DBTABLE_RADACCT . ' AS r ';
      $_condition = ' AND u.user_status & ' . PHS_ST_PREPAID . ' AND u.ulsttm <> 0 AND u.uuname=r.radacct_username ';
      //$_queryExt = ' GROUP BY u.uuname HAVING SUM(r.radacct_sessiontime) >= pt.package_type_interval ';
      $_queryExt = ' GROUP BY u.uuname HAVING SUM(r.radacct_sessiontime) >= pt.package_type_interval OR (user_stoptime > \'0000-00-00 00:00:00\' AND user_stoptime <= NOW()) ';
      break;

    case PPCARD_TYPE_ALL:
      $_query1 .= ', u.user_status ';
      $_condition = ' AND u.user_status & ' . PHS_ST_PREPAID;
      break;
      //
      //          IF(DATE_ADD(u.ulsttm, INTERVAL pt.package_type_interval SECOND) > NOW(),
      //  TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL pt.package_type_interval SECOND), NOW())), ' . PHS_ST_EXPIRED . ')

    default: // handle start and start/stop time packages
      $_condition = ' AND u.user_status=u.user_status & ~' . PHS_ST_PREPAID;
      $_query1 .= ', CASE pt.package_type_options 
                      WHEN ' . PHS_M_PACKT_START . ' THEN
            IF(u.usttm > NOW(), ' . PHS_ST_PENDING . ',
              IF(u.user_status = ' . PHS_ST_SUSPENDED . ', ' . PHS_ST_SUSPENDED . ',    IF(u.ulsttm > 0, IF(NOW() > u.usttm,' .
        " IF(
CASE SUBSTRING_INDEX(pt.package_type_interval, ' ', -1)
WHEN 'SECOND' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) SECOND)
WHEN 'MINUTE' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) MINUTE)
WHEN 'HOUR' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) HOUR)
WHEN 'DAY' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) DAY)
WHEN 'WEEK' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) WEEK)
WHEN 'MONTH' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) MONTH)
WHEN 'YEAR' THEN
DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) YEAR)
END > NOW(), 
CASE SUBSTRING_INDEX(pt.package_type_interval, ' ', -1)
WHEN 'SECOND' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) SECOND), NOW()))
WHEN 'MINUTE' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) MINUTE), NOW()))
WHEN 'HOUR' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) HOUR), NOW()))
WHEN 'DAY' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) DAY), NOW()))
WHEN 'WEEK' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) WEEK), NOW()))
WHEN 'MONTH' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) MONTH), NOW()))
WHEN 'YEAR' THEN
-1 * TIME_TO_SEC(TIMEDIFF(DATE_ADD(u.ulsttm, INTERVAL SUBSTRING_INDEX(pt.package_type_interval, ' ', 1) YEAR), NOW()))
END, " . PHS_ST_EXPIRED . ' )
        
         , ' . PHS_ST_PENDING . '), ' . PHS_ST_LOGINREADY . '))) 
                      WHEN ' . (PHS_M_PACKT_START|PHS_M_PACKT_STOP) . ' THEN 
            IF(u.usttm > NOW(), ' . PHS_ST_PENDING . ',
              IF(u.user_status = ' . PHS_ST_SUSPENDED . ', ' . PHS_ST_SUSPENDED . ',    
                IF(NOW() <= u.user_stoptime, IF(u.ulsttm > 0, -1 * TIME_TO_SEC(TIMEDIFF(u.user_stoptime, IF(NOW() >= u.usttm, now(), DATE_SUB(u.user_stoptime, INTERVAL 1 SECOND)))), ' . PHS_ST_LOGINREADY . '), ' . PHS_ST_EXPIRED . ')))
                      END AS user_status ';
      break;
    }
 
    $_query1 .= ' 
              FROM ' . PHS_DBTABLE_USER . ' AS u, 
                ' . PHS_DBTABLE_CLIENT_PACKAGE . ' AS cp, 
                ' . PHS_DBTABLE_PACKAGE_TYPE . ' AS pt ' .
                $_tables . '
              WHERE 
                u.user_status=u.user_status & ~' . PHS_ST_DEL . ($nasid > 0 ? ' 
                AND u.user_nas_id=' . $nasid : '') . " 
                AND (u.user_attribute='User-Password' 
                OR u.user_attribute='Cleartext-Password')
                AND u.user_client_package_id=cp.client_package_id " .
                $_condition . '
                AND cp.client_package_type_id=pt.package_type_id ' . 
                (!empty($searchstr) ? " 
                  AND (u.uuname like '%" . $searchstr . "%' 
                        OR u.user_lastname like '%" . $searchstr . "%' 
                        OR u.user_firstname like '%" . $searchstr . "%'
                        OR pt.package_type_short like '%" . $searchstr . "%'
                      
                      )" : '') . 
                $_queryExt . '
              ORDER BY ' . (!empty($sortorder) ? $sortorder : 'u.uuname');

    if ($GLOBALS['Phs_Debug'] > 30) {
      print("\n<br><b>getAllUsers:</b>>");
      print($_query1);
      print('<<b>END-DEBUG</b> ');
    }
    //print($_query1);
    //print($_query1); exit;
    if (!DB::isError($_rs = $this->dbh->limitQuery($_query1, $from, $pagelimit))) {
      $_ix=1; // start at row 1, 0 is reserved for numrows
      while ($_row = $_rs->fetchRow(DB_FETCHMODE_ASSOC)) {

          // assign timezone adjusted time now
        $_row['usttm'] = $_row['usttm_tz'];
        $_row['user_stoptime'] = $_row['user_stoptime_tz'];
        $_row['ulsttm'] = $_row['ulsttm_tz'];
        $_retarray[$_ix++] = $_row;

      } // end-while
        // get total number of rows
      if (!DB::isError($_rs = $this->dbh->query($_query1))) {
        $_nrows = $_rs->numRows();
      }
    }
    $_retarray[0] = array('numrows' => $_nrows); 
    //print_r($_retarray); exit;
    return ($_retarray);
  } 

/*********************************************
*	Get Internet Access User
*	2005-10 gr
*	input: userid
*	Return: resultrow or Null
**********************************************/

  function getUser($userid=0) {
    $resultrow = Null;

    //$query = 'SELECT * FROM ' . PHS_DBTABLE_USER . ', ' . PHS_DBTABLE_PACKAGE_TYPE . ' WHERE user_id=' . $userid . ' AND user_client_package_id=package_type_id';
/*
    $_query = "SELECT user_id,
                user_nas_id,
                user_ccid,
                user_status,
                user_client_id,
                user_client_package_id,
                user_mac_group,
                user_location, 
                user_lastname,
                user_firstname, 
                uuname, 
                user_value,
                user_phone, 
                user_email, 
                user_address, 
                user_payment, 
                user_notes, 
                CONVERT_TZ(usttm, 'GMT', '" . PHS_TZONE . "') as usttm,
                CONVERT_TZ(user_stoptime, 'GMT', '" . PHS_TZONE . "') as user_stoptime,
                CONVERT_TZ(ulsttm, 'GMT', '" . PHS_TZONE . "') as ulsttm,
                pt.*
                FROM " . PHS_DBTABLE_USER . ', ' . 
                PHS_DBTABLE_PACKAGE_TYPE . ' as pt, ' .
                PHS_DBTABLE_CLIENT_PACKAGE . '
                WHERE user_id=' . $userid . 
                (PHS_CLIENT_ID > 0 ? ' AND user_client_id = ' . PHS_CLIENT_ID . ' ' : '') . ' 
                AND user_client_package_id=client_package_id
                AND client_package_type_id=pt.package_type_id';
*/
    $_query = "SELECT user_id,
                user_nas_id,
                user_ccid,
                user_status,
                user_client_id,
                user_client_package_id,
                user_mac_group,
                user_location, 
                user_lastname,
                user_firstname, 
                uuname, 
                user_value,
                user_phone, 
                user_email, 
                user_address, 
                user_payment, 
                user_notes, 
                CONVERT_TZ(usttm, 'GMT', '" . PHS_TZONE . "') as usttm,
                CONVERT_TZ(user_stoptime, 'GMT', '" . PHS_TZONE . "') as user_stoptime,
                CONVERT_TZ(ulsttm, 'GMT', '" . PHS_TZONE . "') as ulsttm,
                pt.*, currency_disp
                FROM " . PHS_DBTABLE_USER . '
                INNER JOIN ' . PHS_DBTABLE_CLIENT_PACKAGE . '  ON user_client_package_id=client_package_id AND user_id=' . $userid . (PHS_CLIENT_ID > 0 ? ' AND user_client_id = ' . PHS_CLIENT_ID . ' ' : '') . '
                INNER JOIN ' . PHS_DBTABLE_PACKAGE_TYPE . ' AS pt ON client_package_type_id=pt.package_type_id

                INNER JOIN ' . PHS_DBTABLE_PACKAGE_COST . ' ON client_package_id=package_cost_client_package_id
                INNER JOIN ' . PHS_DBTABLE_CURRENCY . ' ON package_cost_currency_id=currency_id';


    if ($GLOBALS['Phs_Debug'] > 30) {
      print("\n<br><b>getUsers:</b>>");
      print($_query);
      print('<<b>END-DEBUG</b> ');
    }      

    if (!DB::isError($rs = $this->dbh->query($_query))) {
      $ix=0;
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $resultrow = $row;
        $ix++;
      }
      if ($ix > 1) { // error fetching user, too many results
            // could actually never happen since uid is unique .. but u neva no
        $resultrow = Null;
      }
    }
    return ($resultrow);
  }

/*********************************************
*	Get NAS Info
*	2005-09-18 gr
*	input:  clientid 
*	Return: resultrow or Null
*   Note: the result can have more than one row as it is allowed to
*   have more devices with different NAS-Id per location
**********************************************/

  function getNasInfo($clientid=0) {
    $_resultrow = Null;

    if ($clientid > 0) {
      $query = 'SELECT nas.* FROM ' . PHS_DBTABLE_CLIENT_ADDRESS . ', ' . PHS_DBTABLE_NAS . ' as nas WHERE client_address_client_id=' . $clientid . ' AND client_address_id=nas.nas_client_address_id';
      //print($query);

      if (!DB::isError($rs = $this->dbh->query($query))) {
        $ix=0;
        while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
          $_resultrow[] = $row;
          $ix++;
        }
          //print('ix'.$ix);
      }
    }
    //print_r($_resultrow); print('exit'); exit;
    return ($_resultrow);
  }

/*********************************************
*	Get Client Info
*	2005-09-18 gr
*	input:  client_address_id, username or client_contact_id
*	Return: resultrow or Null
**********************************************/

  function getClientInfo($clientaddressid=0, $username='', $clientcontactid=0) {
    $_resultrow = Null;

    $_query = 'SELECT * FROM ' . PHS_DBTABLE_CLIENT . ', ' . PHS_DBTABLE_CLIENT_CONTACT . ', ' . PHS_DBTABLE_CLIENT_ADDRESS . ' WHERE ';
    
    if ($clientaddressid == 0 && !empty($username) && $clientcontactid == 0) {
      //$_query .= (defined('PHS_ADMIN') ? '' : "client_contact_username='" . $username . "' AND");
      $_query .= "client_contact_username='" . $username . "' AND";
    } elseif (defined('PHS_ADMIN') > 0 && $clientcontactid > 0) {
      $_query .= 'client_contact_id=' . $clientcontactid . ' AND';
    } elseif ($clientaddressid > 0 && $clientcontactid > 0) {
      $_query .= 'client_contact_address_id=' . $clientaddressid . ' AND client_contact_id=' . $clientcontactid . ' AND';
    } else {
      $_query .=  'client_address_id=' . $clientaddressid . ' AND';
    }
    $_query .= ' client_contact_status=client_contact_status & ~' . PHS_ST_DEL;
    $_query .= ' AND client_contact_client_id=client_id AND client_contact_client_id=client_address_client_id';
    //$_query .= (PHS_ADMIN ? '' : ' AND client_contact_client_id=client_id AND client_contact_client_id=client_address_client_id');
    //print($_query);

    if (!DB::isError($rs = $this->dbh->query($_query))) {
      $ix=0;
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_resultrow = $row;
        $ix++;
      }
    }
    //print_r($_resultrow); exit;
    return ($_resultrow);
  }
  
/*********************************************
*	Get Service Plans Info
*	2005-09-18 gr
*	input:  clientid,  package_type_options (start, Start/Stop, Prepaid)
*	Return: resultrow or Null
**********************************************/

  //function getServicePlans($clientid=0, $packageTypeOptions=0) {
  function getServicePlans($clientid=0, $packageTypeOptions=0, $searchstr='', $sortorder='', $from=0, $pagelimit=50) {
    $_retarray = array(0 => array('numrows' => 0));
    $_nrows = 0;

    $_resultrow = Null;

    if ($clientid > 0) {
      $_query = 'SELECT client_package_id, client_package_sortorder, package_type_id, package_type_options, package_type_name, package_type_interval, package_type_short, package_type_radgroupext, package_type_description, package_cost_currency_id, package_cost_rate, currency_disp 
        FROM ' . PHS_DBTABLE_CLIENT_PACKAGE . ' 
        INNER JOIN ' . PHS_DBTABLE_PACKAGE_TYPE . ' ON client_package_type_id=package_type_id ' . ($packageTypeOptions == PHS_M_PACKT_ALL ? 'AND' : 'AND package_type_options=' . ($packageTypeOptions == PHS_M_PACKT_TOTAL ? PHS_M_PACKT_TOTAL : 'package_type_options & ~' . PHS_M_PACKT_TOTAL) . ' AND client_package_status = client_package_status & ~'. PHS_ST_ACTIVE . ' AND ') . ' client_package_client_id=' . $clientid . '
        INNER JOIN ' . PHS_DBTABLE_PACKAGE_COST . ' ON client_package_id=package_cost_client_package_id
        INNER JOIN ' . PHS_DBTABLE_CURRENCY . ' ON package_cost_currency_id=currency_id 
        ORDER BY client_package_sortorder';
        
//        INNER JOIN ' . PHS_DBTABLE_PACKAGE_TYPE . ' ON client_package_type_id=package_type_id ' . ($packageTypeOptions == PHS_M_PACKT_ALL ? 'AND' : 'AND package_type_options=' . ($packageTypeOptions == PHS_M_PACKT_TOTAL ? PHS_M_PACKT_TOTAL : 'package_type_options & ~' . PHS_M_PACKT_TOTAL) . ' AND ') . ' client_package_client_id=' . $clientid . '
      //print($_query);

    if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>getServicePlans:</b>>");
        print($_query);
        print('<<b>END-DEBUG</b> ');
    }
    if (!DB::isError($_rs = $this->dbh->limitQuery($_query, $from, $pagelimit))) {
    //  if (!DB::isError($_rs = $this->dbh->query($_query))) {
        $ix=1; // leave space for totalnum in [0]
        while ($row = $_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
          //$_resultrow[] = $row;
          $_retarray[$ix] = $row;
          $ix++;
          //print_r($row);
        }

      }
      //print_r($_resultrow); exit;
        // get total number of rows
      if (!DB::isError($_rs = $this->dbh->query($_query))) {
        $_nrows = $_rs->numRows();
      }
    }
    //return ($_resultrow);
    $_retarray[0] = array('numrows' => $_nrows); 
    return ($_retarray);
  }

/*********************************************
*	Get Service Plans Info
*	2005-09-18 gr
*	input:  packageid
*	Return: resultrow or Null
**********************************************/

  function getServicePlanInfo($packageid=0) {
    $_resultrow = Null;

    if ($packageid > 0) {
      $_query = 'SELECT client_package_id, client_package_description, client_package_sortorder, pt.package_type_id, pt.package_type_name, pt.package_type_short, pt.package_type_radgroupext, pt.package_type_description, pt.package_type_options, pc.* FROM ' . PHS_DBTABLE_CLIENT_PACKAGE . ', ' . PHS_DBTABLE_PACKAGE_TYPE . ' as pt, ' . PHS_DBTABLE_PACKAGE_COST . ' as pc WHERE client_package_id=' . $packageid . ' AND client_package_type_id=pt.package_type_id AND client_package_id=package_cost_client_package_id';
      //print($_query);

      if (!DB::isError($rs = $this->dbh->query($_query))) {
        $ix=0;
        while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
          $_resultrow = $row;
          $ix++;
        }
      }
      if ($ix > 1) {
        $_resultrow = Null;
      }
      //print_r($_resultrow); exit;
    }
    return ($_resultrow);
  }

/*********************************************
*	Get Currencies
*	2008-10-31 gr
*	input:  
*	Return: resultArray or Null
**********************************************/

  function getCurrency() {
    $_resultArray = Null;
   $_query = 'SELECT * FROM ' . PHS_DBTABLE_CURRENCY . ' ORDER BY currency_disp';
   if (!DB::isError($rs = $this->dbh->query($_query))) {
     while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
       $_resultArray[] = $row;
     }
    }
    return ($_resultArray);
  }



/********************************************************************
*	Insert new User
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
*	20070516gr - Add billingrow insert
*********************************************************************/

  function insertUser($rowin=Null, $billingrow=Null) {
    global $phs_ldate, $phs_ccid;
    $this->db_errmsg = 'empty user input row';
    $colnames = '';	
    $colvalues = '';
    $radcolnames = '';	
    $radcolvalues = '';
    $billinglog_id =  0;

    //print_r($rowin); exit;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // if ($key == 'order_id_pk') continue; // skip order id
        // sort all keys and values from ONE input row to multiple
        // database rows
        switch ($key) {
        case 'rad_usergroup_groupname':
        case 'client_address_location_str':
          continue 2; // continue foreach
        case 'user_stoptime':
          if (!empty($value)) {
            $colnames .= $key.',';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          }
          continue 2; // continue foreach
        case 'usttm':
          $colnames .= $key.',';
          $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          continue 2; // continue foreach
        }

        $colnames .= $key.',';
        // note: This technique requires all non-strings have to end with '_id'
        if (eregi('_id', $key) || $key == 'user_status') { // id is always NO string value, _alt_ for alteration values
          $colvalues .= (int)$value . ','; // not quoted 
        } else {
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
        }
      }
      $colnames .= 'user_ndate';
      $colvalues .= ' NOW() ,';
      $colnames .= ',user_ccid';
      $colvalues .= $phs_ccid;
      $colnames .= ',user_attribute';
      //$colvalues .= ",'User-Password'"; // RADIUS attribute
      $colvalues .= ",'Cleartext-Password'"; // RADIUS attribute
  
      $query = 'INSERT INTO ' . PHS_DBTABLE_USER . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      $colnames = 'usergroup_username';
      $colvalues = $this->dbh->quote($rowin['uuname']) . ','; // all quoted strings
      $colnames .= ',usergroup_groupname';
      $colvalues .= $this->dbh->quote($rowin['rad_usergroup_groupname']); // all quoted strings
      $colnames .= ',usergroup_ndate';
      $colvalues .= ', NOW() ';

        // insert into RADIUS usergroup table
      $radquery = 'INSERT INTO ' . PHS_DBTABLE_USERGROUP . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>insertUser:</b>>");
        print($query);
        print($radquery);
        print('<<b>END-DEBUG</b> ');
      }
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE
 
      if (!DB::isError($rs = $this->dbh->query($query))) {
        // get insert ID
        // HACK! Bypasses PEAR:DB !!
        //print_r($this->dbh);
        //print_r($this->dbh->connection);
        $rowin['user_id'] =  mysql_insert_id($this->dbh->connection);
        // END OF HACK
        //print(' UserID: '. $rowin['user_id']);
        if (!is_null($billingrow)) {
          $billinglog_id = $this->logBilling($rowin, $billingrow);
        }
        $this->logUser($rowin, PHS_LOGUS_INSERT, $billinglog_id);
        //print('Insert user OK');
          // insert into RADIUS usergroup tbale
        if (!DB::isError($rs = $this->dbh->query($radquery))) {
          //print('Insert user OK');
        } else {
          $this->db_errmsg = $rs->getMessage();
          $trans_error = True;
        }
      } else {
        $this->logUser($rowin, PHS_LOGUS_IFAILED);
        $this->db_errmsg = $rs->getMessage();
        //print('Insert user NOT OK: '. $this->db_errmsg);
          // give some nicer error message
        if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
          $this->db_errmsg = 'Login Id already exists';
        }
        $trans_error = True;
      }

          // END TRANSACTION HERE
          
      //exit;
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->commit();
            //$this->dbh->rollback();
        //}
        return(Null);
      } else {
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->rollback();
        //}
        return($this->db_errmsg);
      }
    }
  }

/********************************************************************
*	Update User
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
*	20070516gr - Add billingrow insert
*********************************************************************/

  function updateUser($rowin=Null, $billingrow=Null) {
    global $phs_ldate, $phs_ccid;
    $this->db_errmsg = 'empty user input row';
    $rowstr = '';	
    $colnames  = '';
    $colvalues = '';
    $billinglog_id =  0;

    //print_r($rowin);exit;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // note: This technique requires all non-strings have to end with '_id'
        //if ($key == 'user_nas_id' || $key == 'user_client_id' || $key == 'user_id' || $key == 'rad_usergroup_groupname' || $key == 'uuname') continue; // no update
        switch ($key) {
        case 'user_nas_id':
        case 'user_client_id':
        case 'user_id':
        case 'rad_usergroup_groupname':
        case 'uuname';
        case 'client_address_location_str':
        case 'update':
          continue 2; // continue foreach
        case 'user_stoptime':
          $rowstr .= $key . '= CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          continue 2; // continue foreach
        case 'usttm':
          $rowstr .= $key . '= CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          continue 2; // continue foreach
        }
        if (eregi('_id', $key) || $key == 'user_status') {
          $rowstr .= $key . '=' . $value . ','; // not quoted 
        } else {
          $rowstr .= $key . '=' . $this->dbh->quote($value) . ',';
        }
      }

      $rowstr .= "user_ccid='" . $phs_ccid . "'";

      $condition = "user_attribute='Password' AND ";
      $condition = 'user_id=' . $rowin['user_id'] . ' AND ';
      $condition .= 'user_client_id=' . $rowin['user_client_id'] . ' AND ';
      $condition .= 'user_nas_id=' . $rowin['user_nas_id'];
  
      $query = 'UPDATE ' . PHS_DBTABLE_USER . ' SET ' . $rowstr . ' WHERE ' . $condition;

        // update RADIUS usergroup table to assign Service Plan or suspend
      $condition = "usergroup_username='" . $rowin['uuname'] . "'";
      $radquery = 'UPDATE ' . PHS_DBTABLE_USERGROUP . " SET usergroup_groupname='" . $rowin['rad_usergroup_groupname'] . "' WHERE " . $condition;

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>updateUser:</b>>");
        print($query);
        print($radquery);
        print_r($billingrow);
        print('<<b>END-DEBUG</b> ');
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE

      if (!DB::isError($rs = $this->dbh->query($query))) {
        if (!is_null($billingrow)) {
          $billinglog_id = $this->logBilling($rowin, $billingrow);
        }
        $this->logUser($rowin, PHS_LOGUS_UPDATE, $billinglog_id);

        //print('Update user OK');
        if (!DB::isError($rs = $this->dbh->query($radquery))) {
          //print('Update usergroup OK');
        } else {
          $this->db_errmsg = $rs->getMessage();
          $trans_error = True;
        }
      } else {
        $this->logUser($rowin, PHS_LOGUS_UFAILED);
        $this->db_errmsg = $rs->getMessage();
        //print('Update user NOT OK: '. $this->db_errmsg);
          // give some nicer error message
        //if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
          //$this->db_errmsg = 'Login Id already exists';
        //}
        $trans_error = True;
      }
          // END TRANSACTION HERE
          
      //exit;
          // check if DB query was successful here
      if (!$trans_error) {
        //print ("DB insert OK ");
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->commit();
            //$this->dbh->rollback();
        //}
        return(Null);
      } else {
        //if ($db_control != COM_DB_NO_COMMIT) {
         //   $this->dbh->rollback();
        //}
        return($this->db_errmsg);
      }
    }
  }

/*********************************************
*	Delete User (mark user as deleted)
*	input: rowin
*		- 
*		- 
*	Return: True on success
**********************************************/

  function deleteUser($rowin=Null) {
    global $phs_ldate;
    $retval = Null;

    if (!is_null($rowin)) {
                  //uuname=username' . 'DISAB' . '
                  //user_mdate='" . $phs_ldate . "'
      $query = 'UPDATE phs_user SET user_status=' . PHS_ST_DEL . "
                  WHERE user_id=" . $rowin['user_id'] . ' AND  
                  user_client_id=' . $rowin['user_client_id'] . ' AND   
                  user_nas_id=' . $rowin['user_nas_id'];

      //print("DelUserQ:$query "); exit;
      
      if (DB::isError($rs = $this->dbh->query($query))) {
        $this->logUser($rowin, PHS_LOGUS_DFAILED);
        $retval = $rs->getMessage();
          //$this->dbh->rollback();
      } else {
        if (!($this->dbh->affectedRows() > 0)) {
          $retval = 'User not deleted! Invalid User Id ' . $rowin['user_id'];
        } else {
          $this->logUser($rowin, PHS_LOGUS_DELETE);
        }
          //$this->dbh->commit();
          //$retval = True;
      }
    }
    return($retval);
  }
  
/********************************************************************
*	validateUserInput
*	input:	rowin
*	return:	Null on success, else errmsg
*********************************************************************/

  function validateUserInput($rowin=Null) {
    $_errmsg = Null;
    //print_r($rowin);
    if (!isset($rowin['update'])) { // update does not need username to be set
      if (empty($rowin['uuname'])) {
        $_errmsg = 'Login Id missing';
      } elseif (strlen($rowin['uuname']) < PHS_LEN_USER) {
        $_errmsg = 'Login Id too short! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (strlen($rowin['uuname']) > PHS_LEN_USER_MAX) {
        $_errmsg = 'Login Id too long! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
      } elseif (ereg('[^a-zA-Z0-9_.-:]{1,}', $rowin['uuname'])) {
        $_errmsg = 'Only use a-z, 0-9, _.- and no spaces for the Login Id';
      }
    } 
    if (is_null($_errmsg)) { 
      if (isset($rowin['user_value'])) { // update does not need password to be set
        if (empty($rowin['user_value'])) {
          $_errmsg = 'Password missing';
        } elseif (strlen($rowin['user_value']) < PHS_LEN_PW) {
          $_errmsg = 'Password too short! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (strlen($rowin['user_value']) > PHS_LEN_PW_MAX) {
          $_errmsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
        } elseif (ereg('[^a-zA-Z0-9_.-:]{1,}', $rowin['user_value'])) {
          $_errmsg = 'Only use a-z, 0-9, _.- and no spaces for the password';
        }
      }
    }
    if (is_null($_errmsg) && !($rowin['user_status'] & PHS_ST_PREPAID)) {
      if (empty($rowin['user_location'])) {
        $_errmsg = $rowin['client_address_location_str'] . ' missing';
      } elseif (strlen($rowin['user_location']) < PHS_LEN_LOCATION) {
        $_errmsg = $rowin['client_address_location_str'] . ' too short! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      } elseif (strlen($rowin['user_location']) > PHS_LEN_LOCATION_MAX) {
        $_errmsg = $rowin['client_address_location_str'] . ' too long! Must be between ' . PHS_LEN_LOCATION . ' - ' . PHS_LEN_LOCATION_MAX . ' characters';
      }
    }
      //print('err:'.$_errmsg);exit;

    return($_errmsg);

  }

/********************************************************************
*	Construct Date and Time display array
*	input: MySQL datetime string: YYYY-MM-DD 00:00:00
*	return:	Date/Time array on success, else Null
Note: min: YYYY-M-D 0:0:0 = 14, max: YYYY-MM-DD 00:00:00 = 19
*********************************************************************/

  function getDateTimeArray($datetimestr=Null) {
    $_retArray = Null;
    if ($datetimestr <> Null && strlen($datetimestr) > 13) {
//print('datetimestr:'.$datetimestr);
      $_datetime = explode(' ', $datetimestr);

      $_date = $_datetime[0];
      $_time = $_datetime[1];
      $_dateArray = explode('-', $_datetime[0]);
      $_timeArray = explode(':', $_datetime[1]);

      $_retArray['Year']    = $_dateArray[0];
      $_retArray['Month']   = sprintf('%02d',$_dateArray[1]);
      $_retArray['Day']     = sprintf('%02d',$_dateArray[2]);
      $_retArray['Hour']    = sprintf('%02d',$_timeArray[0]);
      $_retArray['Minute']  = sprintf('%02d',$_timeArray[1]);
      $_retArray['Second']  = sprintf('%02d',$_timeArray[2]);
      if ($_retArray['Hour'] >= 12) {
        $_retArray['AmPm'] = 'p';
        if (!PHS_TIME24) {
          $_retArray['Hour'] -= 12;
        }
      } else {
        $_retArray['AmPm'] = 'a';
      }
      switch($_dateArray[1]) {
      case 1:
        $_retArray['MonthNameS'] = 'Jan';
        break;
      case 2:
        $_retArray['MonthNameS'] = 'Feb';
        break;
      case 3:
        $_retArray['MonthNameS'] = 'Mar';
        break;
      case 4:
        $_retArray['MonthNameS'] = 'Apr';
        break;
      case 5:
        $_retArray['MonthNameS'] = 'May';
        break;
      case 6:
        $_retArray['MonthNameS'] = 'Jun';
        break;
      case 7:
        $_retArray['MonthNameS'] = 'Jul';
        break;
      case 8:
        $_retArray['MonthNameS'] = 'Aug';
        break;
      case 9:
        $_retArray['MonthNameS'] = 'Sep';
        break;
      case 10:
        $_retArray['MonthNameS'] = 'Oct';
        break;
      case 11:
        $_retArray['MonthNameS'] = 'Nov';
        break;
      case 12:
        $_retArray['MonthNameS'] = 'Dec';
        break;
      }
    }
    return($_retArray);
  }

/********************************************************************
*	Construct MySQL Date and Time string 
*	input: Date and Time array
*	return:	Date/Time string on success, else Null
*********************************************************************/

  function convertDateTimeArray($datetimeArray=Null) {
    //print_r($datetimeArray);
    $_retStr = Null;
      //print_r($datetimeArray); 
    if (is_array($datetimeArray)) {
      if (is_numeric($datetimeArray['Year']) && $datetimeArray['Year'] > (PHS_YEAR -10) && $datetimeArray['Year'] < (PHS_YEAR +10)) {
        $_retStr = $datetimeArray['Year'];
        //print($_retStr);
        if (is_numeric($datetimeArray['Month']) && $datetimeArray['Month'] > 0 && $datetimeArray['Month'] < 13) {
          $_retStr .= '-' . $datetimeArray['Month'];
        //print($_retStr);
          if (is_numeric($datetimeArray['Day']) && $datetimeArray['Day'] > 0 && $datetimeArray['Day'] < 32) {
            $_retStr .= '-' . $datetimeArray['Day'];
        //print($_retStr);
            if (is_numeric($datetimeArray['Hour']) && $datetimeArray['Hour'] >= 0 && $datetimeArray['Hour'] < 25) {
              if (!PHS_TIME24 && isset($datetimeArray['AmPm'])) {
                if (strtolower($datetimeArray['AmPm']) == 'p') {
                  $_retStr .= ' ' . $datetimeArray['Hour'] + 12;
                } elseif (strtolower($datetimeArray['AmPm']) == 'a') {
                  $_retStr .= ' ' . $datetimeArray['Hour'];
                } else {
                  $_retStr = Null;
                }
        //print($_retStr);
              } else {
                $_retStr .= ' ' . $datetimeArray['Hour'];
        //print($_retStr);
              }
              if (!is_null($_retStr) && is_numeric($datetimeArray['Minute']) && $datetimeArray['Minute'] >= 0 && $datetimeArray['Minute'] < 60) {
                $_retStr .= ':' . $datetimeArray['Minute'] . ':00';
        //print($_retStr);
              } else {
                $_retStr = Null;
              }
            } else {
              $_retStr = Null;
            }
          } else {
            $_retStr = Null;
          }
        } else {
          $_retStr = Null;
        }
      } else {
        $_retStr = Null;
      }
    }
      // check if date is a valid Gregorian date
    if (!checkdate($datetimeArray['Month'], $datetimeArray['Day'], $datetimeArray['Year'])) {
        $_retStr = Null;
    }
    return($_retStr);
  }


/********************************************************************
*	Get all users currently online
*	input: client_id
*	return:	array of online users for this client, if client id=0, return ALL
*********************************************************************/

  function getOnlineUsers($clientid=-1) {
    $_resultrow = Null;
    if ($clientid >= 0) {
      $_query = "SELECT user_id, uuname, user_lastname, user_firstname, usttm, user_stoptime, user_location, CONVERT_TZ(radacct_starttime, 'GMT', '" . PHS_TZONE . "') AS radacct_starttime, radacct_stoptime, radacct_calling_stationid, radacct_inputoctets, radacct_outputoctets, ndev_info_hostname, usermac_location FROM " . PHS_DBTABLE_USER . '
        INNER JOIN ' . PHS_DBTABLE_RADACCT . ' ON uuname=radacct_username
        LEFT JOIN ' . PHS_DBTABLE_NDEV_INFO . ' ON (radacct_called_stationid = ndev_info_secret OR radacct_called_stationid = ndev_info_mac) AND ndev_info_status=ndev_info_status & ~' . PHS_ST_DEL . ' 
        LEFT JOIN ' . PHS_DBTABLE_USERMAC . ' ON radacct_calling_stationid = usermac_mac
        WHERE ' . ($clientid > 0 ? 'user_client_id=' . $clientid . ' AND ' : '') . 'usttm > 0 AND radacct_stoptime=0 AND DATE_SUB(NOW(),INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . ' SECOND) <= radacct_mdate 
        ORDER BY user_client_id, radacct_starttime DESC';
      /*
  $_query = "SELECT user_id, uuname, user_lastname, user_firstname, usttm, user_stoptime, user_location, CONVERT_TZ(radacct_starttime, 'GMT', '" . PHS_TZONE . "') AS radacct_starttime, radacct_stoptime, radacct_calling_stationid, radacct_inputoctets, radacct_outputoctets, ndev_info_hostname FROM " . PHS_DBTABLE_USER . '
        INNER JOIN ' . PHS_DBTABLE_RADACCT . ' ON uuname=radacct_username
        LEFT JOIN ' . PHS_DBTABLE_NDEV_INFO . ' ON (radacct_called_stationid = ndev_info_secret OR radacct_called_stationid = ndev_info_mac) AND ndev_info_status=ndev_info_status & ~' . PHS_ST_DEL . ' 
        WHERE ' . ($clientid > 0 ? 'user_client_id=' . $clientid . ' AND ' : '') . 'usttm > 0 AND radacct_stoptime=0 AND DATE_SUB(NOW(),INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . ' SECOND) <= radacct_mdate 
        ORDER BY user_client_id, radacct_starttime DESC';
*/
    //print($_query); exit;
      //$_query1 = 'SELECT usermac_location, usermac_mac FROM ' . PHS_DBTABLE_USERMAC . ($clientid > 0 ? ' WHERE usermac_client_id=' . $clientid : '');
      //if (!DB::isError($rs = $this->dbh->query($_query1))) {
       // $_resultrowMac = Array();
        //while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        //  $_resultrowMac[] = $row;
        //}
        if (!DB::isError($rs = $this->dbh->query($_query))) {
          while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
            //foreach ($_resultrowMac as $key => $value) {
            //  if ($value['usermac_mac'] == $row['radacct_calling_stationid']) {
            //    $row['usermac_location'] = $value['usermac_location'];
            //  }
            //}
            $_resultrow[] = $row;
          }
        }
      //}
    }
    return($_resultrow);
  }
  
/********************************************************************
*	Get online status for a single user
*	input: client_id
*	return:	radacct info for user or Null
*********************************************************************/

  function getUserOnlineStatus($userid=0) {
    $_resultrow=Null;
    //$ix=0;
    if ($userid > 0) {
      $_query = "SELECT CONVERT_TZ(radacct_starttime, 'GMT', '" . PHS_TZONE . "') as radacct_starttime,  CONVERT_TZ(radacct_stoptime, 'GMT', '" . PHS_TZONE . "') as radacct_stoptime, radacct_sessiontime, radacct_inputoctets, radacct_outputoctets, radacct_terminatecause FROM " . PHS_DBTABLE_USER . ', phs_radacct WHERE ' . (PHS_CLIENT_ID > 0 ? ' user_client_id=' . PHS_CLIENT_ID . ' AND ' : '') . 'usttm > 0 AND uuname=radacct_username AND user_id=' . $userid . ' AND radacct_stoptime=0 AND DATE_SUB(NOW(),INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT .' SECOND) <= radacct_mdate ORDER BY radacct_starttime DESC LIMIT 1';
    }
    //print($_query);
    if (!DB::isError($rs = $this->dbh->query($_query))) {
      while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_resultrow = $row;
      }
    }
    return($_resultrow);
  }

/********************************************************************
*	Get number of users for this client
*	input: client_id
*	return:	number of users or 0
*********************************************************************/

  function getUserNum($clientid=-1) {
    $_numUsers = 0;
    if ($clientid >= 0) {
      $_query = 'SELECT COUNT(*) as total FROM ' . PHS_DBTABLE_USER . ' WHERE user_client_id=' . $clientid . ' AND user_status=user_status & ~'. (PHS_ST_DEL|PHS_ST_PREPAID);

      //print('Q:'.$_query);exit;
      if (!DB::isError($rs = $this->dbh->query($_query))) {
        $row = $rs->fetchRow(DB_FETCHMODE_ASSOC);
        $_numUsers = $row['total'];
      }
    }
    return($_numUsers);
  }

/********************************************************************
*	Get number of Admin users for this client
*	input: client_id
*	return:	number of users or 0
* Note: Ignore deleted entries
*********************************************************************/

  function getAdmUserNum($clientid=-1) {
    $_numAdmUsers = 0;
    //$ix=0;
    if ($clientid >= 0) {
      $_query = 'SELECT COUNT(*) as total FROM ' . PHS_DBTABLE_CLIENT_CONTACT . ' WHERE client_contact_client_id=' . $clientid . ' AND client_contact_status=client_contact_status & ~'. PHS_ST_DEL;
      //print('Q:'.$_query);
      if (!DB::isError($rs = $this->dbh->query($_query))) {
        $row = $rs->fetchRow(DB_FETCHMODE_ASSOC);
        $_numAdmUsers = $row['total'];
      }
    }
    return($_numAdmUsers);
  }  
      
/********************************************************************
*	Get userStatus
*	input: row
*	return:	user status or 0
*********************************************************************/

  function getUserStatus($rowin=Null) {
    $_result = 0;
    $_query = Null;

    if (!is_null($rowin)) {
      //print_r($rowin);
      if (strtotime((empty($rowin['usttm']) ? '0' : $rowin['usttm'])) > strtotime('now')) {
        $_result = 1; // dummy second to allow edit of future start dates
      } else {
        switch($rowin['package_type_options']) {
        case (PHS_M_PACKT_START):
          //print(' ->Start ');

          if ($rowin['user_status'] == PHS_ST_INACTIVE) {
            $_query = "SELECT IF('" . $rowin['ulsttm'] . "' > 0, IF(NOW() > CONVERT_TZ('" . $rowin['ulsttm'] . "', '" . PHS_TZONE . "','GMT'), IF(DATE_ADD(CONVERT_TZ('" . $rowin['ulsttm'] . "', '" . PHS_TZONE . "', 'GMT'), INTERVAL " . $rowin['package_type_interval'] . ") > NOW(), TIME_TO_SEC(TIMEDIFF(DATE_ADD(CONVERT_TZ('" . $rowin['ulsttm'] . "', '" . PHS_TZONE . "', 'GMT'), INTERVAL " . $rowin['package_type_interval'] . "), NOW())), 0), 0)," . PHS_ST_LOGINREADY . ') as result';
  //CONVERT_TZ(dt,from_tz,to_tz) 
          }
          break;
        case (PHS_M_PACKT_STOP):
          break;
        case (PHS_M_PACKT_START|PHS_M_PACKT_STOP):
          //print(' ->Start|Stop ');
          $_query = "SELECT IF(NOW() <= '" . $rowin['user_stoptime'] . "', TIME_TO_SEC(TIMEDIFF('" . $rowin['user_stoptime'] . "', IF(NOW() >= '" . $rowin['usttm'] . "', now(), DATE_SUB(CONVERT_TZ('" . $rowin['user_stoptime'] . "', '" . PHS_TZONE . "', 'GMT'), INTERVAL 1 SECOND)))), 0) as result";
          break;
        case (PHS_M_PACKT_TOTAL):
          break;
        }

      //print("\n<br>".$_query);
        if (!is_null($_query)) {
          //print($_query); 
          if (!DB::isError($_rs2 = $this->dbh->Query($_query))) {
            $_row2 = $_rs2->fetchRow(DB_FETCHMODE_ASSOC);
            $_result = $_row2['result'];
          }
        }
      }
    }
    //print(' result:'.$_result); exit;
    return($_result);
  }

/********************************************************************
*	Create new account cards
*	input: number of cards, account time
*	return:	Null or Error message
*	return:	Array of username and password or Error message
*********************************************************************/

  function createAccountCards($rowin=Null, $numCards=0) {
    $_result = 0;
    $_retArr = array(); 
    $_retArr[0] = 0; 
   //print('numCards:'.$numCards.' cardTime:'.$cardTime);

    if ($rowin <> Null && $numCards > 0) {
      $_addrCode = $rowin['ulsttm']; // abused field for client address code
      $rowin['ulsttm'] = 0;
      for ($ix=0; $ix < $numCards; $ix++) {
        //print(' '.$ix);
          //print(' '. $this->makeUsername($rowin['user_client_id']));
        $rowin['uuname'] = $this->makeUsername($rowin['user_client_id']) . '@' . $_addrCode;;
        $rowin['user_value'] = $this->makePasswd();
        //print_r($rowin);

        $_retArr[$ix +1]['uuname'] = $rowin['uuname'];
        $_retArr[$ix +1]['user_value'] = $rowin['user_value'];

        if (($_ErrMsg = $this->insertUser($rowin)) <> Null) {
          // OK, we got an error
          //$process_error = True;
          //print('error:'. $_ErrMsg);
          $_retArr[0] = -1; 
          $_retArr[1] = $_ErrMsg; 
          break;
        }
      }
    }
    return($_retArr);
  }


/********************************************************************
*	Generate random username for pre-paid cards
* 20060110gr
*	return:	random username
*********************************************************************/


// create random username
  function makeUsername($clientId=0) {
    $consts='bcdgklmnprst';
    $vowels='aeiou';
    $num= (mt_rand(1, 9));
    do { // get a unique username
      for ($x=0; $x < 6; $x++) {
              $const[$x] = substr($consts,mt_rand(0,strlen($consts)-1),1);
              $vow[$x] = substr($vowels,mt_rand(0,strlen($vowels)-1),1);
      }
      $_userName = $const[0] . $vow[0] .$const[2] . $const[1] . $vow[1] . $const[3] . $num . $clientId;
        // check if username already exists
      $_query = 'SELECT COUNT(uuname) as total FROM ' . PHS_DBTABLE_USER . " phs_user WHERE uuname='" . $_userName . "'";
      if (!DB::isError($_rs2 = $this->dbh->Query($_query))) {
        $_row = $_rs2->fetchRow(DB_FETCHMODE_ASSOC);
        $_numUsers = $_row['total'];
      }
    } while ($_numUsers > 0);

      return($_userName);
  }

/********************************************************************
*	Generate random 8 char password for pre-paid cards
* 20060110gr
*	return:	random password
*********************************************************************/
/**
 * Generates an 8 character pronounceable password.
 *
 * @author        Max Dobbie-Holman <max@blueroo.net>
 * @version       1.0
 */
  function makePasswd() {

        $consts='bcdgklmnprst';
        $vowels='aeiou';

        for ($x=0; $x < 6; $x++) {
        //      mt_srand ((double) microtime() * 1000000); // no longer required
                $const[$x] = substr($consts,mt_rand(0,strlen($consts)-1),1);
                $vow[$x] = substr($vowels,mt_rand(0,strlen($vowels)-1),1);
        }
        return $const[0] . $vow[0] .$const[2] . $const[1] . $vow[1] . $const[3] . $vow[3] . $const[4];

  }
 
/********************************************************************
*	Log all changes to user entries
* 20060216gr
* insert: raw input row, action (insert, update, delete, etc. refer to PHS_LOGUS_...)
*	return:	
*********************************************************************/
  function logUser($rowin=Null, $action=0, $billinglog_id=0) {
    $colnames = '';
    $colvalues = '';

    if (!is_null($rowin)) {

      //print_r($rowin); exit;

      foreach ($rowin as $key => $value) {
          // filter only wanted keys and values!
        switch ($key) {
        case 'uuname':
          $colnames .= 'userlog_uname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_value':
          $colnames .= 'userlog_value, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_location':
          $colnames .= 'userlog_location, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_firstname':
          $colnames .= 'userlog_firstname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_lastname':
          $colnames .= 'userlog_lastname, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_email':
          $colnames .= 'userlog_email, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_phone':
          $colnames .= 'userlog_phone, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_address':
          $colnames .= 'userlog_address, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_payment':
          $colnames .= 'userlog_payment, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_notes':
          $colnames .= 'userlog_notes, ';
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
          break;
        case 'user_status':
          $colnames .= 'userlog_status, ';
          $colvalues .= $value . ',';
          break;
        case 'user_client_id':
          $colnames .= 'userlog_client_id, '; //client address/location
          $colvalues .= $value . ',';
          break;
        case 'user_client_package_id':
          $colnames .= 'userlog_client_package_id, ';
          $colvalues .= $value . ',';
          break;
        case 'user_stoptime':
          if (!empty($value)) {
            $colnames .= 'userlog_stoptime, ';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          }// else {
            //$colvalues .= 0 . ',';
          //}
          break;
        case 'usttm':
          if (!empty($value)) {
            $colnames .= 'userlog_starttime, ';
            $colvalues .= ' CONVERT_TZ(' . $this->dbh->quote($value) . ",'" . PHS_TZONE . "', 'GMT'), ";
          } //else {
            //$colvalues .= 0 . ',';
          //}
          break;
        default:
          continue 2; // skip all other keys and continue foreach
        }
      }
      $colnames .= 'userlog_action, ';
      $colvalues .= $action . ',';
      $colnames .= 'userlog_ccid,';
      $colvalues .= Phs_Ccid . ',';
      if ($billinglog_id > 0) {
        $colnames .= 'userlog_billinglog_id';
        $colvalues .= $billinglog_id;
      }
      //$colnames .= 'userlog_mdate';
      //$colvalues .= 'NOW()';
      
      $_query = 'INSERT INTO ' . PHS_DBTABLE_USERLOG . ' (' . $colnames . ') VALUES (' . $colvalues . ')';
      //print($_query); 

      if (DB::isError($_rs = $this->dbh->Query($_query))) {
        // insert NOK
        //print($_rs->getMessage());
        //exit;
      }
    }
  }

/********************************************************************
*	Update Client Contact record
* 20060221gr
* insert: raw input row
*	return:	
*********************************************************************/
  function updateClientContact($rowin=Null) {
    $rowstr = '';	
    $_retval = Null;
    //print_r($rowin);

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        switch($key) {
        case 'client_contact_id':
          $condition = 'client_contact_id=' . $value;
          continue 2; // skip
        case 'client_contact_password':
          $rowstr .= $key . '=' . $this->dbh->quote(md5($value)) . ',';
          continue 2; // skip
        case 'client_contact_timeFormat':
          $rowstr .= 'client_contact_options' . '=' . 'client_contact_options' . ($value == '12' ? '&~' . PHS_M_CLIENT_TIME24 : '|' . PHS_M_CLIENT_TIME24) . ',';
          continue 2; // skip
        case 'client_contact_permissions':
          $rowstr .= 'client_contact_permissions=' . $rowin['client_contact_permissions'] . ',';
          continue 2; // skip
        }
        $rowstr .= $key . '=' . $this->dbh->quote($value) . ',';
      }
      $rowstr .= 'client_contact_ccid=' . Phs_Ccid;
      $query = 'UPDATE ' . PHS_DBTABLE_CLIENT_CONTACT . ' SET ' . $rowstr . ' WHERE ' . $condition;
      //print($query); exit;
      if (DB::isError($rs = $this->dbh->query($query))) {
        $_retval = $rs->getMessage();
      }
    }
    return($_retval);
  }

/********************************************************************
*	Insert new Admin User
* 20060303gr
*	input:	rowin, preformatted input row
*	return:	Null on success, else errmsg
*********************************************************************/

  function insertClientContact($rowin=Null) {
    global $phs_ldate, $phs_ccid;
    $this->db_errmsg = 'empty admin user input row';
    $colnames = '';	
    $colvalues = '';
    $radcolnames = '';	
    $radcolvalues = '';

    //print_r($rowin); //exit;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        // if ($key == 'order_id_pk') continue; // skip order id
        // sort all keys and values from ONE input row to multiple
        // database rows
        switch ($key) {
        case 'client_contact_password':
          $colnames .= $key.',';
          $colvalues .= $this->dbh->quote(md5($value)) . ',';
          continue 2; // skip
        case 'client_contact_timeFormat':
          $colnames .= 'client_contact_options'.',';
          $colvalues .= ($value == '12' ? 0 : PHS_M_CLIENT_TIME24) . ',';
          continue 2; // skip
        case 'client_contact_permissions':
          $colnames .= $key.',';
          $colvalues .= $rowin['client_contact_permissions'] . ',';
          continue 2; // skip
        }
        $colnames .= $key.',';
        // note: This technique requires all non-strings have to end with '_id'
        if (eregi('_id', $key) || $key == 'client_contact_status') { // id is always NO string value, _alt_ for alteration values
          $colvalues .= (int)$value . ','; // not quoted 
        } else {
          $colvalues .= $this->dbh->quote($value) . ','; // all quoted strings
        }
      }
      //$colnames .= 'client_contact_mdate';
      //$colvalues .= "'" . $phs_ldate . "'";
      //$colvalues .= " CONVERT_TZ('" . PHS_LDATE . "', '" . PHS_TZONE "', 'GMT') ";
      //$colvalues .= ' NOW() ';
      $colnames .= 'client_contact_ndate';
      $colvalues .= ' NOW() ,';
      //$colvalues .= ",'" . $phs_ldate . "',";
      $colnames .= ',client_contact_ccid';
      $colvalues .= $phs_ccid;
  
      $query = 'INSERT INTO ' . PHS_DBTABLE_CLIENT_CONTACT . ' (' . $colnames . ') VALUES (' . $colvalues . ')';

      if ($GLOBALS['Phs_Debug'] > 30) {
        print("\n<br><b>insertAdmUser:</b>>");
        print($query);
        print('<<b>END-DEBUG</b> ');
      }
      //exit;
      $trans_error = False;
      
      // BEGIN TRANSACTION HERE
 
      if (!DB::isError($rs = $this->dbh->query($query))) {
        $this->logUser($rowin, PHS_LOGUS_CCINSERT);
        //print('Insert user OK');
          // insert into RADIUS usergroup tbale
      } else {
        $this->logUser($rowin, PHS_LOGUS_CCIFAILED);
        $this->db_errmsg = $rs->getMessage();
        //print('Insert user NOT OK: '. $this->db_errmsg);
          // give some nicer error message
        if ($rs->getCode() == DB_ERROR_ALREADY_EXISTS) {
          $this->db_errmsg = 'Admin Login Id already exists';
        }
        $trans_error = True;
      }

          // END TRANSACTION HERE
          
          // check if DB query was successful here
      if (!$trans_error) {
        return(Null);
      } else {
        return($this->db_errmsg);
      }
    }
  }
  

/********************************************************************
*	Update Client Contact record
* 20060221gr
* insert: raw input row
*	return:	
*********************************************************************/
  function updateClientAddress($rowin=Null) {
    $rowstr = '';	
    $_retval = Null;

    if (!is_null($rowin)) {
          // walk through input row
      foreach ($rowin as $key => $value) {
        switch($key) {
        case 'client_address_id':
          $condition = 'client_address_id=' . $value;
          continue 2; // skip
        case 'client_address_timeFormat':
          $rowstr .= 'client_address_options' . '=' . 'client_address_options' . ($value == '12' ? '&~' . PHS_M_CLIENT_TIME24 : '|' . PHS_M_CLIENT_TIME24) . ',';
          continue 2; // skip
        }
        $rowstr .= $key . '=' . $this->dbh->quote($value) . ',';
      }
      $rowstr .= 'client_address_ccid=' . Phs_Ccid;
      $query = 'UPDATE ' . PHS_DBTABLE_CLIENT_ADDRESS . ' SET ' . $rowstr . ' WHERE ' . $condition;
      //print($query); exit;
      if (DB::isError($rs = $this->dbh->query($query))) {
        $_retval = $rs->getMessage();
      }
    }
    return($_retval);
  }  

/*********************************************
*	Get All Internet access controlled Users
*	20050914gr
*	input:  nasid (router's ID)
*           from: starting row
*           pagelimit: max rows per page
*	Return: result array or Null
*   Result array[0] contains numrows information for the Pager
**********************************************/

  function getAllAdminUsers($addressId=0, $type=0, $searchstr='', $sortorder='', $from=0, $pagelimit=10) {
    $_nrows = 0;
    $_retarray = array(0 => array('numrows' => 0));


    $_query1 = 'SELECT * FROM ' . PHS_DBTABLE_CLIENT_CONTACT . ' WHERE client_contact_status=client_contact_status & ~' . PHS_ST_DEL . (defined('PHS_ADMIN') ? '' : ' AND client_contact_address_id=' . $addressId) . 
      (!empty($searchstr) ? " 
      AND (client_contact_username like '%" . $searchstr . "%' 
      OR client_contact_lastname like '%" . $searchstr . "%' 
      OR client_contact_firstname like '%" . $searchstr . "%')" : '') .  
    ' ORDER BY ' . (!empty($sortorder) ? $sortorder : 'client_contact_lastname');
      
    //print($_query1); exit;
    //print($_query1);
    if (!DB::isError($_rs = $this->dbh->limitQuery($_query1, $from, $pagelimit))) {
      $_ix=1; // start at row 1, 0 is reserved for numrows
      $_query2a = "SELECT CONVERT_TZ(clientlog_mdate, 'GMT', '" . PHS_TZONE . "') as clientlog_tzmdate FROM " . PHS_DBTABLE_CLIENTLOG . ' WHERE clientlog_action = ' . PHS_LOGACT_LOGIN . " AND clientlog_username='";
      $_query2b = "' ORDER BY clientlog_mdate DESC LIMIT 1";
      while ($_row = $_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_retarray[$_ix] = $_row;
        $_query2 = $_query2a . $_row['client_contact_username'] . $_query2b;
        //print($_query2);
        if (!DB::isError($_rs2 = $this->dbh->query($_query2))) {
          while ($_row2 = $_rs2->fetchRow(DB_FETCHMODE_ASSOC)) {
            $_retarray[$_ix]['clientlog_tzmdate'] = $_row2['clientlog_tzmdate'];
          }
        }
        $_ix++;
      }

        // get total number of rows
      if (!DB::isError($_rs = $this->dbh->query($_query1))) {
        $_nrows = $_rs->numRows();
      }
    }
    $_retarray[0] = array('numrows' => $_nrows); 
    ///print_r($_retarray); exit;
    return ($_retarray);
  }


/*********************************************
*	Delete Admin User (mark user as deleted)
*	input: rowin
*	Return: True on success
**********************************************/

  function deleteClientContact($rowin=Null) {
    global $phs_ldate;
    $retval = Null;

    //print_r($rowin);
    if (!is_null($rowin)) {
                  //uuname=username' . 'DISAB' . '
      $query = 'UPDATE phs_client_contact SET client_contact_status=' . PHS_ST_DEL . '
                  WHERE client_contact_address_id=' . $rowin['client_contact_address_id'] . ' AND  
                  client_contact_client_id=' . $rowin['client_contact_client_id'] . ' AND   
                  client_contact_id=' . $rowin['client_contact_id'];

      //print("deleteClientContact:$query "); exit;
      
      if (DB::isError($rs = $this->dbh->query($query))) {
        $this->logUser($rowin, PHS_LOGUS_CCDFAILED);
        $retval = $rs->getMessage();
          //$this->dbh->rollback();
      } else {
        if (!($this->dbh->affectedRows() > 0)) {
          $retval = 'User not deleted! Invalid User Id ' . $rowin['user_id'];
        } else {
          $this->logUser($rowin, PHS_LOGUS_CCDELETE);
        }
          //$this->dbh->commit();
          //$retval = True;
      }
    }
    return($retval);
  }
   
/*********************************************
*	Get Status from all network devices e.g. WRT54G
*	20060305gr
*	input:  Location Id (client_address_id
*         from: starting row
*         pagelimit: max rows per page
*	Return: result array or Null
*   Result array[0] contains numrows information for the Pager
**********************************************/

  function getUnitStatus($addressId=0, $type=0, $searchstr='', $sortorder='', $from=0, $pagelimit=10) {
    $_nrows = 0;
    $_retarray = array(0 => array('numrows' => 0));

    $_query = "SELECT *, CONVERT_TZ(ndev_alive_mdate, 'GMT', '" . PHS_TZONE . "') as ndev_alive_tzmdate, IF(TIME_TO_SEC(TIMEDIFF(NOW(), ndev_alive_mdate)) > " . PHS_NDEV_TOUT_LIMIT . " ,0, 1) as ndev_alive_online 
        FROM " . PHS_DBTABLE_NDEV_INFO . ', ' . PHS_DBTABLE_NDEV_ALIVE . ' 
        WHERE ' . (defined('PHS_ADMIN') ? '' : ' ndev_info_client_id=' . $addressId . ' AND ') . 'ndev_info_status=ndev_info_status & ~' . PHS_ST_DEL . ' AND ndev_info_id=ndev_alive_ndev_id ' .
      (!empty($searchstr) ? " 
      AND (ndev_info_hostname like '%" . $searchstr . "%' 
      OR ndev_info_description like '%" . $searchstr . "%')" : '') .  
    ' ORDER BY ' . (!empty($sortorder) ? $sortorder : 'ndev_info_hostname');
      
    //print($_query); exit;
    //print($_query);
    if (!DB::isError($_rs = $this->dbh->limitQuery($_query, $from, $pagelimit))) {
      $_ix=1; // start at row 1, 0 is reserved for numrows
      //$_query2a = "SELECT *, CONVERT_TZ(ndev_uptime_mdate, 'GMT', '" . PHS_TZONE . "') as ndev_uptime_tzmdate FROM " . PHS_DBTABLE_NDEV_UPTIME . ' WHERE ndev_uptime_ndev_id = ';
      //$_query2b = ' ORDER BY ndev_uptime_mdate DESC LIMIT 1';

      while ($_row = $_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $_retarray[$_ix] = $_row;
        //$_query2 = $_query2a . $_row['ndev_info_id'] . $_query2b;
        //print($_query2);
        /*
        if (!DB::isError($_rs2 = $this->dbh->query($_query2))) {
          while ($_row2 = $_rs2->fetchRow(DB_FETCHMODE_ASSOC)) {
            //print_r($_row2);
            $_retarray[$_ix]['ndev_uptime_up'] = $_row2['ndev_uptime_up'];
            $_retarray[$_ix]['ndev_uptime_ip'] = $_row2['ndev_uptime_ip'];
            $_retarray[$_ix]['ndev_uptime_tzmdate'] = $_row2['ndev_uptime_tzmdate'];
          }
        }
        */
        $_ix++;
      }
        // get total number of rows
      if (!DB::isError($_rs = $this->dbh->query($_query))) {
        $_nrows = $_rs->numRows();
      }
    }
    $_retarray[0] = array('numrows' => $_nrows); 
    ///print_r($_retarray); exit;
    return ($_retarray);
  }

/*********************************************
* Get print cardfile from hidden directory outside of web tree
* 20060315gr
* input:  filename with path
* Return: 
**********************************************/
  function getCardFile ($file=Null) {

    //define('FILEDIR', '/mnt/dos/');
    //$path = FILEDIR . $file;
    //$file .= '.pdf';
    $path = PHS_PREPAID_DIR . PHS_CLIENT_ID . '/' . $file;
//print($path);

    //check that this file exists and that it doesn't include
    //any special characters
    //if(!is_file($path) OR !eregi('^[A-Z_0-9][A-Z_0-9.]*$', $file))
    if(!is_file($path) OR !eregi('^[A-Z_0-9][-A-Z_0-9.]*$', $file))
    {
        //header("Location: error.php");
        //exit();
        $retval = 'Incorrect File';
        //print($retval);
        return($retval);
    }

//print($path); exit;
    /*
    ** //check that the user has permission to download file
    ** if(user does not have permission)
    ** {
    **     //redirect to error page
    **     header("Location: error.php");
    **     exit();
    ** }
    */
/*
    $mimetype = array(
        'pdf'=>'application/pdf'
    );
*/
    /*
        'doc'=>'application/msword',
        'htm'=>'text/html',
        'html'=>'text/html',
        'jpg'=>'image/jpeg',
        'txt'=>'text/plain',
        'xls'=>'application/vnd.ms-excel'
        );
        */
    //$p = explode('.', $file);
    //$pc = count($p);

    //send headers
    /*
    if(($pc > 1) AND isset($mimetype[$p[$pc - 1]]))
    {
      //print('Moin:'.$mimetype[$p[$pc - 1]]);exit;
        //display file inside browser
        header("Content-type: " . $mimetype[$p[$pc - 1]] . "\n");
    }
    else
    {
        //force download dialog
        header("Content-type: application/octet-stream\n");
        header("Content-disposition: attachment; filename=\"$file\"\n");
    }
    */
    $fnArray = explode('-', $file); // demo20060316-1.pdf
    //print_r($fnArray);exit;
    header('Content-type: application/pdf' . "\r\n");
    header('Content-transfer-encoding: binary' . "\r\n");
    header('Content-length: ' . filesize($path) . "\r\n");
    header('Content-Disposition: attachment; filename="prepaid-' . substr($file, strlen(PHS_CLIENT_ACODE), 8) . (count($fnArray) > 1 ? '-' . $fnArray[1] : '') . '.pdf"');

    //send file contents
    $fp = fopen($path, 'rb');
    //fpassthru($fp); 
    $bytesSent = 0;
    while(!feof($fp)) {
      $buf = fread($fp, 4096);
      echo $buf;
      $bytesSent += strlen($buf); /* We know how many bytes were sent to the user */
    }
  }  
/********************************************************************
*	Log all changes to user entries
* 20060216gr
* insert: raw input row, action (insert, update, delete, etc. refer to PHS_LOGUS_...)
*	return:	
*********************************************************************/
  function logBilling($rowin=Null, $billingrow=Null) {
    $colnames = '';
    $colvalues = '';
    $billinglog_id = -1;

    if (!is_null($rowin) && !is_null($billingrow)) {

      /*
      foreach ($billingrow as $key => $value) {
        switch ($key) {
        case 'billinglog_amount':
          $colnames .= $key.',';
          $colvalues .= $this->dbh->quote($value) . ',';
          break;
        case 'billinglog_cycle_id':
          $colnames .= $key.',';
          $colvalues .= $value . ',';
          break;
        }
      }
       */
      $colnames .= 'billinglog_ccid,';
      $colvalues .= Phs_Ccid . ',';
      $colnames .= 'billinglog_client_id,';
      $colvalues .= $rowin['user_client_id'] . ',';
      $colnames .= 'billinglog_user_id,';
      $colvalues .= $rowin['user_id'] . ',';
      $colnames .= 'billinglog_cycle_id,';
      $colvalues .= $billingrow['billinglog_cycle_id'] . ',';
      $colnames .= 'billinglog_amount,';
      $colvalues .= $this->dbh->quote($billingrow['billinglog_amount']) . ','; 
      $colnames .= 'billinglog_username' . ',';
      $colvalues .= $this->dbh->quote($rowin['uuname']) . ','; 
      $colnames .= 'billinglog_notes,';
      $colvalues .= $this->dbh->quote($billingrow['billinglog_notes']) . ','; 

      //exit;
      if (DB::isError($billinglog_id = $this->dbh->nextId('phs_billinglog'))) { // get id to inherite
        die('Billing record insert failed ' . $billinglog_id->getMessage() . ' in nextID() ');
      }
      $colnames .= 'billinglog_id';
      $colvalues .= $billinglog_id;
      $_query = 'INSERT INTO ' . PHS_DBTABLE_BILLINGLOG . ' (' . $colnames . ') VALUES (' . $colvalues . ')';
      //print($_query);
      if (DB::isError($_rs = $this->dbh->Query($_query))) {
        // insert NOK
        //print($_rs->getMessage());
        //exit;
      }
    }
    return($billinglog_id);
  }

/*********************************************
* Disconnect Online User via coa port e.g. 3799
* 
* 20070521gr
* 20081121 Changed to SQL UDF function and SQL table phs_raddisclog
* input:  userid, nasArray
* Return: result message
**********************************************/
  function disconnectUser($userId=0, $nasArray) {
    $_return = '';
    $returnArray = array();
    global $db_user3, $db_pass, $db_name;
    if ($userId > 0 && PHS_REMOTE_SUSPEND) {
      // get NAS IP address from phs_user

      $_query = 'SELECT radacct_username,  radacct_framedipaddress, radacct_nas_ipaddress, radacct_calling_stationid, radacct_realm FROM ' . PHS_DBTABLE_USER . ',' . PHS_DBTABLE_RADACCT . ' WHERE user_id=' . $userId . ' AND radacct_username=uuname AND DATE_ADD( radacct_mdate, INTERVAL ' . PHS_RAD_ONLINE_TIMEOUT . ' SECOND ) > NOW() AND radacct_stoptime=0' . (PHS_CLIENT_ID > 0 ? ' AND user_client_id=' . PHS_CLIENT_ID : '') . ' ORDER BY radacct_mdate DESC LIMIT 1';
//print($_query);
//print_r($nasArray);

      if (DB::isError($_rs = $this->dbh->Query($_query))) {
        $_result = 'User not found';
      } else {
        $_row = $_rs->fetchRow(DB_FETCHMODE_ASSOC);
        //print_r($_row);
        if(is_array($_row) && !empty($_row['radacct_nas_ipaddress'])) {

          //if ($GLOBALS['Phs_Debug'] > 30) {
            //print('<!-- disconnectUser: ' . (defined('PHS_RAD_SSH') ? PHS_RAD_SSH . ' "' : '') . 'echo "User-Name = \'' . $_row['uuname'] . '\',Framed-IP-Address=\'' . $_row['radacct_framedipaddress'] . '\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'] . (defined('PHS_RAD_SSH') ? '"' : '') . " disconnectUser -->\n");
          //}
          //print('echo "User-Name = ' . $_row['uuname'] . '"|' . PHS_RADCLIENT . ' ' . $_row['user_nas_ip_address'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret']);
          // $lastLine = exec('echo "User-Name = \'' . $_row['uuname'] . '\'"|' . PHS_RADCLIENT . ' ' . $_row['user_nas_ip_address'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret']);
          //$lastLine = exec('echo "User-Name = \'' . $_row['uuname'] . '\',Framed-IP-Address=\'' . $_row['radacct_framedipaddress'] . '\'"|' . PHS_RADCLIENT . ' ' . $_row['user_nas_ip_address'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'], $returnArray);
          //$lastLine = exec((defined('PHS_RAD_SSH') ? PHS_RAD_SSH . ' "' : '') . 'echo "User-Name = \'' . $_row['uuname'] . '\',Framed-IP-Address=\'' . $_row['radacct_framedipaddress'] . '\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'] . (defined('PHS_RAD_SSH') ? '"' : ''), $returnArray);

          //print($lastLine);
          //print_r($returnArray);

            // 20081108gr
            // Requires MySQL with UDF lib_mysqludf_sys
            // OK 20081121gr ... Horror, but it works ;-)
        if (DB::isError($raddisclog_id = $this->dbh->nextId('phs_raddisclog'))) { // get id to inherite
          die('Raddisclog record insert failed ' . $raddisclog_id->getMessage() . ' in nextID() ');
        }
          //$query = 'SELECT sys_exec(\'echo "INSERT INTO phs_raddisclog (raddisclog_status) VALUES (\\\'`echo \\"User-Name = \\\'' .  $_row['uuname'] . '\\\',Framed-IP-Address=\\\'' . $_row['radacct_framedipaddress'] . '\\\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'] . '`\\\')"|/usr/bin/mysql -u ' . $db_user . ' --password=' . $db_pass . ' ' . $db_name . '\')';

/*
 * Check if this is a Mikrotik RouterOS device. So far only Mikrotik is used with 'Realm'
 */
					$_username = $_row['radacct_username'];
					if (!empty($_row['radacct_realm'])) {
						$_username = str_replace('@' . $_row['radacct_realm'], '', $_row['radacct_username']); 
					}

            // OK 20081121gr ... Horror, but it works ;-)
          $query = 'SELECT sys_exec(\'echo "INSERT INTO phs_raddisclog (raddisclog_id, raddisclog_user_id, raddisclog_ccid, raddisclog_status) VALUES (' . $raddisclog_id . ', ' . $userId . ',' . Phs_Ccid . ', \\\'`echo \\"User-Name = \\\'' .  $_username . '\\\',Framed-IP-Address=\\\'' . $_row['radacct_framedipaddress'] . '\\\',Calling-Station-Id=\\\'' . $_row['radacct_calling_stationid'] . '\\\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'] . '`\\\')"|/usr/bin/mysql -u ' . $db_user3 . ' --password=' . $db_pass . ' ' . $db_name . '\')';
 
          //$query = 'SELECT sys_exec(\'/bin/date>>' . PHS_RAD_DISCONNECT_LOG . '|echo "User-Name = \\\'' .  $_row['uuname'] . '\\\',Framed-IP-Address=\\\'' . $_row['radacct_framedipaddress'] . '\\\'"|' . PHS_RADCLIENT . ' ' . $_row['radacct_nas_ipaddress'] . ':' . PHS_RAD_COAPORT . ' ' . PHS_RAD_DISCONNECT . ' ' . $nasArray['nas_secret'] . '>>/var/lib/mysql/radDisc.log\')';

          if ($GLOBALS['Phs_Debug'] > 30) {
            print("\n<br><b>disconnectUser:</b>>");
            print($query);
            print('<<b>END-DEBUG</b> ');
          }
					error_log(PHS_LDATE . ' ' . basename($_SERVER['PHP_SELF'], '.php') . " disconnectUser :\n".$query . "\n", 3, PHS_FILE_HS_DEBUG1);

          if (DB::isError($rs = $this->dbh->query($query))) {
            $_return = 'Unable to disconnect user';
          } else {
            $query = 'SELECT raddisclog_status FROM ' . PHS_DBTABLE_RADDISCLOG . ' WHERE raddisclog_id=' . $raddisclog_id;
            if (DB::isError($rs = $this->dbh->query($query))) {
              $_return = 'Unable to disconnect user';
            } else {
              while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
                $_resultrow = $row;
              }
              //print_r($_resultrow);
							error_log(PHS_LDATE . ' ' . basename($_SERVER['PHP_SELF'], '.php') . " disconnectUser :\n".print_r($_resultrow, True)."\n", 3, PHS_FILE_HS_DEBUG1);
              $_return = 'Attempting to disconnect user'  ;
              if (strstr($_resultrow['raddisclog_status'], 'code 41')) {
                $_return = 'User successfully disconnected';
              } elseif (strstr($_resultrow['raddisclog_status'], 'code 42')) {
                $_return = 'User not disconnected - User was not online';
              } else {
                $_return = 'Unable to disconnect user';
              }
            }
          }
        } else {
          $_return = 'User not disconnected - User was not anymore online';
        }
      }
    }
    return($_return);
  }



} // end-class

/************************************************************************
*
* END CLASS
*
* BEGIN FUNCTIONS
*
/************************************************************************

/****************************
*	NOTE: This is not part of the above CLASS !!!!
*	function get_userpermission
*
*	arg: permission value
*
*	return: permission string
****/

function get_ClientPermission($perm) {
	switch ($perm) {
		case PHS_PERM_DISABLED:
			$pm = 'Disabled';
			break;
		case PHS_PERM_SUPADMIN:
			$pm = 'Super Administrator';
			break;
		case PHS_PERM_ADMIN:
			$pm = 'Client Administrator';
			break;
		case PHS_PERM_USER:
			$pm = 'Client';
			break;
		case PHS_PERM_PUSER:
			$pm = 'Power Client';
			break;
		default:
			$pm = 'Invalid permission';
	}
	return($pm);
}

/****************************
*	NOTE: This is not part of the above CLASS !!!!
*	function get_userStatus
*
*	arg: status value
*
*	return: status string
****/

function getUserStatusStr($status) {
  switch ($status) {
    case PHS_ST_INACTIVE:
      $pm = 'Offline';
      break;
    case PHS_ST_ACTIVE:
      $pm = 'Online';
      break;
    case PHS_ST_SUSPENDED:
      $pm = 'Suspended';
      break;
    case PHS_ST_IDLE_TIMEOUT:
      $pm = 'Idle Timeout';
      break;
    case PHS_ST_EXPIRED:
      $pm = 'Expired';
      break;
    case PHS_ST_PENDING:
      $pm = 'Pending';
      break;
    case PHS_ST_LOGINREADY:
      $pm = 'Ready';
      break;
    default:
      $pm = 'Invalid Status';
  }
  return($pm);
}

/********************************************************************
*	Strip off trailing @<location identifier>, e.g. @norm
*	input: username as stored in DB and used for RADIUS
*	return:	normalised username string on success, else Null
*   Restriction: the @ sign is not allowed in usernames 
*********************************************************************/

function normalizeUsername($username=Null) {
  $_retStr = Null;
  if (!is_null($username)) {
    $_normUserarray = explode('@', $username);
    $_retStr = $_normUserarray[0]; // take only first part
  }
  return($_retStr);
}


function dateDiff($interval,$dateTimeBegin,$dateTimeEnd) {
//Parse about any English textual datetime
//$dateTimeBegin, $dateTimeEnd

  $dateTimeBegin=strtotime($dateTimeBegin);
  if($dateTimeBegin === -1) {
    //return('..begin date Invalid');
    return(Null);
  }
  $dateTimeEnd=strtotime($dateTimeEnd);
    if($dateTimeEnd === -1) {
    //return('..end date Invalid');
    return(Null);
  }
  $dif = $dateTimeEnd - $dateTimeBegin;

  switch($interval) {
  case 's'://seconds
    return($dif);
  case 'n'://minutes
    return(floor($dif/60)); //60s=1m
  case 'h'://hours
    return(floor($dif/3600)); //3600s=1h
  case 'd'://days
    return(floor($dif/86400)); //86400s=1d
  case 'ww'://Week
    return(floor($dif/604800)); //604800s=1week=1semana
  case 'm': //similar result "m" dateDiff Microsoft
    $monthBegin = (date('Y', $dateTimeBegin) * 12)+
    date('n', $dateTimeBegin);
    $monthEnd = (date('Y', $dateTimeEnd) * 12)+
    date('n', $dateTimeEnd);
    $monthDiff = $monthEnd - $monthBegin;
    return($monthDiff);
  case 'yyyy': //similar result "yyyy" dateDiff Microsoft
    return(date('Y',$dateTimeEnd) - date('Y',$dateTimeBegin));
  default:
    return(floor($dif/86400)); //86400s=1d
  }
}

/****************************
*	NOTE: This is not part of the above CLASS !!!!
*	function DBdateDiff
* MySQL date calculations
*	arg: Interval, StartTime, EndTime, e.g. '2005-10-26 01:32:07'
*   Interval is MySQL style, e.g. '1 MONTH', '20 SECOND' etc.
*   Allowed interval types: SECOND, MINUTE, HOUR, DAY, (WEEK), MONTH, YEAR
*	return: difference in seconds, positive or negative
* If negative, time is expired
****/

function DBdateDiff($interval, $dateTimeBegin, $dateTimeEnd) {
  $_timeStr = '';

  $_datetime = explode(' ', $dateTimeBegin);

  $_date = $_datetime[0];
  $_time = $_datetime[1];
  $_dateArray = explode('-', $_datetime[0]);
  $_timeArray = explode(':', $_datetime[1]);

  $_intervalArray = explode(' ', $interval);
  /*
    Array:
    [0]: interval
    [1]: interval type
  */


  switch($_intervalArray[1]) {
    case 'SECOND':
      $_timeStr = $_date . ' ' . timeCalc($_timeArray, $_intervalArray[0]);
      break;
    case 'MINUTE':
      $_timeStr = $_date . ' ' . timeCalc($_timeArray, $_intervalArray[0] * 60);
      break;
    case 'HOUR':
      $_timeStr = $_date . ' ' . timeCalc($_timeArray, $_intervalArray[0] * 3600);
      break;
    case 'DAY':
      break;
    //case 'WEEK': from MySQL version 5.0.0
    //  break;
    case 'MONTH':
      break;
    case 'YEAR':
      break;
  }
  //print(' End:'.$dateTimeEnd.' Start:'.$_timeStr);
  $dif =  strtotime($_timeStr) - strtotime($dateTimeEnd);

  //print(' dif:'. $dif);
  return($_timeStr);
}

function timeCalc($time, $interval) { // interval in seconds
  $_sec = 0;
  $_min = 0;
  $_hours = 0;
  $_min = floor($interval / 60);
  //print( 'min:'.$_min);
  if ($_min > 60) {
    $_hours = floor($_min / 60);
    $_min %= 60;
  }
  $_sec = $interval - (60 * $_min + 3600 * $_hours);
  if (($time[2] + $_sec) > 59) {
    $_min += 1;
    $_sec = $_sec - 60;
  }
  if (($time[1] + $_min) > 59) {
    $_hours += 1;
    $_min = $_min - 60;
  }
  //print(' H:'.$_hours.' M:'.$_min.' S:'.$_sec);
  $time[0] = sprintf('%02d', $time[0] + $_hours);
  $time[1] = sprintf('%02d', $time[1] + $_min);
  $time[2] = sprintf('%02d', $time[2] + $_sec);
  $_timeStr = $time[0] . ':' . $time[1] . ':' . $time[2];
  //print(' tstr:'.$_timeStr);
  return($_timeStr);
}

// mkPassword by Max Dobbie-Holman
// Released under the GPL
// This file creates the username/password combos

/********************************************************************
*	Log client activity like login/logout and invalid login
* 20060216gr
* input: clientname, activity, permissions
*	return:	Null if successful
*********************************************************************/
function logClient($clientname='', $activity=0, $permissions=0) {
  global $params;
  $_result = Null;

  if (DB::isError($dbh = DB::Connect($params['dsn']))) {
    $db_errmsg = $dbh->getMessage();
    $retval = $db_errmsg;
  } else {
    $colnames = 'clientlog_id';
    $colvalues = "''";
    $colnames .= ', clientlog_action';
    $colvalues .= ', ' . $activity;
    $colnames .= ', clientlog_ccid';
    $colvalues .= ', ' . (defined('Phs_Ccid') ? Phs_Ccid : 0);
    $colnames .= ', clientlog_username';
    $colvalues .= ", '" . $clientname . "'";
    $colnames .= ', clientlog_permissions';
    $colvalues .= ', ' . $permissions;
    //$colnames .= ', clientlog_mdate';
    //$colvalues .= ', NOW()';
  
    $_query = 'INSERT INTO ' . PHS_DBTABLE_CLIENTLOG . ' (' . $colnames . ') VALUES (' . $colvalues . ')';
    //print($_query);exit;

    if (DB::isError($_rs = $dbh->Query($_query))) {
      $_result = 'Client Log insert failed';
    }
  }
  return ($_result);
}

/********************************************************************
*	Convert online seconds into Time string e.g. 2 Days 12 Hours 5 Minutes
* 20060221gr
* input: otime = online seconds, sflag=True = abbreviated
*	return:	Online Time string if successful, else Null
* refer to http://www.unc.edu/~rowlett/units/symbol.html for abbreviations
*********************************************************************/

function convertOnlineTime($olseconds=0, $sflag=false) {
  $_timeStr = Null;
  $_days = 0;
  $_hours = 0;
    // days
  if ($olseconds >= 86400 && ($_days = floor($olseconds / 86400)) > 0)
    $_timeStr .= $_days . ($sflag ? ' d' : ' Day' . ($_days > 1 ? 's' : '')) . ' ';
    // hours
  if ($olseconds >= 3600 && ($_hours = floor($olseconds / 3600)) > 0) {
    if (($_hours -= $_days * 24) > 0)
      $_timeStr .= $_hours . ($sflag ? ' h' : ' hour' . ($_hours > 1 ? 's' : '')) . ' ';
  }
    // minutes
  $_minutes = floor(($olseconds - $_days * 86400 - $_hours * 3600) / 60);
  if ($_minutes > 0)
    $_timeStr .= $_minutes . ($sflag ? ' min' : ' Minute' . ($_minutes > 1 ? 's' : ''));
  if ($olseconds < 60)
    $_timeStr .= $olseconds . ($sflag ? ' s' : ' Second' . ($olseconds > 1 ? 's' : ''));


  //$_timeStr .= ' online time assigned';

  return($_timeStr);
}


/********************************************************************
*	Read XML Country Code file
* 20060223gr
* input: filename incl path
*	return:	Array of country names and codes
* List from: 
* http://www.iso.org/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/index.html
* For German cc refer to DIN EN ISO 3166-1
*********************************************************************/
function getXMLCountryCodes($filename) 
{
   // read the XML database of countries
  $data = implode("", file($filename));
  $parser = xml_parser_create();
  xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
  xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
  xml_parse_into_struct($parser, $data, $values, $tags);
  xml_parser_free($parser);
  foreach ($tags as $key=>$val) {
    if ($key == 'ISO_3166-1_Entry') {
      $ranges = $val;
         // each contiguous pair of array entries
      for ($i=0; $i < count($ranges); $i+=2) {
        $offset = $ranges[$i] + 1;
        $len = $ranges[$i + 1] - $offset;
          //$tdb[] = parseCountry(array_slice($values, $offset, $len));
        $cvalues = array_slice($values, $offset, $len);
        //$cc[$cvalues[1]['value']] = $cvalues[0]['value'];
        $s=ereg_replace(197, "&Aring;",ucwords(strtolower($cvalues[0]['value'])));
        $cc[$cvalues[1]['value']] = $s;
      }
    } else {
      continue;
    }
  }
  return $cc;
}

/********************************************************************
*	Convert time string to seconds
* 20060313gr
* Using MySQL TIME Function date/time
* input: time string, e.g. 4 Minutes, 4 Hours, 1 day etc.
* SECOND
* MINUTE
* HOUR
* DAY
* MONTH (How many seconds in a month ? No, we do not support this format!)
* YEAR (How many seconds in a year ? No, we do not support this format!)
*********************************************************************/

function str2Seconds($timeStr='') {
  $result = 0;
  if (!empty($timeStr)) {
    $timeArr = explode(' ', $timeStr);
    switch(strtolower($timeArr[1])) {
      case 'second':
        $_result = $timeArr[0];
        break;
      case 'minute':
        $_result = 60 * $timeArr[0];
        break;
      case 'hour':
        $_result = 3600 * $timeArr[0];
        break;
      case 'day':
        $_result = 86400 * $timeArr[0];
        break;
      default:
        $_result = 0;
    }
  }
  return($_result);
}


/********************************************************************
*	Convert bytes into units like KB, MB, GB
* 20060315gr
* input: Octets (from radacct table)
* E.g. 1.2 KB, 4.3 MB, 4.3 GB
* 0.1 KB - 99.9 KB, 0.10 MB 99.9 MB, 0.10 GB - ....
* As soon over 100KB display in MB
* As soon over 100MB display in GB
* Keep output to 4 digits incl. dot
* Return : octString
* Allow base 10 and not 2:
* 1 KB = 1,000 bytes
* 1 MB = 1,000 KB
* 1 GB = 1,000 MB
*********************************************************************/

function octets2String($octets=0) {
  $_result = 0;

  if ($octets < 100000) { // KB
    // show in KB
    $_result = round(($octets / 1000), 2) . ' KB';
  } elseif ($octets < 1000000000) {
    $_result = round(($octets / 1000000), 2) . ' MB';
    // show in MB
  } else {
    // show in GB
    $_result = round(($octets / 1000000000), 2) . ' GB';
  }
  return($_result);
}

?>
