<?php
/********************************************************************
*	Hotspot Authentication, Authorization and Accounting System
*   pointHotspot.com - PHS
*
*	Module: 	init.inc.php
*	Function:	initialize environment, connect ot DB, init session
*
*	2005-09-04 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/
require_once ('PEAR.php');
require_once ('DB.php');
require('includes/configure-inc.php');
require('includes/phs-inc.php');
require_once('Pager/Pager.php');
require_once('../45/phs-const-inc.php');
//define ('PHS_LOCAL_TEST', true);
// DB set up
/*
if (defined ('PHS_LOCAL_TEST')) {
  $db_type = 'mysql';
  $db_user = 'root';
  $db_pass = 'carib';
  $db_name = 'poinths';
  $db_host = 'localhost';
} else {
  $db_type = 'mysql';
  //$db_pass = 'caribphs';
  //$db_name = 'poinths';
    // mokpa
  //$db_user = 'phsrem';
//  $db_host = '69.61.72.52';   // rad01.pointhotspot.com
  //$db_host = '64.34.161.183';   // rad01.pointhotspot.com
    // rad01
  //$db_user = 'phslocal';
  //$db_host = 'localhost';
}
*/


$params = array(
	'dsn' => $db_type.'://'.$db_user.':'.$db_pass.'@'.$db_host.'/'.$db_name,
	'dsn2' => $db_type.'://'.$db_user2.':'.$db_pass2.'@'.$db_host2.'/'.$db_name2,
	'table' => PHS_DBTABLE_CLIENT_CONTACT,
	'usernamecol' => 'client_contact_username',
	'passwordcol' => 'client_contact_password',
    'permissionscol' => 'client_contact_permissions'
);

//print_r($params);
/******************************************************************************
*	timing for performance testing
*******************************************************************************/
function getmicrotime() { 
    list($usec, $sec) = explode(" ",microtime()); 
    return ((float)$usec + (float)$sec); 
} 
/******************************************************************************
*	Access Control function ... called from every page and redirects user
*	to default login page in case user is not successfully authenticated
*	return user permissions
*   $Phs_AccessDisabled from messages.in.php file
*******************************************************************************/
function accessControl ($permission=0) {
  global $a, $dbc, $params, $Phs_AccessDisabled, $emsg, $username;
  $dbc = new ClientAuth($params);
  $a->setAuthData('Phs_BoxErrMsg', ''); // clear error message session var

  //if ((!$a->getAuth() || (!(($perm = $dbc->getPerm($a->getUsername())) & $permission))) && !$Phs_AccessDisabled) {
  if (!$a->getAuth() || (!(($perm = $dbc->getPerm($a->getUsername())) & $permission)))  {
    $lstatus = $a->getStatus();
    switch($a->getStatus()) {
    case AUTH_IDLED:
      $emsg = 'Idle timeout';
      break;
    case AUTH_EXPIRED:
      $emsg = 'Session expired';
      break;
    case AUTH_WRONG_LOGIN:
      $emsg = 'Invalid loginTT';
      break;
    default:
      if ($perm > 0) { // logged in?
        $emsg = 'Access denied ';
      }
    }
    $a->setAuthData('Phs_BoxErrMsg', $emsg);
    //print('emsg:'.$emsg.' un:'.$a->getUsername()); exit;
    //header('Location: login.php'. (!empty($emsg) ? '?emsg=' . $emsg : ''));
    header('Location: login.php');
    exit;
  }
    //print(' un:'.$a->getUsername());
 // print('perm:'.$perm);
  if ($Phs_AccessDisabled && !($perm & PHS_PERM_SUPADMIN)) {
    //$perm = PHS_PERM_DISABLED;
    $emsg = 'pointHotspot.com access currently disabled';
    if (substr($_SERVER['SCRIPT_NAME'], strlen(dirname($_SERVER['SCRIPT_NAME'])) +1) != 'index.php') {
      if ($perm > 0) { // logged in?
        $a->setAuthData('Phs_BoxErrMsg', $emsg);
        header('Location: main.php');
        //header('Location: main.php'. (!empty($emsg) ? '?emsg=' . $emsg : ''));
        exit;
      }
    }
  } 
  return ($perm);
}

function loginFunction($user='') {
//  global $Ugs_LeftMenuStr;
  global $smarty;

  $smarty->assign('Username', 'username');
  $smarty->assign('UsernameV', (isset($_POST['username']) ? $_POST['username'] : ''));
  $smarty->assign('Password', 'password');
//  $smarty->assign('Menu', $Ugs_LeftMenuStr);
}

/******************************************************************************
*   Faster array merge function than PHPs array_merge()
*   Appends array a2 to a1
*******************************************************************************/
function array_merge2($a1, $a2) {

   $a1size = sizeof($a1);
   $a2size = sizeof($a2);
   for ($ix=0; $ix < $a2size; $ix++) {
        //$a1[$a1size + $ix] = $a2[$ix];
        $a1[] = $a2[$ix];
   }
   return($a1);
}

// User online status
$userOnlineStatusArray = array(
    PHS_ST_ACTIVE => 'enabled',
    PHS_ST_SUSPENDED => 'suspended'
);

// Possible Billing Cycles
$Phs_BillingCycleArray = array(
    PHS_BILLING_NEW => 'Start New Cycle',
    PHS_BILLING_EXT => 'Extend Cycle',
    PHS_BILLING_NOBILL => 'No Billing',
    PHS_BILLING_REFUND => 'Refund',
    PHS_BILLING_FREE => 'Free Access'
);
    //PHS_ST_EXPIRED => 'expired'

/******************************************************************************
*   pointHotspot.com - Hotspot AAA (Authentication, Authorization and Accounting) System
*
*   Begin of Code Section
*
******************************************************************************/
/*
putenv("TZ=GMT +4");  // set to Port of Spain
$showdate   = date("l, j F Y \&\\n\b\s\p\;\&\\n\b\s\p\; g:i a"); 
$phs_ldate  = date(PHS_ISODATETIME);
define('PHS_LDATE', $phs_ldate);
define('PHS_YEAR', substr($phs_ldate, 0, 4));
define('PHS_MONTH', substr($phs_ldate, 5, 2));
define('PHS_DAY', substr($phs_ldate, 8, 2));
*/

    // get debug value from url
if (isset($_GET['_dbg'])) {
    $Phs_Debug = $_GET['_dbg'];
} else {
    $Phs_Debug = 0;
}
$Phs_Debug = 41;

	// reset info/error messages
$Phs_ErrMsg = '';
$Phs_BoxErrMsg = '';
$Phs_InfoMsg = '';
$Phs_BoxInfoMsg = '';
$process_error = False;
$nextpage = '';
$data = array('');

//$Phs_languages    = Array('English', 'German');
$Phs_languages    = Array('English');
$Phs_languagesIdx = Array('en');
//$Phs_languagesIdx = Array('en', 'de');


    // Initialize Presentation Layer Module
$smarty = new Smarty;
//$smarty->assign('Phs_Version', PHS_VERSION);
$smarty->assign('Phs_CompanyName', COMPANY_NAME);


// Check if user is logged in and registered
$a = new Auth('DB', $params, 'loginFunction', True);
$a->setIdle(3600);	// set idle timeout in seconds

    // special handling when exporting csv files 2003-04-30
//if (isset($_GET['exp'])) {
//  session_cache_limiter('private_no_expire');
//}

  // take over client operator name
if (isset($_POST['username']) && substr($_POST['username'], 0, 6) == 'admin@') {
  $superUsername = substr($_POST['username'], 6);
  $_POST['username'] = substr($_POST['username'], 0, 5);
  $a->setAuthData('Phs_SuperUsername', $superUsername);
}

$a->start();

//print(' noLog:'.$a->getAuthData('Phs_log')); 

//print('Sess:'.$a->getAuthData('Phs_InfoMg'));
$Phs_ErrMsg     = $a->getAuthData('Phs_ErrMsg');
$Phs_InfoMsg    = $a->getAuthData('Phs_InfoMsg');
$Phs_BoxErrMsg  = $a->getAuthData('Phs_BoxErrMsg');
$Phs_BoxInfoMsg = $a->getAuthData('Phs_BoxInfoMsg');
$Phs_NextPage   = $a->getAuthData('Phs_NextPage');
$Phs_PopUser    = $a->getAuthData('Phs_PopUser');

$Phs_SuperUsername = $a->getAuthData('Phs_SuperUsername');
//print(' inNxt:'.$Phs_NextPage);

//$a->setSessionName('PHS_SESSID');
//$a->setAdvancedSecurity(false);
$perm = PHS_PERM_DISABLED; // set default to disable

if ($a->getAuth()) { // logged in
  $dbc = new ClientAuth($params);
  if (empty($Phs_SuperUsername)) {
    $phs_username = $a->getUsername();
  } else {
    $phs_username = $Phs_SuperUsername;
  }
  
  $perm = $dbc->getPerm($phs_username);

    // disabled login
  if (($perm == PHS_PERM_DISABLED) &&  empty($Phs_BoxErrMsg)) {
    logClient($phs_username, PHS_LOGACT_LOGINATT, $perm);
    $a->setAuthData('Phs_BoxErrMsg', 'Login disabled');
    Header('Location: login.php');
    exit;
  }
  
  $phs_ccid = $dbc->getCcid($phs_username); // get user id for insert
  define('Phs_Ccid', $phs_ccid);

    // log a successful login
  if (!($a->getAuthData('Phs_log') == 'true')) {
    $a->setAuthData('Phs_log', 'true');
    //print(' Logged in - log now ');
    logClient($phs_username, PHS_LOGACT_LOGIN, $perm); 
  }

  if (($perm & PHS_PERM_SUPADMIN)) {
    define('PHS_ADMIN', True);
    $phs_nasArray[0]['nas_id'] = 0; // admin, full access
    $phs_nasArray[0]['nas_ssid'] = '';
    $phs_nasArray[0]['nas_channel'] = '';
    $phs_client_id = 0;
    //print('USER:'.$phs_username);
    $phs_client_info = $dbc->getClientInfo(0, $phs_username);
    //print_r($phs_client_info);
    define('PHS_SHOWPW', True);
    define('PHS_TIME24', True);
    define('PHS_REMOTE_SUSPEND', True);
    define('PHS_BILLING_ENABLED', True);
    define('PHS_MULTISITE', True);
  } else {
    $phs_client_info = $dbc->getClientInfo(0, $phs_username);
// temporary security to avoid that deleted admin users can take over admin functions - 20071010gr
    if ($phs_client_info == Null) {
      $a->setAuthData('Phs_BoxErrMsg', 'Invalid Login');
      $a->logout();
    }
    
    $phs_client_id = $phs_client_info['client_id'];
      // set time display format 24/12h
    define('PHS_TIME24', (PHS_M_CLIENT_TIME24 & $phs_client_info['client_contact_options'] ? True : False));
    define('PHS_SHOWPW', (PHS_M_CLIENT_SHOWPW & $phs_client_info['client_contact_options'] ? True : False));
      // allow remote user suspension? Admin only!
    //define('PHS_REMOTE_SUSPEND', ((PHS_M_CLIENT_SUSPEND & $phs_client_info['client_address_options']) && ($perm & PHS_PERM_ADMIN) ? True : False));
      // allow remote user suspension? All operators
    define('PHS_REMOTE_SUSPEND', ((PHS_M_CLIENT_SUSPEND & $phs_client_info['client_address_options']) ? True : False));
    define('PHS_BILLING_ENABLED', (PHS_M_CLIENT_BILLING & $phs_client_info['client_address_options'] ? True : False));
    define('PHS_MULTISITE', (PHS_M_CLIENT_MULTISITE & $phs_client_info['client_address_options'] ? True : False));
    define('PHS_MACRESTRICT', (PHS_M_CLIENT_MACRESTRICT & $phs_client_info['client_contact_options'] ? True : False));
    if (($phs_nasArray = $dbc->getNasInfo($phs_client_info['client_address_id'])) == Null) {
      $Phs_ErrMsg = 'NAS Info not found';
    }
  }
  define('PHS_CLIENT_ACODE', $phs_client_info['client_address_code']);
  define('PHS_CLIENT_TPRINTER', $phs_client_info['client_address_tprinter']); // ticket printer
  define('PHS_TZONE', $phs_client_info['client_address_tzone']);
  putenv('TZ=' . PHS_TZONE);  // activate timezone
  define('PHS_CLIENT_NOTES', $phs_client_info['client_address_notes']);

  if (PHS_TIME24) {
    $showdate   = date("D, j M Y \&\\n\b\s\p\; G:i"); 
  } else {
    $showdate   = date("D, j M Y \&\\n\b\s\p\; g:i a"); 
  }
  $smarty->assign('PhsDateTime', $showdate);
  $smarty->assign('Phs_Version', PHS_VERSION);
  $smarty->assign('Phs_Ssid', $phs_nasArray[0]['nas_ssid']);
  $smarty->assign('Phs_Channel', $phs_nasArray[0]['nas_channel']);

    // set global variables
  $phs_nas_id = $phs_nasArray[0]['nas_id'];
  define('PHS_CLIENT_ID', $phs_client_id);
  //print_r($nasArray);

  //print("User:".$phs_username);
  $smarty->assign('Phs_Username', $phs_username);
  /*
  if ($dbc->retval) {
      //print("Opening error for ClientAuth() in init ");
      $smarty->assign('Phs_ErrMsg', 'Opening error for ClientAuth() in init. Possible database down');
  } 
  */
  //	Print facilities
  $printoptions = '';
  if (isset($_GET['print'])) { // print report
      $smarty->assign('Phs_PrintFlag', True);
  } else {
      $smarty->assign('Phs_PrintFlag', False);
  }

  // set parameter array for PEAR Pager class
  $pageparams = array(
    'mode'        => 'Sliding',
    'perPage'     => 15,       // Number of items to display on each page
    'delta'       => 2,       // Number of page numbers before and after the current one
    'itemData'    => Null,
    'totalItems'  => 0,
    'prevImg'  => '<img src="images/arrow_point_left.gif" border="0" align="absmiddle">',
    'nextImg'  => '<img src="images/arrow_point_right.gif" border="0" align="absmiddle">',
  );
  $phs_PageStr = 'pageID';
  $from = (isset($_GET[$phs_PageStr]) && is_numeric($_GET[$phs_PageStr]) ? $_GET[$phs_PageStr] : 0);
  $maxpages=$pageparams['delta'];

  // assign info text
  //$smarty->assign('Phs_AdminMsg', $Phs_AdminMsg);
  //$smarty->assign('Phs_InfoText', nl2br($Phs_InfoText));
  define('PHS_LANGUAGE', 'en');
    // define language specific XML country code file
  define('PHS_COUNTRY_CODE_XML', 'lang/' . PHS_LANGUAGE . '/iso_3166-1_list_' . PHS_LANGUAGE . '.xml');

  $opPermIdx = Array(PHS_PERM_DISABLED, PHS_PERM_ADMIN, PHS_PERM_PUSER, PHS_PERM_USER);
  $opPermName = Array(PHS_PERM_DISABLED => 'Disabled', PHS_PERM_ADMIN => 'Admin', PHS_PERM_PUSER => 'PowerOp', PHS_PERM_USER => 'Operator');
  
} else { // end getAuth
  $smarty->assign('webmenu', True); // do not display SmartyMenu, use standard menu
  if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      // is a hotspot client
    $Phs_ipArray = explode('.', $_SERVER['HTTP_X_FORWARDED_FOR']); 
  /*-------------------------------------------------
   * Show logout Button and check online time only to hotspot users 
   * As Hotspot user IP address recognised:
   * 192.168.182.x
   * 172.30.0.x 
   * -----------------------------------------------*/
    if ($Phs_ipArray[0] == '192' || $Phs_ipArray[0] == '172') {
      if ($Phs_ipArray[1] == '168' || $Phs_ipArray[1] == '30') {
        if ($Phs_ipArray[2] == '182' || $Phs_ipArray[2] == '0') {
          // probably a hotspot client
          $smarty->assign('PhsLogoff', 'http://' . $Phs_ipArray[0] . '.' . $Phs_ipArray[1] . '.' . $Phs_ipArray[2] . '.1:3990/logoff');
        }
      }
    }
  }  
  //$smarty->assign('PhsLogoff', PHS_LOGOFF_182);
  define('PHS_TZONE', 'America/Port_of_Spain'); //default timezone
  putenv('TZ=' . PHS_TZONE);  // set to Port of Spain
}

//putenv('TZ=' . PHS_TZONE);  // set to Port of Spain
//$showdate   = date("l, j F Y \&\\n\b\s\p\;\&\\n\b\s\p\; g:i a"); 
$phs_ldate  = date(PHS_ISODATETIME);

define('PHS_LDATE', $phs_ldate);
define('PHS_YEAR', substr(PHS_LDATE, 0, 4));
define('PHS_MONTH', substr(PHS_LDATE, 5, 2));
define('PHS_DAY', substr(PHS_LDATE, 8, 2));
//print(PHS_TZONE);
$Phs_Page = $_SERVER['PHP_SELF'];

if (isset($_SERVER['HTTPS']) AND $_SERVER['HTTPS'] == 'on') {
        define('PHS_HTTPS', True);
        $smarty->assign('livesupportBaseUrl', PHS_LIVE_SUPPORT_BASEURL_HTTPS);
} else {
        define('PHS_HTTPS', False);
        $smarty->assign('livesupportBaseUrl', PHS_LIVE_SUPPORT_BASEURL);
}
/*
print('SELF:');
print_r($_SERVER['PHP_SELF']);
print('argv:');
print_r($_SERVER['argv']);
print('argc:');
print_r($_SERVER['argc']);
print(' GETarray: '); print_r($_GET);
*/
$Phs_GET = $_GET;   // central parameter input for future filtering purpose
$Phs_POST = $_POST;   // central parameter input for future filtering purpose

$logentry = "\n" . PHS_LDATE . ' : ' . $_SERVER['REMOTE_ADDR'] . ' : ' .  $_SERVER['REQUEST_URI'] . ' : ' . (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '0') . ':' . $_SERVER['HTTP_USER_AGENT'] . (defined('PHS_CLIENT_ID') ? ' : ' . PHS_CLIENT_ID : '') . (isset($phs_ccid) ? ' : ' . $phs_ccid : '') . (isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? ' : ' . $_SERVER['HTTP_X_FORWARDED_FOR'] : '');
error_log($logentry, 3, 'log/access' . PHS_YEAR . PHS_MONTH . '.log');

/****
  SmartyMenu init
****/
require_once('includes/menu-inc.php');

$smarty->assign('menu', $menu);

$starttime = getmicrotime(); // set performance start time 
?>
