<?php
/***************************************************************
*
*	Add Admin User
*	
*	2006-03-01 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN);

/*
Array
(
    [clientUsername] => 123
    [firstname] => 
    [lastname] => 
    [phone] => 
    [fax] => 
    [cell] => 
    [email] => 
    [lang_id] => en
    [timeFormat] => 24
    [password1] => 
    [password2] => 
    [uperm_id] => 8
    [submit2] => submit
)
*/
$_password = '';
$_pwchange = False;
$_uPerm = PHS_PERM_USER;
$a->setAuthData('Phs_NextPage', PHS_FILE_ADMUSERADD);

//print_r($phs_client_info);

if (($numAdmUsers = $dbc->getAdmUserNum($phs_client_info['client_id'])) >= $phs_client_info['client_address_maxop']) {
  $smarty->assign('maxUsersReached', True);
  $Phs_ErrMsg = 'Maximum number of admin users reached for this subscription. Upgrade your subscription!';
} else {  
  //print('Num:'.$numAdmUsers);

      // get default for this location
  $_timeFormat = (PHS_M_CLIENT_TIME24 & $phs_client_info['client_address_options'] ? '24' : '12');
  $_myLanguage = $phs_client_info['client_address_lang'];

  $_clientcontactid = $phs_client_info['client_contact_id'];
  $_rowin = Array();
//}

if (isset($Phs_POST['submit2'])) {
  //print_r($Phs_POST);

  $_AdminLoginId = trim($Phs_POST['clientUsername']);
  $_firstname = trim($Phs_POST['firstname']);
  $_lastname  = trim($Phs_POST['lastname']);
  $_phone     = trim($Phs_POST['phone']);
  $_fax       = trim($Phs_POST['fax']);
  $_mobile    = trim($Phs_POST['cell']);
  $_email     = trim($Phs_POST['email']);
  $_password1 = trim($Phs_POST['password1']);
  $_password2 = trim($Phs_POST['password2']);
  $_timeFormat = trim($Phs_POST['timeFormat']);
  $_myLanguage = trim($Phs_POST['lang_id']);
  $_uPerm     = $Phs_POST['uperm_id'];

  if (empty($_AdminLoginId)) {
    $Phs_ErrMsg = 'Admin Login Id missing';
    $process_error = True;
  } elseif (strlen($_AdminLoginId) < PHS_LEN_USER) {
    $Phs_ErrMsg = 'Login Id too short! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
    $process_error = True;
  } elseif (strlen($_AdminLoginId) > PHS_LEN_USER_MAX) {
    $Phs_ErrMsg = 'Login Id too long! Id must be between ' . PHS_LEN_USER . ' - ' . PHS_LEN_USER_MAX . ' characters';
    $process_error = True;
  } elseif (ereg('[^a-zA-Z0-9_.-]{1,}', $_AdminLoginId)) {
    $Phs_ErrMsg = 'Only use a-z, 0-9, _.- and no spaces for the Login Id';
    $process_error = True;
  } elseif (empty($_firstname)) {
    $Phs_ErrMsg = 'First Name missing';
    $process_error = True;
  } elseif (empty($_lastname)) {
    $Phs_ErrMsg = 'Last Name missing';
    $process_error = True;
    // password changed?
  } elseif (empty($_password1)) {
    $Phs_ErrMsg = 'Password missing';
    $process_error = True;
      // both passwords same
  } elseif ($_password1 <> $_password2) {
      $Phs_ErrMsg = 'Password mismatch';
      $process_error = True;
      // all is fine, save it now
    } elseif (strlen($_password1) < PHS_LEN_PW) {
      $Phs_ErrMsg = 'Password too short! Password must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (strlen($_password1) > PHS_LEN_PW_MAX) {
      $Phs_ErrMsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (ereg('[^a-zA-Z0-9_.-]{1,}', $_password1)) {
      $Phs_ErrMsg = 'Only use a-z, 0-9, _.- and no spaces for the password';
      $process_error = True;
    } //else {
      //$Phs_InfoMsg = 'Password changed';
      //$_pwchange = True;
      //print(' OKOKOK ');
    //}
  //} 
  
  //if (!$process_error) { 
    // all is fine, update record
    //print(' UPDATE DATA ');
//print($_clientcontactid); exit;
    $_rowin = array(
 //      'client_contact_id'          => $_clientcontactid,
       'client_contact_username'    => $_AdminLoginId,
       'client_contact_lastname'    => $_lastname,
       'client_contact_firstname'   => $_firstname,
       'client_contact_phone'       => $_phone,
       'client_contact_fax'         => $_fax,
       'client_contact_mobile'      => $_mobile,
       'client_contact_email'       => $_email,
       'client_contact_timeFormat'  => $_timeFormat,
       'client_contact_permissions' => $_uPerm,
       'client_contact_password'    => $_password1,
       'client_contact_lang'        => $_myLanguage,
       'client_contact_client_id'   => $phs_client_info['client_contact_client_id'],
       'client_contact_address_id'  => $phs_client_info['client_contact_address_id']

    );

  if (!$process_error) { 
    //print(' INSERT new admin user');
    if (($Phs_ErrMsg = $dbc->insertClientContact($_rowin)) <> Null) {
        // OK, we got an error
      $process_error = True;
    } else {
      $Phs_InfoMsg .= 'Admin Login Id ' .  ' added';
      $a->setAuthData('Phs_InfoMsg', $Phs_InfoMsg);
      header('Location: ' . PHS_FILE_ADMINUSERS);
      exit;
    }
  }
} 
if ($_timeFormat  == '24') {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; G:i"); 
  $smarty->assign('24hour', ' selected ');
} else {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; g:i a"); 
  $smarty->assign('12hour', ' selected ');
}
  // to display immediate change
$smarty->assign('PhsDateTime', $showdate);

//$smarty->assign('lang_idx', array('de','en'));
  // first language support code (hard coded)
$smarty->assign('lang_idx', $Phs_languagesIdx);
$smarty->assign('lang_names', $Phs_languages);
$smarty->assign('lang_id', $_myLanguage);

//$_password = PHS_PW_DUMMY; // only show dummy password in form

$smarty->assign('adminAccess', True);
$smarty->assign('addClientContact', True);
$smarty->assign('uperm_idx', $opPermIdx);
$smarty->assign('uperm_names', $opPermName);
$smarty->assign('uperm_id', $_uPerm); // set default level

$smarty->assign('_password', $_password);
$smarty->assign('clientInfo', $_rowin);
$smarty->assign('profileForm', True);
}
$smarty->assign('mainHeadline', 'Add new Admin User');
require_once('includes/trailer-inc.php');
$smarty->display('profile.tpl');
?>
